use clap::Args;
use crate::client::ApiClient;
use crate::error::CliResult;
use crate::global_config::GlobalConfig;

#[derive(Args)]
pub struct ModuleDeleteArgs {
    #[clap(long)]
    pub guild_id: u64,
    pub module_id: String
}

pub fn module_delete_command(args: ModuleDeleteArgs) -> CliResult {
    let token = GlobalConfig::read_or_default()?.token.unwrap();
    let client = ApiClient::new(token);
    let module = client.module_delete(args.guild_id, &args.module_id)?;

    println!("{:#?}", module);

    Ok(())
}
