use clap::{Args, Subcommand};

pub use module_deploy::*;
pub use module_get::*;
pub use module_list::*;
pub use module_delete::*;

mod module_deploy;
mod module_get;
mod module_list;
mod module_delete;

#[derive(Args)]
pub struct ModuleArgs {
    #[clap(subcommand)]
    pub command: ModuleCommand,
}

#[derive(Subcommand)]
pub enum ModuleCommand {
    /// Deploy a specific file as a Kite module (you usually want to use "publish" instead)
    Deploy(DeployArgs),
    List(ModuleListArgs),
    Get(ModuleGetArgs),
    Delete(ModuleDeleteArgs)
}

