use std::ops::Deref;

use clap::Args;

use crate::client::{API_BASE_URL, ApiClient};
use crate::error::CliResult;
use crate::global_config::GlobalConfig;

#[derive(Args)]
pub struct LoginArgs {
    #[clap(long, short)]
    pub token: Option<String>,
}

pub fn login_command(args: LoginArgs) -> CliResult {
    match args.token {
        None => {
            println!(
                "Use this URL to login to your Kite account: {}/auth/cli/redirect",
                API_BASE_URL.deref()
            );
            println!("After you have logged in with discord copy the token and run \"kite login --token <token>\"");
        }
        Some(token) => {
            let client = ApiClient::new(token.clone());
            let user = client.user_get("@me")?;

            let mut config = GlobalConfig::read_or_default()?;
            config.token = Some(token);
            config.flush()?;

            println!(
                "Successfully logged in as {}#{} ({})",
                user.username, user.discriminator, user.id
            );
        }
    }

    Ok(())
}
