use std::process::{Command, Stdio};

use clap::Args;

use crate::error::CliResult;
use crate::project_config::ProjectConfig;

#[derive(Args)]
pub struct BuildArgs {}

pub fn build_command(_: BuildArgs) -> CliResult {
    if let Some(command) = ProjectConfig::read()?.build.command {
        let mut parts = command.as_str().split(" ");

        let mut cmd = Command::new(parts.next().unwrap());

        for arg in parts {
            cmd.arg(arg);
        }

        cmd.stdout(Stdio::inherit())
            .stderr(Stdio::inherit())
            .spawn()
            .unwrap();
    } else {
        println!("No build command configured");
    }

    Ok(())
}
