use confy::ConfyError;
use crate::client::ApiError;

pub type CliResult = Result<(), CliError>;

#[derive(Debug, thiserror::Error)]
pub enum CliError {
    #[error("Config not found or invalid: {0}")]
    ConfigError(ConfyError),
    #[error("This command required authenticated (kite login)")]
    AuthenticatedRequired,
    #[error("API request failed: {0}")]
    ApiError(ApiError)
}

impl From<ConfyError> for CliError {
    fn from(e: ConfyError) -> Self {
        Self::ConfigError(e)
    }
}

impl From<ApiError> for CliError {
    fn from(e: ApiError) -> Self {
        Self::ApiError(e)
    }
}
