use clap::Args;

use crate::error::{CliError, CliResult};
use crate::global_config::GlobalConfig;
use crate::project_config::ProjectConfig;

#[derive(Args)]
pub struct PublishArgs {}

pub fn publish_command(_: PublishArgs) -> CliResult {
    let _ = ProjectConfig::read()?;
    let _ = GlobalConfig::read_or_default()?
        .token
        .ok_or(CliError::AuthenticatedRequired)?;

    println!("Publishing ...");
    Ok(())
}
