use clap::Args;
use crate::client::ApiClient;
use crate::error::CliResult;
use crate::global_config::GlobalConfig;

#[derive(Args)]
pub struct ModuleGetArgs {
    #[clap(long)]
    pub guild_id: u64,
    pub module_id: String
}

pub fn module_get_command(args: ModuleGetArgs) -> CliResult {
    let token = GlobalConfig::read_or_default()?.token.unwrap();
    let client = ApiClient::new(token);
    let module = client.module_get(args.guild_id, &args.module_id)?;

    println!("{:#?}", module);

    Ok(())
}
