use clap::{Subcommand};

pub use build::*;
pub use init::*;
pub use login::*;
pub use module::*;
pub use new::*;
pub use publish::*;

mod build;
mod init;
mod login;
mod module;
mod new;
mod publish;

#[derive(Subcommand)]
pub enum BaseCommand {
    /// Login with your Kite account
    Login(LoginArgs),
    /// Build the current project and prepare it for deployment (you usually want to use "publish" instead)
    Build(BuildArgs),
    /// Build & Deploy the current project as a Kite module
    Publish(PublishArgs),
    /// Initialize a Kite project in the current directory
    Init(InitArgs),
    /// Create a new Kite project
    New(NewArgs),

    Module(ModuleArgs)
}
