use std::env::current_dir;
use std::path::Path;

use clap::Args;
use nanoid::nanoid;
use crate::error::CliResult;

use crate::project_config::{PackageConfig, ProjectConfig, ProjectType, PROJECT_CONFIG_FILE, PROJECT_CONFIG_PATH, BuildConfig};

#[derive(Args)]
pub struct InitArgs {
    #[clap(long)]
    pub id: Option<String>,
    #[clap(long)]
    pub name: Option<String>,
    #[clap(long = "type", name = "type")]
    pub kind: Option<ProjectType>,
    #[clap(long)]
    pub guild_id: u64,
    #[clap(long)]
    pub overwrite: bool,
}

pub fn init_command(args: InitArgs) -> CliResult {
    if !args.overwrite && Path::new(PROJECT_CONFIG_PATH).exists() {
        println!(
            "There is already a {} file in this directory. Use --overwrite to overwrite it.",
            PROJECT_CONFIG_FILE
        );
        return Ok(());
    }

    let config = ProjectConfig {
        package: PackageConfig {
            id: args.id.unwrap_or_else(|| nanoid!()),
            name: args.name.unwrap_or_else(|| {
                // wtf
                current_dir()
                    .unwrap()
                    .components()
                    .last()
                    .unwrap()
                    .as_os_str()
                    .to_str()
                    .unwrap()
                    .to_string()
            }),
            kind: args.kind.unwrap_or_default(),
            guild_id: args.guild_id,
        },
        build: BuildConfig {
            command: Some(String::from("cargo build --release")),
            file: String::from("")
        }
    };

    config.flush()?;
    println!("Created {} file for your project", PROJECT_CONFIG_FILE);

    Ok(())
}
