# [WIP] KVS

Key Value Services is a cli tools that help to you create your Key-Value store services.

# Motivation

I want to create a content sharing tool that is managed by only one person and readable by many people in a secure network environment, so that I can use some common content in the terminal.

# Usage

1. Start kvs in your server

```bash
> kvs start
start finish.

you can use there commands to connect the service.
kvs connect http://xxx.xxx.xxx.xxx:pppp -r xxxxxxxx # as admin
kvs connect http://xxx.xxx.xxx.xxx:pppp # as user

tips: the random key stored to .random_key
```

2. Concent the kvs services from client
```bash
# connect the service as admin
> kvs login http://xxx.xxx.xxx.xxx:pppp -r xxxxxxxx
login successful as admin.

# connect the service as user
> kvs login http://xxx.xxx.xxx.xxx:pppp
login successful as user.
```


3. Create a key value (admin)
```
> kvs create foo --value="hello world"
```

4. Create a key and let file content as value (admin)
```
> kvs create biz --file ./content.txt
```

5. List all key in your services (admin & user)
```
> kvs ls
biz
foo
```

6. Remove a key (admin)
```
> kvs rm biz
```

7. Read a key (admin & user)
```
> kvs cat foo
hello world
```

# Example

Your team have a big list of resource id.

```bash
# important_resource_id.txt
...
A7EB0B7B-3E27-4531-B239-750300EE8D0C
B9164246-49E3-45F1-A8CE-D871CEBE3971
92312D9B-B2D8-4A92-B7B5-9A5491FF9BEC
8E1B24ED-0023-45E0-BF34-1548C8D8884D
...
```

Some times, the team member need create the url by the big list.

```bash
# important_resource_urls.txt
...
http://xxx.xxx.xxx.xxx/app/goods/A7EB0B7B-3E27-4531-B239-750300EE8D0C
http://xxx.xxx.xxx.xxx/app/goods/B9164246-49E3-45F1-A8CE-D871CEBE3971
http://xxx.xxx.xxx.xxx/app/goods/92312D9B-B2D8-4A92-B7B5-9A5491FF9BEC
http://xxx.xxx.xxx.xxx/app/goods/8E1B24ED-0023-45E0-BF34-1548C8D8884D
...
```

Let's assume we have written a command line tool named `transform` to handle this case.

```
cat important_resource_urls.txt | transform
```

The question is, how do I share `important_resource_urls.txt` with other team members.

Granted, there are many ways to share it. But you can fast finish it if you use the `kvs`.

```bash
# create the key
kvs create important_resource_urls -f important_resource_urls.txt

# and then, other team member can use it.
kvs cat important_resource_urls | transform
```