use std::marker::PhantomData;

pub struct ExactStructDefaultIter<T : Default + 'static>
{
    count : usize,
    _phantom : PhantomData<T>
}

impl<T : Default + 'static> ExactStructDefaultIter<T>
{
    pub fn new(count : usize) -> ExactStructDefaultIter<T>
    {
        ExactStructDefaultIter
        {
            count,
            _phantom : PhantomData
        }
    }
}

impl<T : Default + 'static> Iterator for ExactStructDefaultIter<T>
{
    type Item = T;

    fn next(&mut self) -> Option<Self::Item>
    {
        if self.count > 0
        {
            self.count -= 1;
            return Some(T::default());
        }

        None
    }
}

impl<T : Default + 'static> ExactSizeIterator for ExactStructDefaultIter<T>
{
    fn len(&self) -> usize
    {
        self.count
    }
}

impl<T : Default + 'static> DoubleEndedIterator for ExactStructDefaultIter<T>
{
    fn next_back(&mut self) -> Option<Self::Item>
    {
        if self.count > 0
        {
            self.count -= 1;
            return Some(T::default());
        }

        None
    }
}
