use imgui::{im_str, Window, Ui, ImString};
use keeshond::gameloop::GameControl;

use crate::editorgui::Packages;
use crate::wizard::{Wizard, WizardState};

use keeshond_datapack::DataHandle;
use keeshond_treats::tilemap::{Tileset, TilesetTile};

pub struct TilesetWizard
{
    package_name : ImString,
    item : ImString
}

impl Wizard for TilesetWizard
{
    fn window_title(&self) -> &'static str
    {
        "Tileset Wizard"
    }

    fn load(_game : &mut GameControl) -> Self where Self: Sized
    {
        TilesetWizard
        {
            package_name : ImString::with_capacity(4096),
            item : ImString::with_capacity(4096)
        }
    }

    fn do_ui(&mut self, packages : &mut Packages, game : &mut GameControl, window_builder : Window, ui : &mut Ui) -> WizardState
    {
        let mut state = WizardState::new();

        window_builder.build(ui, ||
        {
            ui.text_wrapped(im_str!("Tilesets are collections of background tiles, including their Sheet slices, collision, and other properties."));

            ui.spacing();
            ui.spacing();

            ui.input_text(im_str!("Package"), &mut self.package_name).build();
            ui.input_text(im_str!("Name (.json)"), &mut self.item).build();

            ui.spacing();
            ui.spacing();

            if ui.button(im_str!("Create New Tileset"), [0.0, 0.0])
            {
                let mut tileset = Tileset::new(DataHandle::default());

                tileset.insert_tile(0, TilesetTile::new(None));

                if self.make_resource(tileset, self.package_name.to_str(), &format!("{}.json", self.item), packages, game)
                {
                    state.open = false;
                }
            }
        });

        state
    }
}
