use imgui::{im_str, Window, Ui, ImString};

use keeshond::gameloop::GameControl;
use keeshond_treats::spawnable::SpawnableSet;

use crate::editorgui::{Packages};
use crate::wizard::{Wizard, WizardState};

pub struct SpawnableSetWizard
{
    package_name : ImString,
    item : ImString
}

impl Wizard for SpawnableSetWizard
{
    fn window_title(&self) -> &'static str
    {
        "SpawnableSet Wizard"
    }

    fn load(_game : &mut GameControl) -> Self where Self: Sized
    {
        SpawnableSetWizard
        {
            package_name : ImString::with_capacity(4096),
            item : ImString::with_capacity(4096)
        }
    }

    fn do_ui(&mut self, packages : &mut Packages, game : &mut GameControl, window_builder : Window, ui : &mut Ui) -> WizardState
    {
        let mut state = WizardState::new();

        window_builder.build(ui, ||
            {
                ui.text_wrapped(im_str!("SpawnableSets are lists of Spawnable objects including data \
                                            such as their Costumes, and other information."));

                ui.spacing();
                ui.spacing();

                ui.input_text(im_str!("Package"), &mut self.package_name).build();
                ui.input_text(im_str!("Name (.json)"), &mut self.item).build();

                ui.spacing();
                ui.spacing();

                if ui.button(im_str!("Create New SpawnableSet"), [0.0, 0.0])
                {
                    let spawnables = SpawnableSet::new();

                    if self.make_resource(spawnables, self.package_name.to_str(), &format!("{}.json", self.item), packages, game)
                    {
                        state.open = false;
                    }
                }
            });

        state
    }
}
