use imgui::{im_str, Window, Ui, ImString};

use keeshond::gameloop::GameControl;
use keeshond_treats::world::Level;

use crate::editorgui::{Packages};
use crate::wizard::{Wizard, WizardState};
use keeshond::util::BakedRect;

pub struct LevelWizard
{
    package_name : ImString,
    item : ImString,
    bounds_min : [f64; 2],
    bounds_max : [f64; 2]
}

impl Wizard for LevelWizard
{
    fn window_title(&self) -> &'static str
    {
        "Level Wizard"
    }

    fn load(_game : &mut GameControl) -> Self where Self: Sized
    {
        LevelWizard
        {
            package_name : ImString::with_capacity(4096),
            item : ImString::with_capacity(4096),
            bounds_min : [0.0, 0.0],
            bounds_max : [1280.0, 720.0]
        }
    }

    fn do_ui(&mut self, packages : &mut Packages, game : &mut GameControl, window_builder : Window, ui : &mut Ui) -> WizardState
    {
        let mut state = WizardState::new();

        window_builder.build(ui, ||
        {
            ui.text_wrapped(im_str!("Levels are arrangements of Spawnables you can load into your scene."));

            ui.spacing();
            ui.spacing();

            ui.input_text(im_str!("Package"), &mut self.package_name).build();
            ui.input_text(im_str!("Name (.keelvl)"), &mut self.item).build();

            ui.spacing();

            imgui::Drag::new(im_str!("Bounds Min")).display_format(im_str!("%.2f")).build_array(ui, &mut self.bounds_min);
            imgui::Drag::new(im_str!("Bounds Max")).display_format(im_str!("%.2f")).build_array(ui, &mut self.bounds_max);

            ui.spacing();
            ui.spacing();

            if ui.button(im_str!("Create New Level"), [0.0, 0.0])
            {
                let mut level = Level::new();
                level.set_bounds(BakedRect
                {
                    x1: self.bounds_min[0],
                    y1: self.bounds_min[1],
                    x2: self.bounds_max[0],
                    y2: self.bounds_max[1]
                });

                if self.make_resource(level, self.package_name.to_str(), &format!("{}.keelvl", self.item), packages, game)
                {
                    state.open = false;
                }
            }
        });

        state
    }
}
