use imgui::{im_str, Window, Ui, ImString};

use keeshond::gameloop::GameControl;
use keeshond_treats::visual::Costume;

use crate::editorgui::{Packages};
use crate::wizard::{Wizard, WizardState};

pub struct CostumeWizard
{
    package_name : ImString,
    item : ImString
}

impl Wizard for CostumeWizard
{
    fn window_title(&self) -> &'static str
    {
        "Costume Wizard"
    }

    fn load(_game : &mut GameControl) -> Self where Self: Sized
    {
        CostumeWizard
        {
            package_name : ImString::with_capacity(4096),
            item : ImString::with_capacity(4096)
        }
    }

    fn do_ui(&mut self, packages : &mut Packages, game : &mut GameControl, window_builder : Window, ui : &mut Ui) -> WizardState
    {
        let mut state = WizardState::new();

        window_builder.build(ui, ||
        {
            ui.text_wrapped(im_str!("Costumes are sprite animation sequences that can be used to represent objects. \
                            In code, give an entity an Actor component to allow it to use Costumes."));

            ui.spacing();
            ui.spacing();

            ui.input_text(im_str!("Package"), &mut self.package_name).build();
            ui.input_text(im_str!("Name (.json)"), &mut self.item).build();

            ui.spacing();
            ui.spacing();

            if ui.button(im_str!("Create New Costume"), [0.0, 0.0])
            {
                let costume = Costume::new();

                if self.make_resource(costume, self.package_name.to_str(), &format!("{}.json", self.item), packages, game)
                {
                    state.open = false;
                }
            }
        });

        state
    }
}
