#![cfg(feature = "parse-knuffel")]

use kdl_schema::{Schema, SCHEMA_SCHEMA};

mod helpers;
use helpers::DeepAssertEq;

#[test]
fn schema_loads() -> miette::Result<()> {
    let schema: Schema = knuffel::parse("kdl-schema.kdl", include_str!("kdl-schema.kdl"))?;
    DeepAssertEq::deep_assert_eq(&schema, &*SCHEMA_SCHEMA);
    Ok(())
}
