use kdl_schema::{Node, SCHEMA_SCHEMA};

#[test]
fn node_ref_proper() {
    assert_eq!(
        SCHEMA_SCHEMA
            .resolve_node_ref(r#"[id="tag-node"]"#)
            .unwrap()
            .name
            .as_deref(),
        Some("tag")
    );
}

#[test]
fn node_ref_missing() {
    assert_eq!(
        SCHEMA_SCHEMA.resolve_node_ref(r#"[id="not-in-there-lol"]"#),
        None
    );
}

#[test]
#[should_panic]
fn node_ref_malformed() {
    let _ = SCHEMA_SCHEMA.resolve_node_ref(r#"[description="hi"]"#);
}

#[test]
fn prop_ref_proper() {
    assert_eq!(
        SCHEMA_SCHEMA
            .resolve_prop_ref(r#"[id="info-time"]"#)
            .unwrap()
            .key
            .as_deref(),
        Some("time")
    );
}

#[test]
fn prop_ref_missing() {
    assert_eq!(
        SCHEMA_SCHEMA.resolve_prop_ref(r#"[id="not-in-there-lol"]"#),
        None
    );
}

#[test]
#[should_panic]
fn prop_ref_malformed() {
    let _ = SCHEMA_SCHEMA.resolve_prop_ref(r#"[description="hi"]"#);
}

#[test]
fn value_ref_proper() {
    assert_eq!(
        SCHEMA_SCHEMA
            .resolve_value_ref(r#"[id="info-person-name"]"#)
            .unwrap()
            .description
            .as_deref(),
        Some("Person name")
    );
}

#[test]
fn value_ref_missing() {
    assert_eq!(
        SCHEMA_SCHEMA.resolve_value_ref(r#"[id="not-in-there-lol"]"#),
        None
    );
}

#[test]
#[should_panic]
fn value_ref_malformed() {
    let _ = SCHEMA_SCHEMA.resolve_value_ref(r#"[description="hi"]"#);
}

#[test]
fn children_ref_proper() {
    assert_eq!(
        SCHEMA_SCHEMA
            .resolve_children_ref(r#"[id="validations"]"#)
            .unwrap()
            .description
            .as_deref(),
        Some("General value validations.")
    );
}

#[test]
fn children_ref_missing() {
    assert_eq!(
        SCHEMA_SCHEMA.resolve_children_ref(r#"[id="not-in-there-lol"]"#),
        None
    );
}

#[test]
#[should_panic]
fn children_ref_malformed() {
    let _ = SCHEMA_SCHEMA.resolve_children_ref(r#"[description="hi"]"#);
}

#[test]
fn all_schema_schema_refs_resolve() {
    fn all_refs_resolve(node: &Node) {
        if let Some(r#ref) = &node.ref_ {
            SCHEMA_SCHEMA
                .resolve_node_ref(r#ref)
                .unwrap_or_else(|| panic!("node ref {} not found", r#ref));
        } else {
            for prop in &node.props {
                if let Some(r#ref) = &prop.ref_ {
                    SCHEMA_SCHEMA
                        .resolve_prop_ref(r#ref)
                        .unwrap_or_else(|| panic!("prop ref {} not found", r#ref));
                }
            }
            for value in &node.values {
                if let Some(r#ref) = &value.ref_ {
                    SCHEMA_SCHEMA
                        .resolve_value_ref(r#ref)
                        .unwrap_or_else(|| panic!("value ref {} not found", r#ref));
                }
            }
            for children in &node.children {
                if let Some(r#ref) = &children.ref_ {
                    SCHEMA_SCHEMA
                        .resolve_children_ref(r#ref)
                        .unwrap_or_else(|| panic!("children ref {} not found", r#ref));
                } else {
                    for node in &children.nodes {
                        all_refs_resolve(node);
                    }
                }
            }
        }
    }
    for node in &SCHEMA_SCHEMA.document.nodes {
        all_refs_resolve(node);
    }
}
