use std::fmt::Debug;

use kdl_schema::*;

pub trait DeepAssertEq
where
    Self: PartialEq + Debug,
{
    fn deep_assert_eq(left: &Self, right: &Self) {
        assert_eq!(left, right);
    }
}

impl DeepAssertEq for Schema {
    fn deep_assert_eq(left: &Self, right: &Self) {
        DeepAssertEq::deep_assert_eq(&left.document, &right.document)
    }
}

impl DeepAssertEq for Document {
    fn deep_assert_eq(left: &Self, right: &Self) {
        DeepAssertEq::deep_assert_eq(&left.info, &right.info);
        DeepAssertEq::deep_assert_eq(&left.nodes, &right.nodes);
    }
}

impl<T: DeepAssertEq> DeepAssertEq for Vec<T> {
    fn deep_assert_eq(left: &Self, right: &Self) {
        for (left, right) in left.iter().zip(right.iter()) {
            DeepAssertEq::deep_assert_eq(left, right);
        }
        assert_eq!(left, right);
    }
}

impl DeepAssertEq for Info {}

impl DeepAssertEq for Node {
    fn deep_assert_eq(left: &Self, right: &Self) {
        DeepAssertEq::deep_assert_eq(&left.props, &right.props);
        DeepAssertEq::deep_assert_eq(&left.values, &right.values);
        DeepAssertEq::deep_assert_eq(&left.children, &right.children);
        assert_eq!(left, right);
    }
}

impl DeepAssertEq for Prop {}
impl DeepAssertEq for Value {}
impl DeepAssertEq for Children {
    fn deep_assert_eq(left: &Self, right: &Self) {
        DeepAssertEq::deep_assert_eq(&left.nodes, &right.nodes);
        assert_eq!(left, right);
    }
}
