#![warn(
    elided_lifetimes_in_paths,
    explicit_outlives_requirements,
    missing_debug_implementations,
    noop_method_call,
    single_use_lifetimes,
    trivial_casts,
    trivial_numeric_casts,
    unreachable_pub,
    unsafe_code,
    unused_qualifications
)]
#![warn(clippy::pedantic)]

use std::path::PathBuf;

use clap::Parser;
use kdl_schema::Schema;
use kdl_schema_check::CheckExt;
use miette::{IntoDiagnostic, Result};

/// Check if a KDL document matches a KDL schema
#[derive(Parser, Debug)]
#[clap(author, version, about, long_about = None)]
struct Args {
    /// Don't print a confirmation if validation succeeds
    #[clap(short, long)]
    quiet: bool,

    /// Path to schema KDL file
    schema: PathBuf,

    /// Path to document KDL file
    document: PathBuf,
}

fn main() -> Result<()> {
    let args = Args::parse();

    // TODO use kdl_schema file parse API
    let schema_data = std::fs::read_to_string(args.schema).into_diagnostic()?;
    let schema = Schema::parse(&schema_data)?;

    schema.check_file_matches(args.document)?;

    if !args.quiet {
        println!("Validation succeeded!");
    }

    Ok(())
}
