# kdl-schema-check

[KDL Schema](https://github.com/kdl-org/kdl/blob/1.0.0/SCHEMA-SPEC.md) document validation.

## examples

Library usage:

```rust
use kdl_schema::Schema;
use kdl_schema_check::CheckExt;

let schema_kdl = r#"
document {
    info {
        title "Sample Schema" lang="en"
        description "An example schema" lang="en"
        author "boringcactus"
    }
    node "name" {
        value {
            type "string"
        }
    }
    node "age" {
        value {
            type "number"
        }
    }
}
"#;
let schema = Schema::parse(schema_kdl).unwrap();
let document = r#"
name "Joe"
age 69
"#;
schema.check_text_matches("<sample document>", document)
    .expect("document validation failed");
```

Binary usage:

```text
$ cargo install kdl-schema-check
$ kdl-schema-check schema.kdl document.kdl
Validation succeeded!
```

## conditions blocking version 1.0.0

- return more than one error
- kdl-schema is at 1.0.0
- comprehensive tests for error reporting
- no TODOs left in code

## license

[Blue Oak Model License 1.0.0](https://blueoakcouncil.org/license/1.0.0).
