use crate::commands::*;
use clap::{ArgEnum, Parser};

const VERSION: &str = env!("CARGO_PKG_VERSION");

#[derive(Parser)]
#[clap(
    version = VERSION,
    author = "Qonfucius team <contact+kcfg@qonfucius.team>",
    license = "MIT",
    about = "Sometimes, you have to deal with many kubeconfig files. kcfg is here to help you !"
)]
/// Declares every available command and option of the program.
pub struct KcfgApp {
    #[clap(subcommand, arg_enum)]
    pub command: Command,
}

#[derive(Debug, ArgEnum, Parser)]
pub enum Command {
    /// Initializes the environment relative to your current path
    Init(command_init::InitOptions),
    /// Find and use the correct KUBECONFIG
    Use(command_use::UseOptions),
    /// Duplicates the current KUBECONFIG file and uses it as KUBECONFIG
    Fork(command_fork::ForkOption),
    /// Generates tab-completion script for your shell
    Completions(command_completions::CompletionOptions),
}
