#![forbid(missing_docs)]
#![deny(warnings)]
#![forbid(unsafe_code)]

//! kcfg

use crate::app::*;
use crate::commands::*;
use clap::Clap;
use std::process::exit;

mod app;
mod commands;
mod common;
mod error;

/// `KUBECONFIG` env var key
pub const KUBECONFIG: &str = "KUBECONFIG";

fn main() {
    let app: KcfgApp = KcfgApp::parse();

    let res = match app.command {
        Command::Init(params) => command_init::init(params),
        Command::Use(params) => command_use::router(params),
        Command::Fork(params) => command_fork::fork(params),
        Command::Completions(completion) => {
            completion.generate();
            Ok(String::new())
        }
    };
    match res {
        Ok(out) => println!("{}", out),
        Err(e) => {
            eprintln!("Error: {}", e);
            exit(e.exit_code())
        }
    }
}
