use crate::commands::*;
use clap::{AppSettings, ArgEnum, Clap};

const VERSION: &str = env!("CARGO_PKG_VERSION");

#[derive(Clap)]
#[clap(
version = VERSION,
author = "Qonfucius team <contact+kcfg@qonfucius.team>",
setting = AppSettings::ColoredHelp,
license = "MIT"
)]
/// Declares every available command and option of the program.
pub struct KcfgApp {
    #[clap(subcommand, arg_enum)]
    pub command: Command,
}

// TODO: remove this and move to Opts::about
/// Sometimes, you have to deal with many kubeconfig files. kcfg is here to help you !
#[derive(Clap, Debug, ArgEnum)]
pub enum Command {
    #[clap(setting = AppSettings::ColoredHelp)]
    /// Initializes the environment relative to your current path
    Init(command_init::InitOptions),
    #[clap(setting = AppSettings::ColoredHelp)]
    /// Find and use the correct KUBECONFIG
    Use(command_use::UseOptions),
    #[clap(setting = AppSettings::ColoredHelp)]
    /// Duplicates the current KUBECONFIG file and uses it as KUBECONFIG
    Fork(command_fork::ForkOption),
    #[clap(setting = AppSettings::ColoredHelp)]
    /// Generates tab-completion script for your shell
    Completions(command_completions::CompletionOptions),
}
