/*
 * $Id$
 *
 * Copyright (c) 2021, Purushottam A. Kulkarni.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation and
 * or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE
 *
 */

#[cfg(test)]
mod tests {
    use crate::akcipher::KcapiAKCipher;

    const PRIVKEY: [u8; 547] = [
        0x30, 0x82, 0x2, 0x1f, 0x2, 0x1, 0x1, 0x2, 0x82, 0x1, 0x0, 0xdb, 0x10, 0x1a, 0xc2, 0xa3,
        0xf1, 0xdc, 0xff, 0x13, 0x6b, 0xed, 0x44, 0xdf, 0xf0, 0x2, 0x6d, 0x13, 0xc7, 0x88, 0xda,
        0x70, 0x6b, 0x54, 0xf1, 0xe8, 0x27, 0xdc, 0xc3, 0xf, 0x99, 0x6a, 0xfa, 0xc6, 0x67, 0xff,
        0x1d, 0x1e, 0x3c, 0x1d, 0xc1, 0xb5, 0x5f, 0x6c, 0xc0, 0xb2, 0x7, 0x3a, 0x6d, 0x41, 0xe4,
        0x25, 0x99, 0xac, 0xfc, 0xd2, 0xf, 0x2, 0xd3, 0xd1, 0x54, 0x6, 0x1a, 0x51, 0x77, 0xbd,
        0xb6, 0xbf, 0xea, 0xa7, 0x5c, 0x6, 0xa9, 0x5d, 0x69, 0x84, 0x45, 0xd7, 0xf5, 0x5, 0xba,
        0x47, 0xf0, 0x1b, 0xd7, 0x2b, 0x24, 0xec, 0xcb, 0x9b, 0x1b, 0x10, 0x8d, 0x81, 0xa0, 0xbe,
        0xb1, 0x8c, 0x33, 0xe4, 0x36, 0xb8, 0x43, 0xeb, 0x19, 0x2a, 0x81, 0x8d, 0xde, 0x81, 0xa,
        0x99, 0x48, 0xb6, 0xf6, 0xbc, 0xcd, 0x49, 0x34, 0x3a, 0x8f, 0x26, 0x94, 0xe3, 0x28, 0x82,
        0x1a, 0x7c, 0x8f, 0x59, 0x9f, 0x45, 0xe8, 0x5d, 0x1a, 0x45, 0x76, 0x4, 0x56, 0x5, 0xa1,
        0xd0, 0x1b, 0x8c, 0x77, 0x6d, 0xaf, 0x53, 0xfa, 0x71, 0xe2, 0x67, 0xe0, 0x9a, 0xfe, 0x3,
        0xa9, 0x85, 0xd2, 0xc9, 0xaa, 0xba, 0x2a, 0xbc, 0xf4, 0xa0, 0x8, 0xf5, 0x13, 0x98, 0x13,
        0x5d, 0xf0, 0xd9, 0x33, 0x34, 0x2a, 0x61, 0xc3, 0x89, 0x55, 0xf0, 0xae, 0x1a, 0x9c, 0x22,
        0xee, 0x19, 0x5, 0x8d, 0x32, 0xfe, 0xec, 0x9c, 0x84, 0xba, 0xb7, 0xf9, 0x6c, 0x3a, 0x4f,
        0x7, 0xfc, 0x45, 0xeb, 0x12, 0xe5, 0x7b, 0xfd, 0x55, 0xe6, 0x29, 0x69, 0xd1, 0xc2, 0xe8,
        0xb9, 0x78, 0x59, 0xf6, 0x79, 0x10, 0xc6, 0x4e, 0xeb, 0x6a, 0x5e, 0xb9, 0x9a, 0xc7, 0xc4,
        0x5b, 0x63, 0xda, 0xa3, 0x3f, 0x5e, 0x92, 0x7a, 0x81, 0x5e, 0xd6, 0xb0, 0xe2, 0x62, 0x8f,
        0x74, 0x26, 0xc2, 0xc, 0xd3, 0x9a, 0x17, 0x47, 0xe6, 0x8e, 0xab, 0x2, 0x3, 0x1, 0x0, 0x1,
        0x2, 0x82, 0x1, 0x0, 0x52, 0x41, 0xf4, 0xda, 0x7b, 0xb7, 0x59, 0x55, 0xca, 0xd4, 0x2f, 0xf,
        0x3a, 0xcb, 0xa4, 0xd, 0x93, 0x6c, 0xcc, 0x9d, 0xc1, 0xb2, 0xfb, 0xfd, 0xae, 0x40, 0x31,
        0xac, 0x69, 0x52, 0x21, 0x92, 0xb3, 0x27, 0xdf, 0xea, 0xee, 0x2c, 0x82, 0xbb, 0xf7, 0x40,
        0x32, 0xd5, 0x14, 0xc4, 0x94, 0x12, 0xec, 0xb8, 0x1f, 0xca, 0x59, 0xe3, 0xc1, 0x78, 0xf3,
        0x85, 0xd8, 0x47, 0xa5, 0xd7, 0x2, 0x1a, 0x65, 0x79, 0x97, 0xd, 0x24, 0xf4, 0xf0, 0x67,
        0x6e, 0x75, 0x2d, 0xbf, 0x10, 0x3d, 0xa8, 0x7d, 0xef, 0x7f, 0x60, 0xe4, 0xe6, 0x5, 0x82,
        0x89, 0x5d, 0xdf, 0xc6, 0xd2, 0x6c, 0x7, 0x91, 0x33, 0x98, 0x42, 0xf0, 0x2, 0x0, 0x25,
        0x38, 0xc5, 0x85, 0x69, 0x8a, 0x7d, 0x2f, 0x95, 0x6c, 0x43, 0x9a, 0xb8, 0x81, 0xe2, 0xd0,
        0x7, 0x35, 0xaa, 0x5, 0x41, 0xc9, 0x1e, 0xaf, 0xe4, 0x4, 0x3b, 0x19, 0xb8, 0x73, 0xa2,
        0xac, 0x4b, 0x1e, 0x66, 0x48, 0xd8, 0x72, 0x1f, 0xac, 0xf6, 0xcb, 0xbc, 0x90, 0x9, 0xca,
        0xec, 0xc, 0xdc, 0xf9, 0x2c, 0xd7, 0xeb, 0xae, 0xa3, 0xa4, 0x47, 0xd7, 0x33, 0x2f, 0x8a,
        0xca, 0xbc, 0x5e, 0xf0, 0x77, 0xe4, 0x97, 0x98, 0x97, 0xc7, 0x10, 0x91, 0x7d, 0x2a, 0xa6,
        0xff, 0x46, 0x83, 0x97, 0xde, 0xe9, 0xe2, 0x17, 0x3, 0x6, 0x14, 0xe2, 0xd7, 0xb1, 0x1d,
        0x77, 0xaf, 0x51, 0x27, 0x5b, 0x5e, 0x69, 0xb8, 0x81, 0xe6, 0x11, 0xc5, 0x43, 0x23, 0x81,
        0x4, 0x62, 0xff, 0xe9, 0x46, 0xb8, 0xd8, 0x44, 0xdb, 0xa5, 0xcc, 0x31, 0x54, 0x34, 0xce,
        0x3e, 0x82, 0xd6, 0xbf, 0x7a, 0xb, 0x64, 0x21, 0x6d, 0x88, 0x7e, 0x5b, 0x45, 0x12, 0x1e,
        0x63, 0x8d, 0x49, 0xa7, 0x1d, 0xd9, 0x1e, 0x6, 0xcd, 0xe8, 0xba, 0x2c, 0x8c, 0x69, 0x32,
        0xea, 0xbe, 0x60, 0x71, 0x2, 0x1, 0x0, 0x2, 0x1, 0x0, 0x2, 0x1, 0x0, 0x2, 0x1, 0x0, 0x2,
        0x1, 0x0,
    ];

    const PUBKEY: [u8; 269] = [
        0x30, 0x82, 0x1, 0x9, 0x2, 0x82, 0x1, 0x0, 0xdb, 0x10, 0x1a, 0xc2, 0xa3, 0xf1, 0xdc, 0xff,
        0x13, 0x6b, 0xed, 0x44, 0xdf, 0xf0, 0x2, 0x6d, 0x13, 0xc7, 0x88, 0xda, 0x70, 0x6b, 0x54,
        0xf1, 0xe8, 0x27, 0xdc, 0xc3, 0xf, 0x99, 0x6a, 0xfa, 0xc6, 0x67, 0xff, 0x1d, 0x1e, 0x3c,
        0x1d, 0xc1, 0xb5, 0x5f, 0x6c, 0xc0, 0xb2, 0x7, 0x3a, 0x6d, 0x41, 0xe4, 0x25, 0x99, 0xac,
        0xfc, 0xd2, 0xf, 0x2, 0xd3, 0xd1, 0x54, 0x6, 0x1a, 0x51, 0x77, 0xbd, 0xb6, 0xbf, 0xea,
        0xa7, 0x5c, 0x6, 0xa9, 0x5d, 0x69, 0x84, 0x45, 0xd7, 0xf5, 0x5, 0xba, 0x47, 0xf0, 0x1b,
        0xd7, 0x2b, 0x24, 0xec, 0xcb, 0x9b, 0x1b, 0x10, 0x8d, 0x81, 0xa0, 0xbe, 0xb1, 0x8c, 0x33,
        0xe4, 0x36, 0xb8, 0x43, 0xeb, 0x19, 0x2a, 0x81, 0x8d, 0xde, 0x81, 0xa, 0x99, 0x48, 0xb6,
        0xf6, 0xbc, 0xcd, 0x49, 0x34, 0x3a, 0x8f, 0x26, 0x94, 0xe3, 0x28, 0x82, 0x1a, 0x7c, 0x8f,
        0x59, 0x9f, 0x45, 0xe8, 0x5d, 0x1a, 0x45, 0x76, 0x4, 0x56, 0x5, 0xa1, 0xd0, 0x1b, 0x8c,
        0x77, 0x6d, 0xaf, 0x53, 0xfa, 0x71, 0xe2, 0x67, 0xe0, 0x9a, 0xfe, 0x3, 0xa9, 0x85, 0xd2,
        0xc9, 0xaa, 0xba, 0x2a, 0xbc, 0xf4, 0xa0, 0x8, 0xf5, 0x13, 0x98, 0x13, 0x5d, 0xf0, 0xd9,
        0x33, 0x34, 0x2a, 0x61, 0xc3, 0x89, 0x55, 0xf0, 0xae, 0x1a, 0x9c, 0x22, 0xee, 0x19, 0x5,
        0x8d, 0x32, 0xfe, 0xec, 0x9c, 0x84, 0xba, 0xb7, 0xf9, 0x6c, 0x3a, 0x4f, 0x7, 0xfc, 0x45,
        0xeb, 0x12, 0xe5, 0x7b, 0xfd, 0x55, 0xe6, 0x29, 0x69, 0xd1, 0xc2, 0xe8, 0xb9, 0x78, 0x59,
        0xf6, 0x79, 0x10, 0xc6, 0x4e, 0xeb, 0x6a, 0x5e, 0xb9, 0x9a, 0xc7, 0xc4, 0x5b, 0x63, 0xda,
        0xa3, 0x3f, 0x5e, 0x92, 0x7a, 0x81, 0x5e, 0xd6, 0xb0, 0xe2, 0x62, 0x8f, 0x74, 0x26, 0xc2,
        0xc, 0xd3, 0x9a, 0x17, 0x47, 0xe6, 0x8e, 0xab, 0x2, 0x3, 0x1, 0x0, 0x1,
    ];

    const PT: [u8; 8] = [0x54, 0x85, 0x9b, 0x34, 0x2c, 0x49, 0xea, 0x2a];

    const CT: [u8; 256] = [
        0xb2, 0x97, 0x76, 0xb4, 0xae, 0x3e, 0x38, 0x3c, 0x7e, 0x64, 0x1f, 0xcc, 0xa2, 0x7f, 0xf6,
        0xbe, 0xcf, 0x49, 0xbc, 0x48, 0xd3, 0x6c, 0x8f, 0xa, 0xe, 0xc1, 0x73, 0xbd, 0x7b, 0x55,
        0x79, 0x36, 0xe, 0xa1, 0x87, 0x88, 0xb9, 0x2c, 0x90, 0xa6, 0x53, 0x5e, 0xe9, 0xef, 0xc4,
        0xe2, 0x4d, 0xdd, 0xf7, 0xa6, 0x69, 0x82, 0x3f, 0x56, 0xa4, 0x7b, 0xfb, 0x62, 0xe0, 0xae,
        0xb8, 0xd3, 0x4, 0xb3, 0xac, 0x5a, 0x15, 0x2a, 0xe3, 0x19, 0x9b, 0x3, 0x9a, 0xb, 0x41,
        0xda, 0x64, 0xec, 0xa, 0x69, 0xfc, 0xf2, 0x10, 0x92, 0xf3, 0xc1, 0xbf, 0x84, 0x7f, 0xfd,
        0x2c, 0xae, 0xc8, 0xb5, 0xf6, 0x41, 0x70, 0xc5, 0x47, 0x3, 0x8a, 0xf8, 0xff, 0x6f, 0x3f,
        0xd2, 0x6f, 0x9, 0xb4, 0x22, 0xf3, 0x30, 0xbe, 0xa9, 0x85, 0xcb, 0x9c, 0x8d, 0xf9, 0x8f,
        0xeb, 0x32, 0x91, 0xa2, 0x25, 0x84, 0x8f, 0xf5, 0xdc, 0xc7, 0x6, 0x9c, 0x2d, 0xe5, 0x11,
        0x2c, 0x9, 0x9, 0x87, 0x9, 0xa9, 0xf6, 0x33, 0x73, 0x90, 0xf1, 0x60, 0xf2, 0x65, 0xdd,
        0x30, 0xa5, 0x66, 0xce, 0x62, 0x7b, 0xd0, 0xf8, 0x2d, 0x3d, 0x19, 0x82, 0x77, 0xe3, 0xa,
        0x5f, 0x75, 0x2f, 0x8e, 0xb1, 0xe5, 0xe8, 0x91, 0x35, 0x1b, 0x3b, 0x33, 0xb7, 0x66, 0x92,
        0xd1, 0xf2, 0x8e, 0x6f, 0xe5, 0x75, 0xc, 0xad, 0x36, 0xfb, 0x4e, 0xd0, 0x66, 0x61, 0xbd,
        0x49, 0xfe, 0xf4, 0x1a, 0xa2, 0x2b, 0x49, 0xfe, 0x3, 0x4c, 0x74, 0x47, 0x8d, 0x9a, 0x66,
        0xb2, 0x49, 0x46, 0x4d, 0x77, 0xea, 0x33, 0x4d, 0x6b, 0x3c, 0xb4, 0x49, 0x4a, 0xc6, 0x7d,
        0x3d, 0xb5, 0xb9, 0x56, 0x41, 0x15, 0x67, 0xf, 0x94, 0x3c, 0x93, 0x65, 0x27, 0xe0, 0x21,
        0x5d, 0x59, 0xc3, 0x62, 0xd5, 0xa6, 0xda, 0x38, 0x26, 0x22, 0x5e, 0x34, 0x1c, 0x94, 0xaf,
        0x98,
    ];

    const SIG: [u8; 256] = [
        0x54, 0x9c, 0xdb, 0xa1, 0x91, 0x6b, 0xc6, 0x74, 0x1, 0xb2, 0xb4, 0x7c, 0x4d, 0xfc, 0xca,
        0x9c, 0x47, 0xdd, 0x5b, 0x41, 0x71, 0x49, 0x83, 0xe3, 0x74, 0xc1, 0x8, 0x2e, 0xab, 0x98,
        0xbc, 0xee, 0xf1, 0x63, 0x1, 0x3a, 0x79, 0xe2, 0xf6, 0x5b, 0x4d, 0xc1, 0xa3, 0xfb, 0xff,
        0xa2, 0xae, 0xf7, 0x7f, 0xcb, 0x67, 0x20, 0x32, 0xc1, 0xda, 0x35, 0xd7, 0xae, 0xe0, 0xf1,
        0x72, 0xbc, 0x8d, 0xdd, 0xf, 0x9, 0xe9, 0xc, 0x4f, 0xd6, 0x93, 0x8a, 0x28, 0x6b, 0x33,
        0xc9, 0xe0, 0xd9, 0x3c, 0x8, 0x7, 0x46, 0x9f, 0x8f, 0x7a, 0xd6, 0x92, 0x99, 0x5e, 0x4b,
        0x4e, 0xb0, 0xc3, 0x21, 0xa6, 0xbe, 0x94, 0xc9, 0x62, 0x6f, 0xe7, 0x6f, 0x3a, 0xb1, 0x39,
        0x2d, 0x59, 0x69, 0x78, 0xe8, 0x88, 0x95, 0x7e, 0xf5, 0xb1, 0x21, 0xf4, 0xd8, 0x38, 0xa7,
        0x62, 0xce, 0x33, 0x75, 0x35, 0x76, 0xaa, 0xc5, 0x96, 0xc4, 0xcb, 0x4e, 0x1, 0xd4, 0x29,
        0xb7, 0x97, 0xbe, 0x92, 0xa1, 0xd9, 0x86, 0x72, 0xc2, 0x96, 0xda, 0x5a, 0x8f, 0x59, 0x64,
        0xd6, 0xa7, 0x4, 0x22, 0xbc, 0xc6, 0x7e, 0x10, 0x21, 0x11, 0x3d, 0xa5, 0xe3, 0x67, 0x75,
        0x5e, 0x7a, 0xdd, 0x3a, 0x44, 0x1a, 0x98, 0xc3, 0xf3, 0x3b, 0xa1, 0x0, 0xe1, 0x92, 0x6c,
        0x8, 0xb, 0x7c, 0x75, 0xcc, 0xb3, 0x8f, 0xe1, 0xab, 0xf3, 0xd9, 0xda, 0xa3, 0x36, 0xce,
        0x24, 0x2e, 0xf7, 0x95, 0xb7, 0x7e, 0x86, 0x23, 0x30, 0x7b, 0xd, 0x58, 0x5f, 0x48, 0x5e,
        0x1e, 0x23, 0x5c, 0x5e, 0x3c, 0x8a, 0x4c, 0x84, 0xcc, 0xb6, 0x3b, 0xab, 0x4d, 0x8c, 0xdd,
        0x69, 0x86, 0x20, 0x34, 0xfb, 0x3e, 0xa6, 0x83, 0x33, 0xab, 0x9a, 0xdb, 0x59, 0x2d, 0xf2,
        0x9f, 0xd7, 0x64, 0x78, 0x2d, 0x80, 0xa9, 0xad, 0x58, 0x5b, 0xc4, 0xe, 0x1d, 0x7e, 0x73,
        0xf7,
    ];

    #[test]
    #[ignore]
    fn test_akcipher_encrypt() {
        let mut handle = match KcapiAKCipher::new("rsa", 0) {
            Ok(handle) => handle,
            Err(e) => panic!("{}", e),
        };

        match handle.setpubkey(PUBKEY.to_vec()) {
            Ok(()) => {}
            Err(e) => panic!("{}", e),
        };

        let out = match handle.encrypt(PT.to_vec(), crate::ACCESS_HEURISTIC) {
            Ok(out) => out,
            Err(e) => panic!("{}", e),
        };
        assert_eq!(CT.to_vec(), out);
    }

    #[test]
    #[ignore]
    fn test_akcipher_decrypt() {
        let mut handle = match KcapiAKCipher::new("rsa", 0) {
            Ok(handle) => handle,
            Err(e) => panic!("{}", e),
        };
        match handle.setprivkey(PRIVKEY.to_vec()) {
            Ok(()) => {}
            Err(e) => panic!("{}", e),
        };

        let out = match handle.decrypt(CT.to_vec(), crate::ACCESS_HEURISTIC) {
            Ok(out) => out,
            Err(e) => panic!("{}", e),
        };
        let mut out_exp = Vec::new();
        out_exp.extend(vec![0u8; handle.modsize - PT.len()].iter().copied());
        out_exp.extend(PT.iter().copied());
        assert_eq!(out_exp, out);
    }

    #[test]
    #[ignore]
    fn test_akcipher_sign() {
        let mut handle = match KcapiAKCipher::new("pkcs1pad(rsa-generic,sha256)", 0) {
            Ok(handle) => handle,
            Err(e) => panic!("{}", e),
        };
        match handle.setprivkey(PRIVKEY.to_vec()) {
            Ok(()) => {}
            Err(e) => panic!("{}", e),
        };

        let digest = match crate::md::sha256(PT.to_vec()) {
            Ok(digest) => digest,
            Err(e) => panic!("{}", e),
        };

        let out = match handle.sign(digest.to_vec(), crate::ACCESS_HEURISTIC) {
            Ok(sig) => sig,
            Err(e) => panic!("{}", e),
        };
        assert_eq!(SIG.to_vec(), out);
    }

    #[test]
    #[ignore]
    fn test_akcipher_verify() {
        let mut handle = match KcapiAKCipher::new("pkcs1pad(rsa-generic,sha256)", 0) {
            Ok(handle) => handle,
            Err(e) => panic!("{}", e),
        };

        let digest = match crate::md::sha256(PT.to_vec()) {
            Ok(digest) => digest,
            Err(e) => panic!("{}", e),
        };

        match handle.setpubkey(PUBKEY.to_vec()) {
            Ok(()) => {}
            Err(e) => panic!("{}", e),
        };

        match handle.verify(digest.to_vec(), SIG.to_vec(), crate::ACCESS_HEURISTIC) {
            Ok(()) => {}
            Err(e) => panic!("{}", e),
        };
    }

    #[test]
    #[ignore]
    fn test_akcipher_verify_sig_fail() {
        let mut handle = match KcapiAKCipher::new("pkcs1pad(rsa-generic,sha256)", 0) {
            Ok(handle) => handle,
            Err(e) => panic!("{}", e),
        };

        let digest = match crate::md::sha256(PT.to_vec()) {
            Ok(digest) => digest,
            Err(e) => panic!("{}", e),
        };

        match handle.setpubkey(PUBKEY.to_vec()) {
            Ok(()) => {}
            Err(e) => panic!("{}", e),
        };

        let mut sig = SIG.to_vec().clone();
        sig[SIG.len() - 1] ^= 0x01;
        match handle.verify(digest.to_vec(), sig, crate::ACCESS_HEURISTIC) {
            Ok(()) => panic!("(BUG) Invalid signature successfully verified!"),
            Err(_e) => {}
        };
    }

    #[test]
    #[ignore]
    fn test_akcipher_verify_digest_fail() {
        let mut handle = match KcapiAKCipher::new("pkcs1pad(rsa-generic,sha256)", 0) {
            Ok(handle) => handle,
            Err(e) => panic!("{}", e),
        };

        let mut digest = match crate::md::sha256(PT.to_vec()) {
            Ok(digest) => digest,
            Err(e) => panic!("{}", e),
        };
        digest[31] ^= 0x01;

        match handle.setpubkey(PUBKEY.to_vec()) {
            Ok(()) => {}
            Err(e) => panic!("{}", e),
        };

        match handle.verify(digest.to_vec(), SIG.to_vec(), crate::ACCESS_HEURISTIC) {
            Ok(()) => panic!("(BUG) Signature on invalid digest successfully verified!"),
            Err(_e) => {}
        };
    }

    #[test]
    #[ignore]
    fn test_akcipher_verify_key_fail() {
        let mut handle = match KcapiAKCipher::new("pkcs1pad(rsa-generic,sha256)", 0) {
            Ok(handle) => handle,
            Err(e) => panic!("{}", e),
        };

        let digest = match crate::md::sha256(PT.to_vec()) {
            Ok(digest) => digest,
            Err(e) => panic!("{}", e),
        };

        let mut pubkey = PUBKEY.to_vec().clone();
        pubkey[PUBKEY.len() - 1] ^= 0x01;
        match handle.setpubkey(pubkey) {
            Ok(()) => {}
            Err(e) => panic!("{}", e),
        };

        match handle.verify(digest.to_vec(), SIG.to_vec(), crate::ACCESS_HEURISTIC) {
            Ok(()) => panic!("(BUG) Signature successfully verified with invalid key!"),
            Err(_e) => {}
        };
    }
}
