[![crate](https://img.shields.io/badge/crates.io-katexit-blue)](https://crates.io/crates/katexit)
[![docs.rs](https://docs.rs/katexit/badge.svg)](https://docs.rs/katexit)

Insert KaTeX autorender script into rustdoc

Usage
-----

```rust
#[cfg_attr(doc, katexit::katexit)]
/// We can write $\LaTeX$ expressions
///
/// Display style
/// -------------
///
/// $$
/// c = \\pm\\sqrt{a^2 + b^2}
/// $$
pub fn my_func() {}
```

See rendered result on [docs.rs](https://docs.rs/katexit-example/0.1.0/katexit_example/fn.my_func.html).

[katex-functions]: https://katex.org/docs/supported.html
[katex-symbols]: https://katex.org/docs/support_table.html

How it works
-------------

`#[katexit]` proc-macro inserts [KaTeX autorender script][autorender] as `#[doc = "{script}"]`.
Since the markdown to HTML translator of rustdoc do not touch HTML partitions embedded in markdown,
they will be passed as it is to the browser.
The autorender script starts rendering the math expression enclosed by `$` written in the document section
when you open the page generated by rustdoc, i.e. this does not work offline.

[autorender]: https://katex.org/docs/autorender.html
