# KASM
![GitHub Workflow Status](https://img.shields.io/github/workflow/status/newcomb-luke/kOS-KASM/Rust%20CI?label=build)
[![Libraries.io dependency status for GitHub repo](https://img.shields.io/librariesio/github/newcomb-luke/kOS-KASM)](https://deps.rs/repo/github/newcomb-luke/kOS-KASM)
![GitHub](https://img.shields.io/github/license/newcomb-luke/kOS-KASM)

![Crates.io](https://img.shields.io/crates/v/kasm?color=%235555cc)
![Crates.io](https://img.shields.io/crates/d/kasm)

The Kerbal Assembler, or KASM is a custom developed assembler designed to target the computers inside of the Kerbal Operating System mod for Kerbal Space Program. KASM generates KerbalObject files which can then be linked using [KLinker](https://github.com/newcomb-luke/kOS-KLinker) to create KerboScript Machine code (.ksm) files which can be run inside kOS.

Object files generated by KASM and KLinker can be viewed using the related project [KDump](https://github.com/newcomb-luke/KDump)

Any custom programming language for kOS can be implemented on top of KASM and that is what this project aims to help with.

## Documentation

For documentation on how to use KASM, see [the guide](https://newcomb-luke.github.io/kOS-KASM/)

## Support

Besides reading the guide above, support on how to use and write KASM code can be found in the [KASM Discord Server](https://discord.gg/APETM2ceVZ).

## Installation

The Kerbal Assembler can either be installed via [cargo](https://github.com/rust-lang/cargo) through [crates.io](https://crates.io/), or as a standalone binary.

To install using **cargo**:

```
cargo install kasm
```

`kasm` should then be added to your shell's PATH, and can be run from any terminal

To install using the standalone binaries:
* Download and extract the .zip file from Releases on the right
* Place the executable in the desired location
* Run the executable through the terminal, Powershell on Windows or the default terminal on Mac OS or Linux.

To install using the Windows installer:
* Download and extract the .zip file from Releases on the right
* Run the installer
* `kasm` should now be added to your PATH and available from any CMD or Powershell window

## Usage

The Kerbal Assembler can be invoked after installation as `kasm`

Help can be accessed from the program itself by running:
```
kasm --help
```

The basic format for kasm arguments is:
```
kasm [FLAGS] [OPTIONS] <INPUT> --output <OUTPUT>
```

When running `kasm`, the assembler cannot infer the output file name, so one must always be specified. This is accomplished by passing the **-o** flag to kasm:
```
kasm main.kasm -o myprogram.ko
```

The **-w** flag can be used to supress warnings generated by the assembler:
```
kasm -w
```

The **-a** flag can be used to disable preprocessing in kasm when assembling a file. This is usually done if one is not using preprocessor directives because it can speed up processing time:
```
kasm -a
```

In contrast, the **-p** flag can be used to tell kasm to only perform preprocessing if any must be done. The output file will then be kasm source code with all macros expanded, etc:
```
kasm -p
```

The **-i** option can be passed to kasm in order to specify the include path for `.include` directives inside of the code:
```
kasm main.kasm -o myprogram.ko -i include/
```

The **-f** option can be provided to kasm to specify the file name to be set in the generated KerbalObject file. This can be useful if using kasm as a second step down from a compiler.
```
kasm program.kasm -f program.ys
```

The **-c** option can be specified in order to set the generated file's comment field. The default comment is something along the lines of "Compiled by KASM ..." and the version number. This can be overriden if a compiler sits on top of this:
```
kasm program.kasm -c "Compiled by MyCompiler"
```


## Features

* Extensive [preprocessor directives](https://newcomb-luke.github.io/kOS-KASM/chapter_3/kasm_preprocessor.html)
* Easy to use functions and labels
* Some small size optimizations over compiled KerboScript
