//! **Kaomoji** (顔文字) is a popular Japanese emoticon style made up of Japanese characters and grammar punctuations, and are used to express emotion in texting and cyber communication. The word **kaomoji** is also synonymous to be referred to as **Japanese emoticons**. This concept is formed by the combination of two words in Kanji, “kao” (顔 – “face”) and “moji” (文字 – “character”).
//!
//! Japanese are very emotional and creative nation. Therefore, in Japan emoticons are popular as nowhere in the world.
//!
//! Japanese believe that eyes are the mirror of a human soul. Therefore, unlike Western emoticons where most attention is paid to mouth, in **Japanese emoticons** the most important part are eyes. In addition, **kaomoji** are so popular because you don’t have to read them sideways.
//! Many Japanese are good at drawing because Japanese is the language of drawings. Anime and manga are vivid examples of how closely the authors manage to convey a variety of emotions just by a set of a few simple lines.
//! In the beginning of internet and instant messaging – lack of face-to-face talk resulted in mistakenly taking parodies and humorous jokes the wrong way. **Kaomoji** is a result of manga and anime fans who wanted to correct those mistakes, avoid awkward writing situations, and express words more creatively.
//!
//! **Japanese emoticons** are extremely diverse. Some of Internet sources state the number of 10000 but, in fact, there are much more of them. Such diversity may be explained by at least two factors:
//!
//! - unlike Cyrillic and Latin alphabets, which are usually written in single-byte character sets, Japanese writing requires a minimum of double-byte sets with a wider scope of characters;
//!
//! - **kaomoji** can express not only individual emotions, but also complex actions, objects, and even whole stories.
//!
//! **Japanese emoticons** are divided into categories based on emotional component of a form, action or object. These emoticons can also use some special characters for additional connotation.
//!
//! On this website you can find an interesting collection of kawaii (cute) **Japanese emoji** compiled from various (mostly Japanese) internet sources. Since it is impossible to find and display all of them, we selected the most interesting and cute ones, as well as added our own. In addition, we also developed an application for Android.
//!
//! So! Feel free to use these **Japanese emoticons**. Mix and match the elements of different **kaomoji** and create your own creative options!
#[cfg(test)]
macro_rules! test_string {
    ($val:expr,$i:expr) => {
        if let Ok(string) = std::str::from_utf8($i) {
            assert!(
                !string.contains("\n"),
                "New line detected at index [{}]",
                $val
            );
            assert!(
                string.trim() == string,
                "Trailing whitespace detected at [{}]",
                $val
            )
        } else {
            panic!("Invalid unicode detected at [{}]", $val)
        }
    };
}

#[cfg(test)]
macro_rules! test {
    ($array:path) => {
        for (val, i) in $array.into_iter().enumerate() {
            test_string!(val, i)
        }
    };
}

pub mod positive_emotions {
    /// If you want to create joyful, happy or laughing Japanese emoticons use high up eyes. For example, you can use these characters: ^, ￣, ´ and `. Mouths are important too. Japanese girls often use character ω (omega) for mouths of their emoticons, thinking that such kaomoji are cute, or, as they say, kawaii. You can also use ∀, ▽ and other characters resembling a smile. And Japanese also like to add different effects to kaomoji (stars, tears of joy, and so on) for better emphasis.
    pub const JOY: [&[u8]; 85] = [
        b"(* ^ \xCF\x89 ^)",
        b"(\xC2\xB4 \xE2\x88\x80 ` *)",
        b"\xD9\xA9(\xE2\x97\x95\xE2\x80\xBF\xE2\x97\x95\xEF\xBD\xA1)\xDB\xB6",
        b"\xE2\x98\x86*:.\xEF\xBD\xA1.o(\xE2\x89\xA7\xE2\x96\xBD\xE2\x89\xA6)o.\xEF\xBD\xA1.:*\xE2\x98\x86",
        b"(o^\xE2\x96\xBD^o)",
        b"(\xE2\x8C\x92\xE2\x96\xBD\xE2\x8C\x92)\xE2\x98\x86",
        b"<(\xEF\xBF\xA3\xEF\xB8\xB6\xEF\xBF\xA3)>",
        b"\xE3\x80\x82.:\xE2\x98\x86*:\xEF\xBD\xA5'(*\xE2\x8C\x92\xE2\x80\x95\xE2\x8C\x92*)))",
        b"\xE3\x83\xBD(\xE3\x83\xBB\xE2\x88\x80\xE3\x83\xBB)\xEF\xBE\x89",
        b"(\xC2\xB4\xEF\xBD\xA1\xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2\xEF\xBD\xA1`)",
        b"(\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3)",
        b"\xEF\xBD\x80;:\xE3\x82\x9B;\xEF\xBD\x80;\xEF\xBD\xA5(\xC2\xB0\xCE\xB5\xC2\xB0 )",
        b"(o\xEF\xBD\xA5\xCF\x89\xEF\xBD\xA5o)",
        b"(\xEF\xBC\xA0\xEF\xBC\xBE\xE2\x97\xA1\xEF\xBC\xBE)",
        b"\xE3\x83\xBD(*\xE3\x83\xBB\xCF\x89\xE3\x83\xBB)\xEF\xBE\x89",
        b"(o_ _)\xEF\xBE\x89\xE5\xBD\xA1\xE2\x98\x86",
        b"(^\xE4\xBA\xBA^)",
        b"(o\xC2\xB4\xE2\x96\xBD`o)",
        b"(*\xC2\xB4\xE2\x96\xBD`*)",
        b"\xEF\xBD\xA1\xEF\xBE\x9F( \xEF\xBE\x9F^\xE2\x88\x80^\xEF\xBE\x9F)\xEF\xBE\x9F\xEF\xBD\xA1",
        b"( \xC2\xB4 \xCF\x89 ` )",
        b"(((o(*\xC2\xB0\xE2\x96\xBD\xC2\xB0*)o)))",
        b"(\xE2\x89\xA7\xE2\x97\xA1\xE2\x89\xA6)",
        b"(o\xC2\xB4\xE2\x88\x80`o)",
        b"(\xC2\xB4\xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2`)",
        b"(\xEF\xBC\xBE\xE2\x96\xBD\xEF\xBC\xBE')",
        b"(\xE2\x8C\x92\xCF\x89\xE2\x8C\x92)",
        b"\xE2\x88\x91d(\xC2\xB0\xE2\x88\x80\xC2\xB0d)",
        b"\xE2\x95\xB0(\xE2\x96\x94\xE2\x88\x80\xE2\x96\x94)\xE2\x95\xAF",
        b"(\xE2\x94\x80\xE2\x80\xBF\xE2\x80\xBF\xE2\x94\x80)",
        b"(*^\xE2\x80\xBF^*)",
        b"\xE3\x83\xBD(o^ ^o)\xEF\xBE\x89",
        b"(\xE2\x9C\xAF\xE2\x97\xA1\xE2\x9C\xAF)",
        b"(\xE2\x97\x95\xE2\x80\xBF\xE2\x97\x95)",
        b"(*\xE2\x89\xA7\xCF\x89\xE2\x89\xA6*)",
        b"(\xE2\x98\x86\xE2\x96\xBD\xE2\x98\x86)",
        b"(\xE2\x8C\x92\xE2\x80\xBF\xE2\x8C\x92)",
        b"\xEF\xBC\xBC(\xE2\x89\xA7\xE2\x96\xBD\xE2\x89\xA6)\xEF\xBC\x8F",
        b"\xE3\x83\xBD(o\xEF\xBC\xBE\xE2\x96\xBD\xEF\xBC\xBEo)\xE3\x83\x8E",
        b"\xE2\x98\x86 \xEF\xBD\x9E('\xE2\x96\xBD^\xE4\xBA\xBA)",
        b"(*\xC2\xB0\xE2\x96\xBD\xC2\xB0*)",
        b"\xD9\xA9(\xEF\xBD\xA1\xE2\x80\xA2\xCC\x81\xE2\x80\xBF\xE2\x80\xA2\xCC\x80\xEF\xBD\xA1)\xDB\xB6",
        b"(\xE2\x9C\xA7\xCF\x89\xE2\x9C\xA7)",
        b"\xE3\x83\xBD(*\xE2\x8C\x92\xE2\x96\xBD\xE2\x8C\x92*)\xEF\xBE\x89",
        b"(\xC2\xB4\xEF\xBD\xA1\xE2\x80\xA2 \xE1\xB5\x95 \xE2\x80\xA2\xEF\xBD\xA1`)",
        b"( \xC2\xB4 \xE2\x96\xBD ` )",
        b"(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)",
        b"\xE2\x95\xB0(*\xC2\xB4\xEF\xB8\xB6`*)\xE2\x95\xAF",
        b"\xE3\x83\xBD(>\xE2\x88\x80<\xE2\x98\x86)\xE3\x83\x8E",
        b"o(\xE2\x89\xA7\xE2\x96\xBD\xE2\x89\xA6)o",
        b"(\xE2\x98\x86\xCF\x89\xE2\x98\x86)",
        b"(\xE3\x81\xA3\xCB\x98\xCF\x89\xCB\x98\xCF\x82 )",
        b"\xEF\xBC\xBC(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)\xEF\xBC\x8F",
        b"(*\xC2\xAF\xEF\xB8\xB6\xC2\xAF*)",
        b"\xEF\xBC\xBC(\xEF\xBC\xBE\xE2\x96\xBD\xEF\xBC\xBE)\xEF\xBC\x8F",
        b"\xD9\xA9(\xE2\x97\x95\xE2\x80\xBF\xE2\x97\x95)\xDB\xB6",
        b"(o\xCB\x98\xE2\x97\xA1\xCB\x98o)",
        b"\\(\xE2\x98\x85\xCF\x89\xE2\x98\x85)/",
        b"\\(^\xE3\x83\xAE^)/",
        b"(\xE3\x80\x83\xEF\xBC\xBE\xE2\x96\xBD\xEF\xBC\xBE\xE3\x80\x83)",
        b"(\xE2\x95\xAF\xE2\x9C\xA7\xE2\x96\xBD\xE2\x9C\xA7)\xE2\x95\xAF",
        b"o(>\xCF\x89<)o",
        b"o( \xE2\x9D\x9B\xE1\xB4\x97\xE2\x9D\x9B )o",
        b"\xEF\xBD\xA1\xEF\xBE\x9F(T\xE3\x83\xAET)\xEF\xBE\x9F\xEF\xBD\xA1",
        b"( \xE2\x80\xBE\xCC\x81 \xE2\x97\xA1 \xE2\x80\xBE\xCC\x81 )",
        b"(\xEF\xBE\x89\xC2\xB4\xE3\x83\xAE`)\xEF\xBE\x89*: \xEF\xBD\xA5\xEF\xBE\x9F",
        b"(b \xE1\xB5\x94\xE2\x96\xBD\xE1\xB5\x94)b",
        b"(\xE0\xB9\x91\xCB\x83\xE1\xB4\x97\xCB\x82)\xEF\xBB\xAD",
        b"(\xE0\xB9\x91\xCB\x98\xEF\xB8\xB6\xCB\x98\xE0\xB9\x91)",
        b"\xC2\xB0\xCB\x96\xE2\x9C\xA7\xE2\x97\x9D(\xE2\x81\xB0\xE2\x96\xBF\xE2\x81\xB0)\xE2\x97\x9C\xE2\x9C\xA7\xCB\x96\xC2\xB0",
        b"(\xC2\xB4\xEF\xBD\xA5\xE1\xB4\x97\xEF\xBD\xA5 ` )",
        b"(\xEF\xBE\x89\xE2\x97\x95\xE3\x83\xAE\xE2\x97\x95)\xEF\xBE\x89*:\xEF\xBD\xA5\xEF\xBE\x9F\xE2\x9C\xA7",
        b"(\xE2\x80\x9E\xE2\x80\xA2 \xD6\x8A \xE2\x80\xA2\xE2\x80\x9E)",
        b"(.\xE2\x9D\x9B \xE1\xB4\x97 \xE2\x9D\x9B.)",
        b"(\xE2\x81\x80\xE1\x97\xA2\xE2\x81\x80)",
        b"(\xEF\xBF\xA2\xE2\x80\xBF\xEF\xBF\xA2 )",
        b"(\xC2\xAC\xE2\x80\xBF\xC2\xAC )",
        b"(*\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)b",
        b"( \xCB\x99\xE2\x96\xBF\xCB\x99 )",
        b"(\xC2\xAF\xE2\x96\xBF\xC2\xAF)",
        b"( \xE2\x97\x95\xE2\x96\xBF\xE2\x97\x95 )",
        b"\xEF\xBC\xBC(\xD9\xA5\xE2\x81\x80\xE2\x96\xBD\xE2\x81\x80 )\xEF\xBC\x8F",
        b"(\xE2\x80\x9E\xE2\x80\xA2 \xE1\xB4\x97 \xE2\x80\xA2\xE2\x80\x9E)",
        b"(\xE1\xB5\x94\xE2\x97\xA1\xE1\xB5\x94)",
        b"( \xC2\xB4 \xE2\x96\xBF ` )",
    ];

    /// Love and kissing Japanese emoji often use character ♡ (heart) or its combination, for example, ノ～ ♡ (air kiss). You can also use a set of characters "chu" for a kiss (in Japan it means a sound of a kiss). Another interesting love emoticons feature is an active presence of such characters as * or o, which mean "rousy cheeks" and are often used in combination with /, \, ノ, ﾉ and ヽ. This emoticons are trying to hide their faces in embarrassment. You can also use character ε (bow lips), which indicates the desire to hug and kiss. Japanese girls often joke saying that such kaomoji look like perverts!
    pub const LOVE: [&[u8]; 47] = [
        b"(\xEF\xBE\x89\xC2\xB4 \xD0\xB7 `)\xE3\x83\x8E",
        b"(\xE2\x99\xA1\xCE\xBC_\xCE\xBC)",
        b"(*^^*)\xE2\x99\xA1",
        b"\xE2\x98\x86\xE2\x8C\x92\xE3\x83\xBD(*'\xEF\xBD\xA4^*)chu",
        b"(\xE2\x99\xA1-_-\xE2\x99\xA1)",
        b"(\xEF\xBF\xA3\xCE\xB5\xEF\xBF\xA3\xEF\xBC\xA0)",
        b"\xE3\x83\xBD(\xE2\x99\xA1\xE2\x80\xBF\xE2\x99\xA1)\xE3\x83\x8E",
        b"( \xC2\xB4 \xE2\x88\x80 `)\xE3\x83\x8E\xEF\xBD\x9E \xE2\x99\xA1",
        b"(\xE2\x94\x80\xE2\x80\xBF\xE2\x80\xBF\xE2\x94\x80)\xE2\x99\xA1",
        b"(\xC2\xB4\xEF\xBD\xA1\xE2\x80\xA2 \xE1\xB5\x95 \xE2\x80\xA2\xEF\xBD\xA1`) \xE2\x99\xA1",
        b"(*\xE2\x99\xA1\xE2\x88\x80\xE2\x99\xA1)",
        b"(\xEF\xBD\xA1\xE3\x83\xBB//\xCE\xB5//\xE3\x83\xBB\xEF\xBD\xA1)",
        b"(\xC2\xB4 \xCF\x89 `\xE2\x99\xA1)",
        b"\xE2\x99\xA1( \xE2\x97\xA1\xE2\x80\xBF\xE2\x97\xA1 )",
        b"(\xE2\x97\x95\xE2\x80\xBF\xE2\x97\x95)\xE2\x99\xA1",
        b"(/\xE2\x96\xBD\xEF\xBC\xBC*)\xEF\xBD\xA1o\xE2\x97\x8B\xE2\x99\xA1",
        b"(\xE1\x83\xA6\xCB\x98\xE2\x8C\xA3\xCB\x98\xE1\x83\xA6)",
        b"(\xE2\x99\xA1\xC2\xB0\xE2\x96\xBD\xC2\xB0\xE2\x99\xA1)",
        b"\xE2\x99\xA1(\xEF\xBD\xA1- \xCF\x89 -)",
        b"\xE2\x99\xA1 \xEF\xBD\x9E('\xE2\x96\xBD^\xE4\xBA\xBA)",
        b"(\xC2\xB4\xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2`) \xE2\x99\xA1",
        b"(\xC2\xB4 \xCE\xB5 ` )\xE2\x99\xA1",
        b"(\xC2\xB4\xEF\xBD\xA1\xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2\xEF\xBD\xA1`) \xE2\x99\xA1",
        b"( \xC2\xB4 \xE2\x96\xBD ` ).\xEF\xBD\xA1\xEF\xBD\x8F\xE2\x99\xA1",
        b"\xE2\x95\xB0(*\xC2\xB4\xEF\xB8\xB6`*)\xE2\x95\xAF\xE2\x99\xA1",
        b"(*\xCB\x98\xEF\xB8\xB6\xCB\x98*).\xEF\xBD\xA1.:*\xE2\x99\xA1",
        b"(\xE2\x99\xA1\xCB\x99\xEF\xB8\xB6\xCB\x99\xE2\x99\xA1)",
        b"\xE2\x99\xA1\xEF\xBC\xBC(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)\xEF\xBC\x8F\xE2\x99\xA1",
        b"(\xE2\x89\xA7\xE2\x97\xA1\xE2\x89\xA6) \xE2\x99\xA1",
        b"(\xE2\x8C\x92\xE2\x96\xBD\xE2\x8C\x92)\xE2\x99\xA1",
        b"(*\xC2\xAF \xC2\xB3\xC2\xAF*)\xE2\x99\xA1",
        b"(\xE3\x81\xA3\xCB\x98\xD0\xB7(\xCB\x98\xE2\x8C\xA3\xCB\x98 ) \xE2\x99\xA1",
        b"\xE2\x99\xA1 (\xCB\x98\xE2\x96\xBD\xCB\x98>\xD4\x85( \xCB\x98\xE2\x8C\xA3\xCB\x98)",
        b"( \xCB\x98\xE2\x8C\xA3\xCB\x98)\xE2\x99\xA1(\xCB\x98\xE2\x8C\xA3\xCB\x98 )",
        b"(/^-^(^ ^*)/ \xE2\x99\xA1",
        b"\xD9\xA9(\xE2\x99\xA1\xCE\xB5\xE2\x99\xA1)\xDB\xB6",
        b"\xCF\x83(\xE2\x89\xA7\xCE\xB5\xE2\x89\xA6\xCF\x83) \xE2\x99\xA1",
        b"\xE2\x99\xA1 (\xE2\x87\x80 3 \xE2\x86\xBC)",
        b"\xE2\x99\xA1 (\xEF\xBF\xA3\xD0\x97\xEF\xBF\xA3)",
        b"(\xE2\x9D\xA4\xCF\x89\xE2\x9D\xA4)",
        b"(\xCB\x98\xE2\x88\x80\xCB\x98)/(\xCE\xBC\xE2\x80\xBF\xCE\xBC) \xE2\x9D\xA4",
        b"\xE2\x9D\xA4 (\xC9\x94\xCB\x86\xD0\xB7(\xCB\x86\xE2\x8C\xA3\xCB\x86c)",
        b"(\xC2\xB4\xE2\x99\xA1\xE2\x80\xBF\xE2\x99\xA1`)",
        b"(\xC2\xB0\xE2\x97\xA1\xC2\xB0\xE2\x99\xA1)",
        b"\xCE\xA3>\xE2\x80\x95(\xE3\x80\x83\xC2\xB0\xCF\x89\xC2\xB0\xE3\x80\x83)\xE2\x99\xA1\xE2\x86\x92",
        b"(\xC2\xB4,,\xE2\x80\xA2\xCF\x89\xE2\x80\xA2,,)\xE2\x99\xA1",
        b"(\xC2\xB4\xEA\x92\xB3`)\xE2\x99\xA1",
    ];

    /// To depict embarrassment, you can use ; character (something like a drop of sweat on a face), or characters for blush (*, o). In addition, you can try to make your emoticon cover its face by its hands in embarrassment.
    pub const EMBARRESMENT: [&[u8]; 24] = [
        b"(\xE2\x8C\x92_\xE2\x8C\x92;)",
        b"(o^ ^o)",
        b"(*/\xCF\x89\xEF\xBC\xBC)",
        b"(*/\xE3\x80\x82\xEF\xBC\xBC)",
        b"(*/_\xEF\xBC\xBC)",
        b"(*\xEF\xBE\x89\xCF\x89\xEF\xBE\x89)",
        b"(o-_-o)",
        b"(*\xCE\xBC_\xCE\xBC)",
        b"( \xE2\x97\xA1\xE2\x80\xBF\xE2\x97\xA1 *)",
        b"(\xE1\xB5\x94.\xE1\xB5\x94)",
        b"(*\xEF\xBE\x89\xE2\x88\x80`*)",
        b"(//\xE2\x96\xBD//)",
        b"(//\xCF\x89//)",
        b"(\xE3\x83\x8E*\xC2\xB0\xE2\x96\xBD\xC2\xB0*)",
        b"(*^.^*)",
        b"(*\xEF\xBE\x89\xE2\x96\xBD\xEF\xBE\x89)",
        b"(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3*)\xE3\x82\x9E",
        b"(\xE2\x81\x84 \xE2\x81\x84\xE2\x80\xA2\xE2\x81\x84\xCF\x89\xE2\x81\x84\xE2\x80\xA2\xE2\x81\x84 \xE2\x81\x84)",
        b"(*/\xE2\x96\xBD\xEF\xBC\xBC*)",
        b"(\xE2\x81\x84 \xE2\x81\x84>\xE2\x81\x84 \xE2\x96\xBD \xE2\x81\x84<\xE2\x81\x84 \xE2\x81\x84)",
        b"(\xE0\xB8\x87 \xE0\xB8\xB7\xE2\x96\xBF \xE0\xB8\xB7)\xE0\xB8\xA7",
        b"( \xE3\x80\x83\xE2\x96\xBD\xE3\x80\x83)",
        b"(/\xE2\x96\xBF\xEF\xBC\xBC )",
        b"(///\xEF\xBF\xA3 \xEF\xBF\xA3///)",
    ];

    /// The expression of sympathy or compassion requires at least two Japanese emoticons: one of them will be upset about something, and the other will calm him down. You can use kaomoji from "sadness" category for the first type. A key element for the second one will be "a calming hand" (ノ", ノ'or ヾ) or "shoulder of support" (see examples).
    pub const SYMPATHY: [&[u8]; 12] = [
        b"(\xE3\x83\x8E_<\xE3\x80\x82)\xE3\x83\xBE(\xC2\xB4 \xE2\x96\xBD ` )",
        b"\xEF\xBD\xA1\xEF\xBD\xA5\xEF\xBE\x9F\xEF\xBD\xA5(\xEF\xBE\x89\xD0\x94`)\xE3\x83\xBD(\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3 )",
        b"\xCF\x81(- \xCF\x89 -\xE3\x80\x81)\xE3\x83\xBE(\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3; )",
        b"\xE3\x83\xBD(\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3(\xE3\x80\x82\xE3\x80\x82 )\xE3\x82\x9D",
        b"(*\xC2\xB4 I `)\xEF\xBE\x89\xEF\xBE\x9F(\xEF\xBE\x89\xD0\x94\xEF\xBD\x80\xEF\xBE\x9F)\xEF\xBE\x9F\xEF\xBD\xA1",
        b"\xE3\x83\xBD(~_~(\xE3\x83\xBB_\xE3\x83\xBB )\xE3\x82\x9D",
        b"(\xEF\xBE\x89_\xEF\xBC\x9B)\xE3\x83\xBE(\xC2\xB4 \xE2\x88\x80 ` )",
        b"(; \xCF\x89 ; )\xE3\x83\xBE(\xC2\xB4\xE2\x88\x80`* )",
        b"(*\xC2\xB4\xE3\x83\xBC)\xEF\xBE\x89(\xE3\x83\x8E\xD0\xB4`)",
        b"(\xC2\xB4-\xCF\x89-`( _ _ )",
        b"(\xE3\x81\xA3\xC2\xB4\xCF\x89`)\xEF\xBE\x89(\xE2\x95\xA5\xCF\x89\xE2\x95\xA5)",
        b"(\xEF\xBD\x8F\xE3\x83\xBB_\xE3\x83\xBB)\xE3\x83\x8E\xE2\x80\x9D(\xE3\x83\x8E_<\xE3\x80\x81)",
    ];

    #[cfg(test)]
    mod tests {
        #[test]
        fn joy() {
            test!(super::JOY)
        }

        #[test]
        fn love() {
            test!(super::LOVE)
        }

        #[test]
        fn embarrassment() {
            test!(super::EMBARRESMENT)
        }

        #[test]
        fn sympathy() {
            test!(super::SYMPATHY)
        }
    }
}

pub mod negative_emotions {
    /// Dissatisfaction can be easily expressed by kaomoji's facial wrinkling. You can use ＞＜ characters for dissatisfied or displeased Japanese emoticons. Additional wrinkles can be added by # character. You can also express dissatisfaction with eyes like ¬ ¬ or ¯ ¯ and with a well-chosen mouth. Such techniques are quite common in anime and manga.
    pub const DISSATISFACTION: [&[u8]; 25] = [
        b"(\xEF\xBC\x83\xEF\xBC\x9E\xEF\xBC\x9C)",
        b"(\xEF\xBC\x9B\xE2\x8C\xA3\xCC\x80_\xE2\x8C\xA3\xCC\x81)",
        b"\xE2\x98\x86\xEF\xBD\x8F(\xEF\xBC\x9E\xEF\xBC\x9C\xEF\xBC\x9B)\xE2\x97\x8B",
        b"(\xEF\xBF\xA3 \xEF\xBF\xA3|||)",
        b"(\xEF\xBC\x9B\xEF\xBF\xA3\xD0\x94\xEF\xBF\xA3)",
        b"(\xEF\xBF\xA3\xE2\x96\xA1\xEF\xBF\xA3\xE3\x80\x8D)",
        b"(\xEF\xBC\x83\xEF\xBF\xA30\xEF\xBF\xA3)",
        b"(\xEF\xBC\x83\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3)",
        b"(\xEF\xBF\xA2_\xEF\xBF\xA2;)",
        b"(\xEF\xBC\x9E\xEF\xBD\x8D\xEF\xBC\x9C)",
        b"(\xE3\x80\x8D\xC2\xB0\xE3\x83\xAD\xC2\xB0)\xE3\x80\x8D",
        b"(\xE3\x80\x83\xEF\xBC\x9E\xEF\xBC\xBF\xEF\xBC\x9C;\xE3\x80\x83)",
        b"(\xEF\xBC\xBE\xEF\xBC\xBE\xEF\xBC\x83)",
        b"(\xEF\xB8\xB6\xEF\xB8\xB9\xEF\xB8\xBA)",
        b"(\xEF\xBF\xA3\xE3\x83\x98\xEF\xBF\xA3)",
        b"<(\xEF\xBF\xA3 \xEF\xB9\x8C \xEF\xBF\xA3)>",
        b"(\xEF\xBF\xA3\xEF\xB8\xBF\xEF\xBF\xA3)",
        b"(\xEF\xBC\x9E\xEF\xB9\x8F\xEF\xBC\x9C)",
        b"(--_--)",
        b"\xE5\x87\xB8(\xEF\xBF\xA3\xE3\x83\x98\xEF\xBF\xA3)",
        b"\xE3\x83\xBE( \xEF\xBF\xA3O\xEF\xBF\xA3)\xE3\x83\x84",
        b"(\xE2\x87\x80\xE2\x80\xB8\xE2\x86\xBC\xE2\x80\xB6)",
        b"o(>< )o",
        b"(\xE3\x80\x8D\xEF\xBC\x9E\xEF\xBC\x9C)\xE3\x80\x8D",
        b"(\xE1\x97\x92\xE1\x97\xA3\xE1\x97\x95)\xD5\x9E",
    ];

    /// The secret of angry or evil emoticons is in their eyes. Use \` and ´ or ｀ and ´. Just don't change the characters' order, otherwise your angry emoticon will become friendly and kind (compare: \` ´ - evil eyes, ´ ` - kind eyes). In addition, you can add "wrinkles" ＃ and their stronger forms: メ or ╬; and 凸 (middle finger) and ψ (claws) as an arm. You can also use "snarl" 皿 or 益.
    pub const ANGER: [&[u8]; 33] = [
        b"(\xEF\xBC\x83`\xD0\x94\xC2\xB4)",
        b"(`\xE7\x9A\xBF\xC2\xB4\xEF\xBC\x83)",
        b"( ` \xCF\x89 \xC2\xB4 )",
        b"\xE3\x83\xBD( `\xD0\xB4\xC2\xB4*)\xE3\x83\x8E",
        b"(\xE3\x83\xBB`\xCF\x89\xC2\xB4\xE3\x83\xBB)",
        b"(`\xE3\x83\xBC\xC2\xB4)",
        b"\xE3\x83\xBD(`\xE2\x8C\x92\xC2\xB4\xE3\x83\xA1)\xE3\x83\x8E",
        b"\xE5\x87\xB8(`\xE2\x96\xB3\xC2\xB4\xEF\xBC\x83)",
        b"( `\xCE\xB5\xC2\xB4 )",
        b"\xCF\x88( ` \xE2\x88\x87 \xC2\xB4 )\xCF\x88",
        b"\xE3\x83\xBE(`\xE3\x83\x98\xC2\xB4)\xEF\xBE\x89\xEF\xBE\x9E",
        b"\xE3\x83\xBD(\xE2\x80\xB5\xEF\xB9\x8F\xC2\xB4)\xE3\x83\x8E",
        b"(\xEF\xBE\x92` \xEF\xBE\x9B \xC2\xB4)",
        b"(\xE2\x95\xAC`\xE7\x9B\x8A\xC2\xB4)",
        b"\xE2\x94\x8C\xE2\x88\xA9\xE2\x94\x90(\xE2\x97\xA3_\xE2\x97\xA2)\xE2\x94\x8C\xE2\x88\xA9\xE2\x94\x90",
        b"\xE5\x87\xB8( ` \xEF\xBE\x9B \xC2\xB4 )\xE5\x87\xB8",
        b"\xCE\xA3(\xE2\x96\xBC\xE2\x96\xA1\xE2\x96\xBC\xE3\x83\xA1)",
        b"(\xC2\xB0\xE3\x85\x82\xC2\xB0\xE2\x95\xAC)",
        b"\xCF\x88(\xE2\x96\xBC\xE3\x81\xB8\xE2\x96\xBC\xE3\x83\xA1)\xEF\xBD\x9E\xE2\x86\x92",
        b"(\xE3\x83\x8E\xC2\xB0\xE7\x9B\x8A\xC2\xB0)\xE3\x83\x8E",
        b"(\xD2\x82 `\xD0\xB7\xC2\xB4 )",
        b"(\xE2\x80\xA1\xE2\x96\xBC\xE7\x9B\x8A\xE2\x96\xBC)",
        b"(\xD2\x82` \xEF\xBE\x9B \xC2\xB4)\xE5\x87\xB8",
        b"((\xE2\x95\xAC\xE2\x97\xA3\xEF\xB9\x8F\xE2\x97\xA2))",
        b"\xD9\xA9(\xE2\x95\xAC\xCA\x98\xE7\x9B\x8A\xCA\x98\xE2\x95\xAC)\xDB\xB6",
        b"(\xE2\x95\xAC \xC3\x92\xEF\xB9\x8F\xC3\x93)",
        b"\xEF\xBC\xBC\xEF\xBC\xBC\xD9\xA9(\xE0\xB9\x91`^\xC2\xB4\xE0\xB9\x91)\xDB\xB6\xEF\xBC\x8F\xEF\xBC\x8F",
        b"(\xE5\x87\xB8\xE0\xB2\xA0\xE7\x9B\x8A\xE0\xB2\xA0)\xE5\x87\xB8",
        b"\xE2\x86\x91_(\xCE\xA6w\xCE\xA6)\xCE\xA8",
        b"\xE2\x86\x90~(\xCE\xA8\xE2\x96\xBC\xEF\xBD\xB0\xE2\x96\xBC)\xE2\x88\x88",
        b"\xE0\xAD\xA7((#\xCE\xA6\xE7\x9B\x8A\xCE\xA6#))\xE0\xAD\xA8",
        b"\xD9\xA9(\xE0\xB0\xA0\xE7\x9B\x8A\xE0\xB0\xA0)\xDB\xB6",
        b"(\xEF\xBE\x89\xE0\xB2\xA5\xE7\x9B\x8A\xE0\xB2\xA5)\xEF\xBE\x89",
    ];

    /// Sad or crying emoticons are quite easy to create. Use Т Т, ; ;, > < and other characters for crying eyes. You can also use / \ or ノ ヽ to cover your face.
    pub const SADNESS: [&[u8]; 36] = [
        b"(\xE3\x83\x8E_<\xE3\x80\x82)",
        b"(-_-)",
        b"(\xC2\xB4-\xCF\x89-`)",
        b".\xEF\xBD\xA5\xEF\xBE\x9F\xEF\xBE\x9F\xEF\xBD\xA5(\xEF\xBC\x8F\xCF\x89\xEF\xBC\xBC)\xEF\xBD\xA5\xEF\xBE\x9F\xEF\xBE\x9F\xEF\xBD\xA5.",
        b"(\xCE\xBC_\xCE\xBC)",
        b"(\xEF\xBE\x89\xD0\x94`)",
        b"(-\xCF\x89-\xE3\x80\x81)",
        b"\xE3\x80\x82\xE3\x82\x9C\xE3\x82\x9C(\xC2\xB4\xEF\xBC\xAF`) \xE3\x82\x9C\xE3\x82\x9C\xE3\x80\x82",
        b"o(T\xE3\x83\x98To)",
        b"( ; \xCF\x89 ; )",
        b"(\xEF\xBD\xA1\xE2\x95\xAF\xEF\xB8\xB5\xE2\x95\xB0\xEF\xBD\xA1)",
        b"\xEF\xBD\xA1\xEF\xBD\xA5\xEF\xBE\x9F\xEF\xBE\x9F*(>\xD0\xB4<)*\xEF\xBE\x9F\xEF\xBE\x9F\xEF\xBD\xA5\xEF\xBD\xA1",
        b"( \xEF\xBE\x9F\xEF\xBC\x8C_\xE3\x82\x9D\xEF\xBD\x80)",
        b"(\xE4\xB8\xAA_\xE4\xB8\xAA)",
        b"(\xE2\x95\xAF\xEF\xB8\xB5\xE2\x95\xB0,)",
        b"\xEF\xBD\xA1\xEF\xBD\xA5\xEF\xBE\x9F(\xEF\xBE\x9F><\xEF\xBE\x9F)\xEF\xBE\x9F\xEF\xBD\xA5\xEF\xBD\xA1",
        b"( \xE2\x95\xA5\xCF\x89\xE2\x95\xA5 )",
        b"(\xE2\x95\xAF_\xE2\x95\xB0)",
        b"(\xE2\x95\xA5_\xE2\x95\xA5)",
        b".\xEF\xBD\xA1\xEF\xBD\xA5\xEF\xBE\x9F\xEF\xBE\x9F\xEF\xBD\xA5(\xEF\xBC\x9E_\xEF\xBC\x9C)\xEF\xBD\xA5\xEF\xBE\x9F\xEF\xBE\x9F\xEF\xBD\xA5\xEF\xBD\xA1.",
        b"(\xEF\xBC\x8F\xCB\x8D\xE3\x83\xBB\xE3\x80\x81)",
        b"(\xE3\x83\x8E_<\xE3\x80\x81)",
        b"(\xE2\x95\xA5\xEF\xB9\x8F\xE2\x95\xA5)",
        b"\xEF\xBD\xA1\xEF\xBE\x9F(\xEF\xBD\xA1\xEF\xBE\x89\xCF\x89\xE3\x83\xBD\xEF\xBD\xA1)\xEF\xBE\x9F\xEF\xBD\xA1",
        b"(\xE3\x81\xA4\xCF\x89`\xEF\xBD\xA1)",
        b"(\xEF\xBD\xA1T \xCF\x89 T\xEF\xBD\xA1)",
        b"(\xEF\xBE\x89\xCF\x89\xEF\xBD\xA5\xEF\xBD\xA4)",
        b"\xEF\xBD\xA5\xEF\xBE\x9F\xEF\xBD\xA5(\xEF\xBD\xA1>\xCF\x89<\xEF\xBD\xA1)\xEF\xBD\xA5\xEF\xBE\x9F\xEF\xBD\xA5",
        b"(T_T)",
        b"(>_<)",
        b"(\xE3\x81\xA3\xCB\x98\xCC\xA9\xE2\x95\xAD\xE2\x95\xAE\xCB\x98\xCC\xA9)\xE3\x81\xA3",
        b"\xEF\xBD\xA1\xEF\xBE\x9F\xEF\xBD\xA5 (>\xEF\xB9\x8F<) \xEF\xBD\xA5\xEF\xBE\x9F\xEF\xBD\xA1",
        b"o(\xE3\x80\x92\xEF\xB9\x8F\xE3\x80\x92)o",
        b"(\xEF\xBD\xA1\xE2\x80\xA2\xCC\x81\xEF\xB8\xBF\xE2\x80\xA2\xCC\x80\xEF\xBD\xA1)",
        b"(\xE0\xB2\xA5\xEF\xB9\x8F\xE0\xB2\xA5)",
        b"(\xE0\xB2\xA1\xE2\x80\xB8\xE0\xB2\xA1)",
    ];

    /// Use characters > < combined with special effects like ⌒☆ to depict pain. You can also use eyes of “x” type for “stunned” emoticons. Of course, there are also many other ways.
    pub const PAIN: [&[u8]; 15] = [
        b"~(>_<~)",
        b"\xE2\x98\x86\xE2\x8C\x92(> _ <)",
        b"\xE2\x98\x86\xE2\x8C\x92(>\xE3\x80\x82<)",
        b"(\xE2\x98\x86_@)",
        b"(\xC3\x97_\xC3\x97)",
        b"(x_x)V",
        b"(\xC3\x97_\xC3\x97)\xE2\x8C\x92\xE2\x98\x86",
        b"(x_x)\xE2\x8C\x92\xE2\x98\x86",
        b"(\xC3\x97\xEF\xB9\x8F\xC3\x97)",
        b"\xE2\x98\x86(\xEF\xBC\x83\xC3\x97\xC3\x97)",
        b"(\xEF\xBC\x8B_\xEF\xBC\x8B)",
        b"[ \xC2\xB1 _ \xC2\xB1 ]",
        b"\xD9\xA9(\xC3\x97 \xC3\x97)\xDB\xB6",
        b"_:(\xC2\xB4\xE0\xBD\x80`\xE3\x80\x8D \xE2\x88\xA0):_",
        b"(\xEF\xBE\x92\xEF\xB9\x8F\xEF\xBE\x92)",
    ];

    /// For scared or frightened Japanese emoji use forward and backward slashes and similar characters depicting that they hide their faces in fear. You can also try to depict screaming, waving their arms and so on.
    pub const FEAR: [&[u8]; 17] = [
        b"(\xE3\x83\x8E\xCF\x89\xE3\x83\xBD)",
        b"(\xEF\xBC\x8F\xE3\x80\x82\xEF\xBC\xBC)",
        b"(\xEF\xBE\x89_\xE3\x83\xBD)",
        b"..\xE3\x83\xBB\xE3\x83\xBE(\xE3\x80\x82\xEF\xBC\x9E\xEF\xBC\x9C)\xE3\x82\xB7",
        b"(\xE2\x80\xB3\xE3\x83\xAD\xE3\x82\x9B)",
        b"(;;;*_*)",
        b"(\xE3\x83\xBB\xE4\xBA\xBA\xE3\x83\xBB)",
        b"\xEF\xBC\xBC(\xE3\x80\x87_\xEF\xBD\x8F)\xEF\xBC\x8F",
        b"(/\xCF\x89\xEF\xBC\xBC)",
        b"(/_\xEF\xBC\xBC)",
        b"\xE3\x80\x9C(\xEF\xBC\x9E\xEF\xBC\x9C)\xE3\x80\x9C",
        b"\xCE\xA3(\xC2\xB0\xE2\x96\xB3\xC2\xB0|||)\xEF\xB8\xB4",
        b"(((\xEF\xBC\x9E\xEF\xBC\x9C)))",
        b"{{ (>_<) }}",
        b"\xEF\xBC\xBC(\xC2\xBA \xE2\x96\xA1 \xC2\xBA l|l)/",
        b"\xE3\x80\xA3( \xC2\xBA\xCE\x94\xC2\xBA )\xE3\x80\xA3",
        b"\xE2\x96\x93\xE2\x96\x92\xE2\x96\x91(\xC2\xB0\xE2\x97\xA1\xC2\xB0)\xE2\x96\x91\xE2\x96\x92\xE2\x96\x93",
    ];

    #[cfg(test)]
    mod tests {
        #[test]
        fn dissatisfaction() {
            test!(super::DISSATISFACTION)
        }

        #[test]
        fn anger() {
            test!(super::ANGER)
        }

        #[test]
        fn sadness() {
            test!(super::SADNESS)
        }

        #[test]
        fn pain() {
            test!(super::PAIN)
        }

        #[test]
        fn fear() {
            test!(super::FEAR)
        }
    }
}

pub mod neutral_emotions {
    /// You can make indifferent / whatever emoticons by adding special characters for arms (┐ ┌ or ╮ ╭, and various combinations with forward and backward slashes and related characters). You can use ー ー or ˇ ˇ for indifferent eyes.
    pub const INDIFFERENCE: [&[u8]; 23] = [
        b"\xE3\x83\xBD(\xE3\x83\xBC_\xE3\x83\xBC )\xE3\x83\x8E",
        b"\xE3\x83\xBD(\xC2\xB4\xE3\x83\xBC` )\xE2\x94\x8C",
        b"\xE2\x94\x90(\xE2\x80\x98\xEF\xBD\x9E` )\xE2\x94\x8C",
        b"\xE3\x83\xBD(\xE3\x80\x80\xEF\xBF\xA3\xD0\xB4\xEF\xBF\xA3)\xE3\x83\x8E",
        b"\xE2\x94\x90(\xEF\xBF\xA3\xE3\x83\x98\xEF\xBF\xA3)\xE2\x94\x8C",
        b"\xE3\x83\xBD(\xEF\xBF\xA3\xEF\xBD\x9E\xEF\xBF\xA3\xE3\x80\x80)\xE3\x83\x8E",
        b"\xE2\x95\xAE(\xEF\xBF\xA3_\xEF\xBF\xA3)\xE2\x95\xAD",
        b"\xE3\x83\xBD(\xCB\x87\xE3\x83\x98\xCB\x87)\xE3\x83\x8E",
        b"\xE2\x94\x90(\xEF\xBF\xA3\xEF\xBD\x9E\xEF\xBF\xA3)\xE2\x94\x8C",
        b"\xE2\x94\x90(\xEF\xB8\xB6\xE2\x96\xBD\xEF\xB8\xB6)\xE2\x94\x8C",
        b"\xE2\x95\xAE(\xEF\xBF\xA3\xEF\xBD\x9E\xEF\xBF\xA3)\xE2\x95\xAD",
        b"\xC2\xAF\\_(\xE3\x83\x84)_/\xC2\xAF",
        b"\xE2\x94\x90( \xC2\xB4 \xD0\xB4 ` )\xE2\x94\x8C",
        b"\xE2\x95\xAE(\xEF\xB8\xB6\xEF\xB8\xBF\xEF\xB8\xB6)\xE2\x95\xAD",
        b"\xE2\x94\x90(\xEF\xBF\xA3\xE2\x88\x80\xEF\xBF\xA3)\xE2\x94\x8C",
        b"\xE2\x94\x90( \xCB\x98 \xEF\xBD\xA4 \xCB\x98 )\xE2\x94\x8C",
        b"\xE2\x95\xAE(\xEF\xB8\xB6\xE2\x96\xBD\xEF\xB8\xB6)\xE2\x95\xAD",
        b"\xE2\x95\xAE( \xCB\x98 \xEF\xBD\xA4 \xCB\x98 )\xE2\x95\xAD",
        b"\xE2\x94\x90( \xCB\x98_\xCB\x98 )\xE2\x94\x8C",
        b"\xE2\x95\xAE( \xCB\x98_\xCB\x98 )\xE2\x95\xAD",
        b"\xE2\x94\x90(\xEF\xBF\xA3\xE3\x83\xAE\xEF\xBF\xA3)\xE2\x94\x8C",
        b"\xE1\x95\x95( \xE1\x90\x9B )\xE1\x95\x97",
        b"\xE2\x94\x90(\xE3\x82\xB7)\xE2\x94\x8C",
    ];

    /// Use "blank eyes" ・ ・. You can add ; or 〃 to strengthen the effect. The eyes like ￣ ￣ would be suitable too. Finally, you can add such effects as thinking (・・・), raising hands (┐ ┌ or ╮ ╭) and propping the head with an arm ( ゞ).
    pub const CONFUSSION: [&[u8]; 23] = [
        b"(\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3;)",
        b"\xCF\x83(\xEF\xBF\xA3\xE3\x80\x81\xEF\xBF\xA3\xE3\x80\x83)",
        b"(\xEF\xBF\xA3\xEF\xBD\x9E\xEF\xBF\xA3;)",
        b"(-_-;)\xE3\x83\xBB\xE3\x83\xBB\xE3\x83\xBB",
        b"\xE2\x94\x90('\xEF\xBD\x9E`;)\xE2\x94\x8C",
        b"(\xE3\x83\xBB_\xE3\x83\xBB\xE3\x83\xBE",
        b"(\xE3\x80\x83\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3\xE3\x80\x83\xE3\x82\x9E",
        b"\xE2\x94\x90(\xEF\xBF\xA3\xE3\x83\x98\xEF\xBF\xA3;)\xE2\x94\x8C",
        b"(\xE3\x83\xBB_\xE3\x83\xBB;)",
        b"(\xEF\xBF\xA3_\xEF\xBF\xA3)\xE3\x83\xBB\xE3\x83\xBB\xE3\x83\xBB",
        b"\xE2\x95\xAE(\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3;)\xE2\x95\xAD",
        b"(\xC2\xAF . \xC2\xAF;)",
        b"(\xEF\xBC\xA0_\xEF\xBC\xA0)",
        b"(\xE3\x83\xBB\xE3\x83\xBB;)\xE3\x82\x9E",
        b"\xCE\xA3(\xEF\xBF\xA3\xE3\x80\x82\xEF\xBF\xA3\xEF\xBE\x89)",
        b"(\xE3\x83\xBB\xE3\x83\xBB ) ?",
        b"(\xE2\x80\xA2\xE0\xB8\xB4_\xE2\x80\xA2\xE0\xB8\xB4)?",
        b"(\xE2\x97\x8E \xE2\x97\x8E)\xE3\x82\x9E",
        b"(\xE3\x83\xBC\xE3\x83\xBC;)",
        b"\xE1\x83\x9A(\xE0\xB2\xA0_\xE0\xB2\xA0 \xE1\x83\x9A)",
        b"\xE1\x83\x9A(\xC2\xAF\xE3\x83\xAD\xC2\xAF\"\xE1\x83\x9A)",
        b"(\xC2\xAF . \xC2\xAF\xD9\xA5)",
        b"(\xC2\xAF \xC2\xAF\xD9\xA5)",
    ];

    /// For doubt Japanese emoticons use ￢ ￢, ¬ ¬ or arrows. This will create the impression that their eyes look toward as if they hear a lie.
    pub const DOUBT: [&[u8]; 11] = [
        b"(\xEF\xBF\xA2_\xEF\xBF\xA2)",
        b"(\xE2\x86\x92_\xE2\x86\x92)",
        b"(\xEF\xBF\xA2 \xEF\xBF\xA2)",
        b"(\xEF\xBF\xA2\xE2\x80\xBF\xEF\xBF\xA2 )",
        b"(\xC2\xAC_\xC2\xAC )",
        b"(\xE2\x86\x90_\xE2\x86\x90)",
        b"(\xC2\xAC \xC2\xAC )",
        b"(\xC2\xAC\xE2\x80\xBF\xC2\xAC )",
        b"(\xE2\x86\xBC_\xE2\x86\xBC)",
        b"(\xE2\x87\x80_\xE2\x87\x80)",
        b"(\xE1\x93\x80 \xE1\x93\x80)",
    ];

    /// For shocked and surprised emoticons use mouth wide open (ｏ, 〇, ロ), surprised eyes (O O, ⊙ ⊙) and raised hands. You can also add character Σ (sharp jerk) or some cofusion (character ;). Furthermore, you can try to use big eyes in combination with small mouth (for contrast).
    pub const SUPRISE: [&[u8]; 14] = [
        b"w(\xC2\xB0\xEF\xBD\x8F\xC2\xB0)w",
        b"\xE3\x83\xBD(\xC2\xB0\xE3\x80\x87\xC2\xB0)\xEF\xBE\x89",
        b"\xCE\xA3(O_O)",
        b"\xCE\xA3(\xC2\xB0\xE3\x83\xAD\xC2\xB0)",
        b"(\xE2\x8A\x99_\xE2\x8A\x99)",
        b"(o_O)",
        b"(O_O;)",
        b"(O.O)",
        b"(\xC2\xB0\xE3\x83\xAD\xC2\xB0) !",
        b"(o_O) !",
        b"(\xE2\x96\xA1_\xE2\x96\xA1)",
        b"\xCE\xA3(\xE2\x96\xA1_\xE2\x96\xA1)",
        b"\xE2\x88\x91(O_O;)",
        b"( : \xE0\xB1\xA6 \xE2\x80\xB8 \xE0\xB1\xA6 : )",
    ];

    #[cfg(test)]
    mod tests {
        #[test]
        fn indifference() {
            test!(super::INDIFFERENCE)
        }

        #[test]
        fn confusion() {
            test!(super::CONFUSSION)
        }

        #[test]
        fn doubt() {
            test!(super::DOUBT)
        }

        #[test]
        fn suprise() {
            test!(super::SUPRISE)
        }
    }
}

pub mod various_actions {
    /// For greeting (and farewell) Japanese emoticons you can use forward and backward slashes as a standard. However, there are a few more interesting options, such as ﾉ or ノ. And if you want your emoticon to wave its hand, try to use ヾ, ﾉﾞ and their various combinations with the "tilde".
    pub const GREETING: [&[u8]; 28] = [
        b"(*\xE3\x83\xBB\xCF\x89\xE3\x83\xBB)\xEF\xBE\x89",
        b"(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)\xE3\x83\x8E",
        b"(\xC2\xB0\xE2\x96\xBD\xC2\xB0)/",
        b"( \xC2\xB4 \xE2\x88\x80 ` )\xEF\xBE\x89",
        b"(^-^*)/",
        b"(\xEF\xBC\xA0\xC2\xB4\xE3\x83\xBC`)\xEF\xBE\x89\xEF\xBE\x9E",
        b"(\xC2\xB4\xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2`)\xEF\xBE\x89",
        b"( \xC2\xB0 \xE2\x88\x80 \xC2\xB0 )\xEF\xBE\x89\xEF\xBE\x9E",
        b"\xE3\x83\xBE(*'\xE2\x96\xBD'*)",
        b"\xEF\xBC\xBC(\xE2\x8C\x92\xE2\x96\xBD\xE2\x8C\x92)",
        b"\xE3\x83\xBE(\xE2\x98\x86\xE2\x96\xBD\xE2\x98\x86)",
        b"( \xC2\xB4 \xE2\x96\xBD ` )\xEF\xBE\x89",
        b"(^\xEF\xBC\x90^)\xE3\x83\x8E",
        b"~\xE3\x83\xBE(\xE3\x83\xBB\xCF\x89\xE3\x83\xBB)",
        b"(\xE3\x83\xBB\xE2\x88\x80\xE3\x83\xBB)\xE3\x83\x8E",
        b"\xE3\x83\xBE(\xE3\x83\xBB\xCF\x89\xE3\x83\xBB*)",
        b"(*\xC2\xB0\xEF\xBD\xB0\xC2\xB0)\xEF\xBE\x89",
        b"(\xE3\x83\xBB_\xE3\x83\xBB)\xE3\x83\x8E",
        b"(o\xC2\xB4\xCF\x89`o)\xEF\xBE\x89",
        b"( \xC2\xB4 \xE2\x96\xBD ` )/",
        b"(\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3)/",
        b"( \xC2\xB4 \xCF\x89 ` )\xE3\x83\x8E\xEF\xBE\x9E",
        b"(\xE2\x8C\x92\xCF\x89\xE2\x8C\x92)\xEF\xBE\x89",
        b"(o^ ^o)/",
        b"(\xE2\x89\xA7\xE2\x96\xBD\xE2\x89\xA6)/",
        b"(\xE2\x9C\xA7\xE2\x88\x80\xE2\x9C\xA7)/",
        b"(o\xC2\xB4\xE2\x96\xBD`o)\xEF\xBE\x89",
        b"(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)/",
    ];

    /// For hugging emoticons use respective outstretched arm characters.
    pub const HUGGING: [&[u8]; 14] = [
        b"(\xE3\x81\xA5\xEF\xBF\xA3 \xC2\xB3\xEF\xBF\xA3)\xE3\x81\xA5",
        b"(\xE3\x81\xA4\xE2\x89\xA7\xE2\x96\xBD\xE2\x89\xA6)\xE3\x81\xA4",
        b"(\xE3\x81\xA4\xE2\x9C\xA7\xCF\x89\xE2\x9C\xA7)\xE3\x81\xA4",
        b"(\xE3\x81\xA5 \xE2\x97\x95\xE2\x80\xBF\xE2\x97\x95 )\xE3\x81\xA5",
        b"(\xE2\x8A\x83\xEF\xBD\xA1\xE2\x80\xA2\xCC\x81\xE2\x80\xBF\xE2\x80\xA2\xCC\x80\xEF\xBD\xA1)\xE2\x8A\x83",
        b"(\xE3\x81\xA4 . \xE2\x80\xA2\xCC\x81 _\xCA\x96 \xE2\x80\xA2\xCC\x80 .)\xE3\x81\xA4",
        b"(\xE3\x81\xA3\xE0\xB2\xA0\xE2\x80\xBF\xE0\xB2\xA0)\xE3\x81\xA3",
        b"(\xE3\x81\xA5\xE2\x97\xA1\xEF\xB9\x8F\xE2\x97\xA1)\xE3\x81\xA5",
        b"\xE2\x8A\x82(\xC2\xB4\xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2`\xE2\x8A\x82)",
        b"\xE2\x8A\x82(\xEF\xBD\xA5\xCF\x89\xEF\xBD\xA5*\xE2\x8A\x82)",
        b"\xE2\x8A\x82(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)\xE2\x8A\x83",
        b"\xE2\x8A\x82( \xC2\xB4 \xE2\x96\xBD ` )\xE2\x8A\x83",
        b"( ~*-*)~",
        b"(\xEF\xBD\xA1\xE2\x80\xA2\xCC\x80\xE1\xB4\x97-)\xE2\x9C\xA7",
    ];

    /// Winking Japanese emoticons look cute and they are quite easy to be made. Just use different characters for left and right eye.
    pub const WINKING: [&[u8]; 17] = [
        b"(^_~)",
        b"( \xEF\xBE\x9F\xEF\xBD\x8F\xE2\x8C\x92)",
        b"(^_-)\xE2\x89\xA1\xE2\x98\x86",
        b"(^\xCF\x89~)",
        b"(>\xCF\x89^)",
        b"(~\xE4\xBA\xBA^)",
        b"(^_-)",
        b"( -_\xE3\x83\xBB)",
        b"(^_<)\xE3\x80\x9C\xE2\x98\x86",
        b"(^\xE4\xBA\xBA<)\xE3\x80\x9C\xE2\x98\x86",
        b"\xE2\x98\x86\xE2\x8C\x92(\xE2\x89\xA7\xE2\x96\xBD\xE2\x80\x8B\xC2\xB0 )",
        b"\xE2\x98\x86\xE2\x8C\x92(\xE3\x82\x9D\xE3\x80\x82\xE2\x88\x82)",
        b"(^_<)",
        b"(^_\xE2\x88\x92)\xE2\x98\x86",
        b"(\xEF\xBD\xA5\xCF\x89<)\xE2\x98\x86",
        b"(^.~)\xE2\x98\x86",
        b"(^.~)",
    ];

    /// In Japan, when expressing apology, it is common to perform a traditional bow. Therefore, apologizing Japanese emoticons are created this way. Use lowered eyes (_ _ or . .). If the bow is performed from a sitting position, you can use m m for the eyes. Otherwise, use characters < > for shoulders.
    pub const APOLOGIZING: [&[u8]; 9] = [
        b"m(_ _)m",
        b"(\xE3\x82\xB7_ _)\xE3\x82\xB7",
        b"m(. .)m",
        b"<(_ _)>",
        b"\xE4\xBA\xBA(_ _*)",
        b"(*_ _)\xE4\xBA\xBA",
        b"m(_ _;m)",
        b"(m;_ _)m",
        b"(\xE3\x82\xB7. .)\xE3\x82\xB7",
    ];

    /// If you want to depict nosebleeding / nosebleeds like in anime and manga use the following characters: i, ﾊ, ;, 〃.
    pub const NOSEBLEEDING: [&[u8]; 8] = [
        b"(*\xEF\xBF\xA3ii\xEF\xBF\xA3)",
        b"(\xEF\xBF\xA3\xEF\xBE\x8A\xEF\xBF\xA3*)",
        b"\\(\xEF\xBF\xA3\xEF\xBE\x8A\xEF\xBF\xA3)",
        b"(\xEF\xBC\xBE\xE0\xBC\x8B\xE0\xBC\x8D\xEF\xBC\xBE)",
        b"(\xEF\xBC\xBE\xE3\x80\x83\xEF\xBC\xBE)",
        b"(\xEF\xBF\xA3 \xC2\xA8\xE3\x83\xBD\xEF\xBF\xA3)",
        b"(\xEF\xBF\xA3 ;\xEF\xBF\xA3)",
        b"(\xEF\xBF\xA3 ;;\xEF\xBF\xA3)",
    ];

    /// Using character | for hiding emoticons makes them look like if they are peeping from behind the wall hiding from somebody.
    pub const HIDING: [&[u8]; 14] = [
        b"|\xEF\xBD\xA5\xCF\x89\xEF\xBD\xA5)",
        b"\xEF\xBE\x8D(\xEF\xBD\xA5_|",
        b"|\xCF\x89\xEF\xBD\xA5)\xEF\xBE\x89",
        b"\xE3\x83\xBE(\xEF\xBD\xA5|",
        b"|\xD0\xB4\xEF\xBD\xA5)",
        b"|_\xEF\xBF\xA3))",
        b"|\xE2\x96\xBD//)",
        b"\xE2\x94\xAC\xE2\x94\xB4\xE2\x94\xAC\xE2\x94\xB4\xE2\x94\xA4(\xEF\xBD\xA5_\xE2\x94\x9C\xE2\x94\xAC\xE2\x94\xB4\xE2\x94\xAC\xE2\x94\xB4",
        b"\xE2\x94\xAC\xE2\x94\xB4\xE2\x94\xAC\xE2\x94\xB4\xE2\x94\xA4\xEF\xBD\xA5\xCF\x89\xEF\xBD\xA5)\xEF\xBE\x89",
        b"\xE2\x94\xAC\xE2\x94\xB4\xE2\x94\xAC\xE2\x94\xB4\xE2\x94\xA4( \xCD\xA1\xC2\xB0 \xCD\x9C\xCA\x96\xE2\x94\x9C\xE2\x94\xAC\xE2\x94\xB4\xE2\x94\xAC\xE2\x94\xB4",
        b"\xE2\x94\xAC\xE2\x94\xB4\xE2\x94\xAC\xE2\x94\xB4\xE2\x94\xA4(\xEF\xBD\xA5_\xE2\x94\x9C\xE2\x94\xAC\xE2\x94\xB4\xE2\x94\xAC\xE2\x94\xB4",
        b"|_\xE3\x83\xBB)",
        b"|\xEF\xBD\xA5\xD0\xB4\xEF\xBD\xA5)\xEF\xBE\x89",
        b"|\xCA\x98\xE2\x80\xBF\xCA\x98)\xE2\x95\xAF",
    ];

    /// Character φ looks good as a pen, if you want to make writing emoticons. You can also add a few underscores or dots to depict the process of writing itself.
    pub const WRITING: [&[u8]; 12] = [
        b"__\xCF\x86(\xEF\xBC\x8E\xEF\xBC\x8E)",
        b"( \xEF\xBF\xA3\xE3\x83\xBC\xEF\xBF\xA3)\xCF\x86__",
        b"__\xCF\x86(\xE3\x80\x82\xE3\x80\x82)",
        b"__\xCF\x86(\xEF\xBC\x8E\xEF\xBC\x8E;)",
        b"\xE3\x83\xBE( `\xE3\x83\xBC\xC2\xB4)\xE3\x82\xB7\xCF\x86__",
        b"__\xE3\x80\x86(\xEF\xBF\xA3\xE3\x83\xBC\xEF\xBF\xA3 )",
        b"....\xCF\x86(\xE3\x83\xBB\xE2\x88\x80\xE3\x83\xBB*)",
        b"___\xE3\x80\x86(\xE3\x83\xBB\xE2\x88\x80\xE3\x83\xBB)",
        b"( ^\xE2\x96\xBD^)\xCF\x88__",
        b"....\xCF\x86(\xEF\xB8\xB6\xE2\x96\xBD\xEF\xB8\xB6)\xCF\x86....",
        b"( . .)\xCF\x86__",
        b"__\xCF\x86(\xE2\x97\x8E\xE2\x97\x8E\xE3\x83\x98)",
    ];

    /// You can create running Japanese emoji by adding special motion effects. Among available charactrers are ε, =, ミ and C.
    pub const RUNNING: [&[u8]; 9] = [
        b"\xE2\x98\x86\xEF\xBE\x90(o*\xEF\xBD\xA5\xCF\x89\xEF\xBD\xA5)\xEF\xBE\x89",
        b"C= C= C= C= C=\xE2\x94\x8C(;\xE3\x83\xBB\xCF\x89\xE3\x83\xBB)\xE2\x94\x98",
        b"\xE2\x94\x80=\xE2\x89\xA1\xCE\xA3((( \xE3\x81\xA4\xEF\xBC\x9E\xEF\xBC\x9C)\xE3\x81\xA4",
        b"\xCE\xB5=\xCE\xB5=\xCE\xB5=\xCE\xB5=\xE2\x94\x8C(;\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)\xE2\x94\x98",
        b"\xCE\xB5=\xCE\xB5=\xE2\x94\x8C( >_<)\xE2\x94\x98",
        b"C= C= C= C=\xE2\x94\x8C( `\xE3\x83\xBC\xC2\xB4)\xE2\x94\x98",
        b"\xCE\xB5===(\xE3\x81\xA3\xE2\x89\xA7\xCF\x89\xE2\x89\xA6)\xE3\x81\xA3",
        b"\xE3\x83\xBD(\xEF\xBF\xA3\xD0\xB4\xEF\xBF\xA3;)\xE3\x83\x8E=3=3=3",
        b"\xE3\x80\x82\xE3\x80\x82\xE3\x80\x82\xE3\x83\x9F\xE3\x83\xBD(\xE3\x80\x82\xEF\xBC\x9E\xEF\xBC\x9C)\xE3\x83\x8E",
    ];

    /// Use zzZ for snoring. You can also put your sleeping emoticon on a pillow [ ]. Simple as that!
    pub const SLEEPING: [&[u8]; 10] = [
        b"[(\xEF\xBC\x8D\xEF\xBC\x8D)]..zzZ",
        b"(\xEF\xBC\x8D_\xEF\xBC\x8D) zzZ",
        b"(\xE2\x88\xAA\xEF\xBD\xA1\xE2\x88\xAA)\xEF\xBD\xA1\xEF\xBD\xA1\xEF\xBD\xA1zzZ",
        b"(\xEF\xBC\x8D\xCF\x89\xEF\xBC\x8D) zzZ",
        b"(\xEF\xBF\xA3o\xEF\xBF\xA3) zzZZzzZZ",
        b"(( _ _ ))..zzzZZ",
        b"(\xEF\xBF\xA3\xCF\x81\xEF\xBF\xA3)..zzZZ",
        b"(\xEF\xBC\x8D.\xEF\xBC\x8D)...zzz",
        b"(\xEF\xBC\xBF \xEF\xBC\xBF*) Z z z",
        b"(x . x) ~~zzZ",
    ];

    #[cfg(test)]
    mod tests {
        #[test]
        fn greeting() {
            test!(super::GREETING)
        }

        #[test]
        fn hugging() {
            test!(super::HUGGING)
        }

        #[test]
        fn winking() {
            test!(super::WINKING)
        }

        #[test]
        fn apologizing() {
            test!(super::APOLOGIZING)
        }

        #[test]
        fn nosebleeding() {
            test!(super::NOSEBLEEDING)
        }

        #[test]
        fn hiding() {
            test!(super::HIDING)
        }

        #[test]
        fn writing() {
            test!(super::WRITING)
        }

        #[test]
        fn running() {
            test!(super::RUNNING)
        }

        #[test]
        fn sleeping() {
            test!(super::SLEEPING)
        }
    }
}

pub mod animals {
    /// Japanese believe that cats are insanely cute creatures. This explains a variety of anime and manga fetishes: cat ears and tail, saying "nyaa~" (nyaa - "meow" in Japanese) and other kawaii things. Therefore, it's not a surprise that in kaomoji main animals are cats. So, if you want your emoticon to become a nice kitty, use = = for its mustache and ^ ^ for the ears.
    pub const CAT: [&[u8]; 28] = [
        b"(=^\xEF\xBD\xA5\xCF\x89\xEF\xBD\xA5^=)",
        b"(=^\xEF\xBD\xA5\xEF\xBD\xAA\xEF\xBD\xA5^=)",
        b"(=\xE2\x91\xA0\xCF\x89\xE2\x91\xA0=)",
        b"( =\xCF\x89=)..nyaa",
        b"(= ; \xEF\xBD\xAA ; =)",
        b"(=`\xCF\x89\xC2\xB4=)",
        b"(=^\xE2\x80\xA5^=)",
        b"( =\xE3\x83\x8E\xCF\x89\xE3\x83\xBD=)",
        b"(=\xE2\x8C\x92\xE2\x80\xBF\xE2\x80\xBF\xE2\x8C\x92=)",
        b"(=^ \xE2\x97\xA1 ^=)",
        b"(=^-\xCF\x89-^=)",
        b"\xE3\x83\xBE(=`\xCF\x89\xC2\xB4=)\xE3\x83\x8E\xE2\x80\x9D",
        b"(\xEF\xBC\xBE\xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2\xEF\xBC\xBE)",
        b"(/ =\xCF\x89=)/",
        b"\xE0\xB8\x85(\xE2\x80\xA2\xE3\x85\x85\xE2\x80\xA2\xE2\x9D\x80)\xE0\xB8\x85",
        b"\xE0\xB8\x85(\xE2\x80\xA2 \xC9\xAA \xE2\x80\xA2)\xE0\xB8\x85",
        b"\xE0\xAC\xB2(\xE2\x93\x9B \xCF\x89 \xE2\x93\x9B)\xE0\xAC\xB2",
        b"(^=\xE2\x97\x95\xE1\xB4\xA5\xE2\x97\x95=^)",
        b"( =\xCF\x89= )",
        b"\xE0\xAC\xB2(\xE2\x93\x9B \xCF\x89 \xE2\x93\x9B)\xE0\xAC\xB2",
        b"(^=\xE2\x97\x95\xE1\xB4\xA5\xE2\x97\x95=^)",
        b"( =\xCF\x89= )",
        b"(^\xCB\xB5\xE2\x97\x95\xCF\x89\xE2\x97\x95\xCB\xB5^)",
        b"(^\xE2\x97\x94\xE1\xB4\xA5\xE2\x97\x94^)",
        b"(^\xE2\x97\x95\xE1\xB4\xA5\xE2\x97\x95^)",
        b"\xE0\xB8\x95(=\xCF\x89=)\xE0\xB8\x95",
        b"( \xCE\xA6 \xCF\x89 \xCE\xA6 )",
        b"\xE0\xB8\x85(^\xE2\x97\x95\xE1\xB4\xA5\xE2\x97\x95^)\xE0\xB8\x85",
    ];

    /// Japanese bear emoticons are easy to identify by their special snout (ｴ) or ears ʕ ʔ.
    pub const BEAR: [&[u8]; 16] = [
        b"( \xC2\xB4(\xEF\xBD\xB4)\xCB\x8B )",
        b"(*\xEF\xBF\xA3(\xEF\xBD\xB4)\xEF\xBF\xA3*)",
        b"\xE3\x83\xBD(\xEF\xBF\xA3(\xEF\xBD\xB4)\xEF\xBF\xA3)\xEF\xBE\x89",
        b"(\xEF\xBC\x8F\xEF\xBF\xA3(\xEF\xBD\xB4)\xEF\xBF\xA3)\xEF\xBC\x8F",
        b"(\xEF\xBF\xA3(\xEF\xBD\xB4)\xEF\xBF\xA3)",
        b"\xE3\x83\xBD( \xCB\x8B(\xEF\xBD\xB4)\xC2\xB4 )\xEF\xBE\x89",
        b"\xE2\x8A\x82(\xEF\xBF\xA3(\xEF\xBD\xB4)\xEF\xBF\xA3)\xE2\x8A\x83",
        b"(\xEF\xBC\x8F(\xEF\xBD\xB4)\xEF\xBC\xBC)",
        b"\xE2\x8A\x82(\xC2\xB4(\xE3\x82\xA7)\xCB\x8B)\xE2\x8A\x83",
        b"(/-(\xEF\xBD\xB4)-\xEF\xBC\xBC)",
        b"(/\xC2\xB0(\xEF\xBD\xB4)\xC2\xB0)/",
        b"\xCA\x95 \xE1\xB5\x94\xE1\xB4\xA5\xE1\xB5\x94 \xCA\x94",
        b"\xCA\x95 \xE2\x80\xA2\xE1\xB4\xA5\xE2\x80\xA2 \xCA\x94",
        b"\xCA\x95 \xE2\x80\xA2\xCC\x80 \xCF\x89 \xE2\x80\xA2\xCC\x81 \xCA\x94",
        b"\xCA\x95 \xE2\x80\xA2\xCC\x80 o \xE2\x80\xA2\xCC\x81 \xCA\x94",
        b"\xCA\x95\xE0\xB2\xA0\xE1\xB4\xA5\xE0\xB2\xA0\xCA\x94",
    ];

    /// The secret of dog emoticons is in the ears ∪ ∪. Use these characters instead of brackets.
    pub const DOG: [&[u8]; 9] = [
        b"\xE2\x88\xAA\xEF\xBC\xBE\xE3\x82\xA7\xEF\xBC\xBE\xE2\x88\xAA",
        b"\xE2\x88\xAA\xEF\xBD\xA5\xCF\x89\xEF\xBD\xA5\xE2\x88\xAA",
        b"\xE2\x88\xAA\xEF\xBF\xA3-\xEF\xBF\xA3\xE2\x88\xAA",
        b"\xE2\x88\xAA\xEF\xBD\xA5\xEF\xBD\xAA\xEF\xBD\xA5\xE2\x88\xAA",
        b"\xEF\xBC\xB5^\xE7\x9A\xBF^\xEF\xBC\xB5",
        b"\xEF\xBC\xB5\xEF\xBC\xB4\xEF\xBD\xAA\xEF\xBC\xB4\xEF\xBC\xB5",
        b"U^\xEF\xBD\xAA^U",
        b"V\xE2\x97\x8F\xE1\xB4\xA5\xE2\x97\x8FV",
        b"U\xE3\x83\xBB\xE1\xB4\xA5\xE3\x83\xBBU",
    ];

    /// It’s not a secret that rabbits are extremely cute animals. And emoticons are able to make them even cuter. You can use x for your rabbit’s face and slashes for its ears.
    pub const RABBIT: [&[u8]; 8] = [
        b"\xEF\xBC\x8F(\xE2\x89\xA7 x \xE2\x89\xA6)\xEF\xBC\xBC",
        b"\xEF\xBC\x8F(\xEF\xBD\xA5 \xC3\x97 \xEF\xBD\xA5)\xEF\xBC\xBC",
        b"\xEF\xBC\x8F(=\xC2\xB4x`=)\xEF\xBC\xBC",
        b"\xEF\xBC\x8F(^ x ^)\xEF\xBC\xBC",
        b"\xEF\xBC\x8F(=\xEF\xBD\xA5 x \xEF\xBD\xA5=)\xEF\xBC\xBC",
        b"\xEF\xBC\x8F(^ \xC3\x97 ^)\xEF\xBC\xBC",
        b"\xEF\xBC\x8F(\xEF\xBC\x9E\xC3\x97\xEF\xBC\x9C)\xEF\xBC\xBC",
        b"\xEF\xBC\x8F(\xCB\x83\xE1\x86\xBA\xCB\x82)\xEF\xBC\xBC",
    ];

    /// You can use (оо), (OO) or (ω) for a pig nose. Add it to your emoticon and you'll get a funny cute pig.
    pub const PIG: [&[u8]; 8] = [
        b"( \xC2\xB4(00)\xCB\x8B )",
        b"(\xEF\xBF\xA3(\xCF\x89)\xEF\xBF\xA3)",
        b"\xE3\x83\xBD( \xCB\x8B(00)\xC2\xB4 )\xE3\x83\x8E",
        b"( \xC2\xB4(oo)\xCB\x8B )",
        b"\xEF\xBC\xBC(\xEF\xBF\xA3(oo)\xEF\xBF\xA3)\xEF\xBC\x8F",
        b"\xEF\xBD\xA1\xEF\xBE\x9F(\xEF\xBE\x9F\xC2\xB4(00)`\xEF\xBE\x9F)\xEF\xBE\x9F\xEF\xBD\xA1",
        b"(\xEF\xBF\xA3(00)\xEF\xBF\xA3)",
        b"(\xCB\x86(oo)\xCB\x86)",
    ];

    /// For bird japanese emoticons and their mouths (beaks) you can use such characters as Θ or θ. This is the main idea.
    pub const BIRD: [&[u8]; 9] = [
        b"(\xEF\xBF\xA3\xCE\x98\xEF\xBF\xA3)",
        b"(`\xEF\xBD\xA5\xCE\x98\xEF\xBD\xA5\xC2\xB4)",
        b"( \xCB\x8B \xCE\x98 \xC2\xB4 )",
        b"(\xE2\x97\x89\xCE\x98\xE2\x97\x89)",
        b"\xEF\xBC\xBC( \xCB\x8B \xCE\x98 \xC2\xB4 )\xEF\xBC\x8F",
        b"(\xEF\xBD\xA5\xCE\xB8\xEF\xBD\xA5)",
        b"(\xE3\x83\xBB\xCE\x98\xE3\x83\xBB)",
        b"\xE3\x83\xBE(\xEF\xBF\xA3\xE2\x97\x87\xEF\xBF\xA3)\xE3\x83\x8E\xE3\x80\x83",
        b"(\xEF\xBD\xA5\xCE\x98\xEF\xBD\xA5)",
    ];

    /// Fish and seafood is an inevitable part of Japanese life. That's why fish and sea creatures emoticons are quite popular too. You can use << or 彡 for a tail, and )) for the gills.
    pub const FISH: [&[u8]; 7] = [
        b"(\xC2\xB0)#))<<",
        b"<\xE3\x83\xBB )))><<",
        b"\xCE\xB6\xC2\xB0)))\xE5\xBD\xA1",
        b">\xC2\xB0))))\xE5\xBD\xA1",
        b"(\xC2\xB0))<<",
        b">^)))<\xEF\xBD\x9E\xEF\xBD\x9E",
        b"\xE2\x89\xA7( \xC2\xB0 \xC2\xB0 )\xE2\x89\xA6",
    ];

    /// For spider emoticons use characters /\╱\╮╭╲ for the legs and try to add a few pairs of eyes.
    pub const SPIDER: [&[u8]; 7] = [
        b"/\xE2\x95\xB2/\\\xE2\x95\xAD(\xE0\xB0\xA0\xE0\xB0\xA0\xE7\x9B\x8A\xE0\xB0\xA0\xE0\xB0\xA0)\xE2\x95\xAE/\\\xE2\x95\xB1\\",
        b"/\xE2\x95\xB2/\\\xE2\x95\xAD(\xE0\xB2\xB0\xE0\xB2\xB0\xE2\x8C\x93\xE0\xB2\xB0\xE0\xB2\xB0)\xE2\x95\xAE/\\\xE2\x95\xB1\\",
        b"/\xE2\x95\xB2/\\\xE2\x95\xAD\xE0\xBC\xBC \xC2\xBA\xC2\xBA\xD9\x84\xCD\x9F\xC2\xBA\xC2\xBA \xE0\xBC\xBD\xE2\x95\xAE/\\\xE2\x95\xB1\\",
        b"/\xE2\x95\xB2/\\\xE2\x95\xAD( \xCD\xA1\xC2\xB0\xCD\xA1\xC2\xB0 \xCD\x9C\xCA\x96 \xCD\xA1\xC2\xB0\xCD\xA1\xC2\xB0)\xE2\x95\xAE/\\\xE2\x95\xB1\\",
        b"/\xE2\x95\xB2/\\\xE2\x95\xAD[ \xE1\xB4\xBC\xE1\xB4\xBC \xE0\xB1\xAA \xE1\xB4\xBC\xE1\xB4\xBC]\xE2\x95\xAE/\\\xE2\x95\xB1\\",
        b"/\xE2\x95\xB2/\\( \xE2\x80\xA2\xCC\x80 \xCF\x89 \xE2\x80\xA2\xCC\x81 )/\\\xE2\x95\xB1\\",
        b"/\xE2\x95\xB2/\\\xE2\x95\xAD[\xE2\x98\x89\xEF\xB9\x8F\xE2\x98\x89]\xE2\x95\xAE/\\\xE2\x95\xB1\\",
    ];

    #[cfg(test)]
    mod tests {
        #[test]
        fn cat() {
            test!(super::CAT)
        }

        #[test]
        fn bear() {
            test!(super::BEAR)
        }

        #[test]
        fn dog() {
            test!(super::DOG)
        }

        #[test]
        fn rabbit() {
            test!(super::RABBIT)
        }

        #[test]
        fn pig() {
            test!(super::PIG)
        }

        #[test]
        fn bird() {
            test!(super::BIRD)
        }

        #[test]
        fn fish() {
            test!(super::FISH)
        }

        #[test]
        fn spider() {
            test!(super::SPIDER)
        }
    }
}

pub mod other_types {
    /// If you want to describe friends and friendship, the best way is to make your Japanese emoticons holding each others hands. You can use 人, メ, 八 and 爻. Although, there are other suitable characters. You can try to find them.
    pub const FRIENDS: [&[u8]; 23] = [
        b"\xE3\x83\xBE(\xE3\x83\xBB\xCF\x89\xE3\x83\xBB)\xE3\x83\xA1(\xE3\x83\xBB\xCF\x89\xE3\x83\xBB)\xE3\x83\x8E",
        b"\xE3\x83\xBD(\xE2\x88\x80\xC2\xB0 )\xE4\xBA\xBA( \xC2\xB0\xE2\x88\x80)\xE3\x83\x8E",
        b"\xE3\x83\xBD( \xE2\x8C\x92o\xE2\x8C\x92)\xE4\xBA\xBA(\xE2\x8C\x92-\xE2\x8C\x92 )\xEF\xBE\x89",
        b"(*^\xCF\x89^)\xE5\x85\xAB(\xE2\x8C\x92\xE2\x96\xBD\xE2\x8C\x92)\xE5\x85\xAB(-\xE2\x80\xBF\xE2\x80\xBF- )\xE3\x83\xBD",
        b"\xEF\xBC\xBC(\xEF\xBC\xBE\xE2\x88\x80\xEF\xBC\xBE)\xE3\x83\xA1(\xEF\xBC\xBE\xE2\x88\x80\xEF\xBC\xBE)\xE3\x83\x8E",
        b"\xE3\x83\xBE(\xEF\xBF\xA3\xE3\x83\xBC\xEF\xBF\xA3(\xE2\x89\xA7\xCF\x89\xE2\x89\xA6*)\xE3\x82\x9D",
        b"\xE3\x83\xBD( \xE2\x8C\x92\xCF\x89\xE2\x8C\x92)\xE4\xBA\xBA(=^\xE2\x80\xA5^= )\xEF\xBE\x89",
        b"\xE3\x83\xBD(\xE2\x89\xA7\xE2\x97\xA1\xE2\x89\xA6)\xE5\x85\xAB(o^ ^o)\xE3\x83\x8E",
        b"(*\xE3\x83\xBB\xE2\x88\x80\xE3\x83\xBB)\xE7\x88\xBB(\xE3\x83\xBB\xE2\x88\x80\xE3\x83\xBB*)",
        b"\xEF\xBD\xA1*:\xE2\x98\x86(\xE3\x83\xBB\xCF\x89\xE3\x83\xBB\xE4\xBA\xBA\xE3\x83\xBB\xCF\x89\xE3\x83\xBB)\xEF\xBD\xA1:\xE3\x82\x9C\xE2\x98\x86\xEF\xBD\xA1",
        b"o(^^o)(o^^o)(o^^o)(o^^)o",
        b"(((\xEF\xBF\xA3(\xEF\xBF\xA3(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)\xEF\xBF\xA3)\xEF\xBF\xA3)))",
        b"(\xC2\xB0(\xC2\xB0\xCF\x89(\xC2\xB0\xCF\x89\xC2\xB0(\xE2\x98\x86\xCF\x89\xE2\x98\x86)\xC2\xB0\xCF\x89\xC2\xB0)\xCF\x89\xC2\xB0)\xC2\xB0)",
        b"\xE3\x83\xBE(\xE3\x83\xBB\xCF\x89\xE3\x83\xBB`)\xE3\x83\x8E\xE3\x83\xBE(\xC2\xB4\xE3\x83\xBB\xCF\x89\xE3\x83\xBB)\xE3\x83\x8E\xE3\x82\x9B",
        b"\xCE\xA8( `\xE2\x88\x80)(\xE2\x88\x80\xC2\xB4 )\xCE\xA8",
        b"(\xE3\x81\xA3\xCB\x98\xE2\x96\xBD\xCB\x98)(\xCB\x98\xE2\x96\xBD\xCB\x98)\xCB\x98\xE2\x96\xBD\xCB\x98\xCF\x82)",
        b"(((*\xC2\xB0\xE2\x96\xBD\xC2\xB0*)\xE5\x85\xAB(*\xC2\xB0\xE2\x96\xBD\xC2\xB0*)))",
        b"\xE2\x98\x86\xE3\x83\xBE(*\xC2\xB4\xE3\x83\xBB\xE2\x88\x80\xE3\x83\xBB)\xEF\xBE\x89\xE3\x83\xBE(\xE3\x83\xBB\xE2\x88\x80\xE3\x83\xBB`*)\xEF\xBE\x89\xE2\x98\x86",
        b"(*\xEF\xBC\xBE\xCF\x89\xEF\xBC\xBE)\xE4\xBA\xBA(\xEF\xBC\xBE\xCF\x89\xEF\xBC\xBE*)",
        b"\xD9\xA9(\xE0\xB9\x91\xEF\xBD\xA5\xE0\xB8\xB4\xE1\xB4\x97\xEF\xBD\xA5\xE0\xB8\xB4)\xDB\xB6\xD9\xA9(\xEF\xBD\xA5\xE0\xB8\xB4\xE1\xB4\x97\xEF\xBD\xA5\xE0\xB8\xB4\xE0\xB9\x91)\xDB\xB6",
        b"(\xE2\x98\x9E\xC2\xB0\xE3\x83\xAE\xC2\xB0)\xE2\x98\x9E \xE2\x98\x9C(\xC2\xB0\xE3\x83\xAE\xC2\xB0\xE2\x98\x9C)",
        b"\xEF\xBC\xBC(\xE2\x96\xBD\xEF\xBF\xA3 \\ (\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3) / \xEF\xBF\xA3\xE2\x96\xBD)\xEF\xBC\x8F",
        b"\\( \xCB\x99\xE2\x96\xBF\xCB\x99 )/\\( \xCB\x99\xE2\x96\xBF\xCB\x99 )/",
    ];

    /// The concept of "enemy" here is used in a joking manner. Just try to describe how your emoticon kicks his opponent, or anything like that. You can use special effects like ☆, ﾐ, 彡 and Σ for emphasis. You can also use x x for the eyes of unconscious emoticons. All the rest is your creative approach.
    pub const ENEMIES: [&[u8]; 24] = [
        b"\xE3\x83\xBD( \xEF\xBD\xA5\xE2\x88\x80\xEF\xBD\xA5)\xEF\xBE\x89_\xCE\xB8\xE5\xBD\xA1\xE2\x98\x86\xCE\xA3(\xE3\x83\x8E `\xD0\x94\xC2\xB4)\xE3\x83\x8E",
        b"(*\xC2\xB4\xE2\x88\x87`)\xE2\x94\x8C\xCE\xB8\xE2\x98\x86(\xEF\xBE\x89>_<)\xEF\xBE\x89",
        b"( \xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3)\xE3\x83\x8E\xEF\xBE\x9E\xE2\x8C\x92\xE2\x98\x86\xEF\xBE\x90(o _ _)o",
        b"(*`0\xC2\xB4)\xCE\xB8\xE2\x98\x86(\xE3\x83\xA1\xC2\xB0\xE7\x9A\xBF\xC2\xB0)\xEF\xBE\x89",
        b"(o\xC2\xAC\xE2\x80\xBF\xC2\xACo )...\xE2\x98\x86\xEF\xBE\x90(*x_x)",
        b"(\xE2\x95\xAC\xEF\xBF\xA3\xE7\x9A\xBF\xEF\xBF\xA3)=\xE2\x97\x8B\xEF\xBC\x83(\xEF\xBF\xA3#)\xEF\xBC\x93\xEF\xBF\xA3)",
        b"(; -_-)\xE2\x80\x95\xE2\x80\x95\xE2\x80\x95\xE2\x80\x95\xE2\x80\x95\xE2\x80\x95C<\xE2\x80\x95_-)",
        b"\xEF\xBC\x9C( \xEF\xBF\xA3\xEF\xB8\xBF\xEF\xBF\xA3)\xEF\xB8\xB5\xCE\xB8\xEF\xB8\xB5\xCE\xB8\xEF\xB8\xB5\xE2\x98\x86(\xEF\xBC\x9E\xE5\x8F\xA3\xEF\xBC\x9C\xEF\xBC\x8D)",
        b"(\xEF\xBF\xA3\xCE\xB5(#\xEF\xBF\xA3)\xE2\x98\x86\xE2\x95\xB0\xE2\x95\xAEo(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3///)",
        b"\xE3\x83\xBD(>_<\xE3\x83\xBD) \xE2\x80\x95\xE2\x8A\x82|=0\xE3\x83\x98(^\xE2\x80\xBF^ )",
        b"\xE3\x83\x98(>_<\xE3\x83\x98) \xEF\xBF\xA2o(\xEF\xBF\xA3\xE2\x80\xBF\xEF\xBF\xA3\xEF\xBE\x92)",
        b",,((( \xEF\xBF\xA3\xE2\x96\xA1)_\xEF\xBC\x8F \xEF\xBC\xBC_(\xE2\x97\x8B\xEF\xBF\xA3 ))),,",
        b"(\xD2\x82` \xEF\xBE\x9B \xC2\xB4)\xEF\xB8\xBB\xE3\x83\x87\xE2\x95\x90\xE4\xB8\x80 \xEF\xBC\xBC(\xC2\xBA \xE2\x96\xA1 \xC2\xBA l|l)/",
        b"(\xE2\x95\xAF\xC2\xB0\xD0\x94\xC2\xB0)\xE2\x95\xAF\xEF\xB8\xB5 /(.\xE2\x96\xA1 . \xEF\xBC\xBC)",
        b"(\xC2\xAC_\xC2\xAC'')\xD4\x85(\xEF\xBF\xA3\xCE\xB5\xEF\xBF\xA3\xD4\x85)",
        b"/( .\xE2\x96\xA1.)\xEF\xBC\xBC \xEF\xB8\xB5\xE2\x95\xB0(\xC2\xB0\xE7\x9B\x8A\xC2\xB0)\xE2\x95\xAF\xEF\xB8\xB5 /(.\xE2\x96\xA1. /)",
        b"(\xEF\xBE\x89-.-)\xEF\xBE\x89\xE2\x80\xA6.((((((((((((\xE2\x97\x8F~* ( >_<)",
        b"!!(\xEF\xBE\x92\xEF\xBF\xA3 \xEF\xBF\xA3)_\xCE\xB8\xE2\x98\x86\xC2\xB00\xC2\xB0)/",
        b"(`\xE2\x8C\x92*)O-(`\xE2\x8C\x92\xC2\xB4Q)",
        b"(((\xE0\xB8\x87\xE2\x80\x99\xCF\x89\xE2\x80\x99)\xD9\x88\xE4\xB8\x89 \xE0\xB8\x87\xE2\x80\x99\xCF\x89\xE2\x80\x99)\xDA\xA1\xE2\x89\xA1\xE3\x80\x80\xE2\x98\x86\xE2\x8C\x92\xEF\xBE\x90((x_x)",
        b"(\xE0\xB8\x87\xE0\xB2\xA0_\xE0\xB2\xA0)\xE0\xB8\x87\xE3\x80\x80\xCF\x83( \xE2\x80\xA2\xCC\x80 \xCF\x89 \xE2\x80\xA2\xCC\x81 \xCF\x83)",
        b"(\xE3\x81\xA3\xE2\x80\xA2\xEF\xB9\x8F\xE2\x80\xA2)\xE3\x81\xA3 \xE2\x9C\xB4==\xE2\x89\xA1\xEB\x88\x88\xD9\xA9(`\xE7\x9A\xBF\xC2\xB4\xD2\x82)\xE0\xB8\x87",
        b"(\xEF\xBD\xA2\xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2)\xEF\xBD\xA2 (\xE2\x8C\x92\xCF\x89\xE2\x8C\x92`)",
        b"( \xC2\xB0\xE1\xB4\x97\xC2\xB0)~\xC3\xB0 (/\xE2\x9D\x9Bo\xE2\x9D\x9B\\)",
    ];

    /// Rifle ︻デ═一, sniper rifle ︻┻┳══━一, shotgun ︻┳═一, minigun ✴==≡눈, gun ￢, laser ・・・--------☆, chain ○∞∞∞∞, bow D・・・・・------ →, bomb (((((((((●～*, syringe ―⊂|=0, pepper spray 占~~~~~, jo-jo ~~~~~~~~~~◎, boomerang (( く ((へ, spear ―――→, grabber ――――C, sword _／ or ¤=[]:::::>, boxing gloves QQ.
    pub const WEAPONS: [&[u8]; 18] = [
        b"( \xE3\x83\xBB\xE2\x88\x80\xE3\x83\xBB)\xE3\x83\xBB\xE3\x83\xBB\xE3\x83\xBB--------\xE2\x98\x86",
        b"(/-_\xE3\x83\xBB)/D\xE3\x83\xBB\xE3\x83\xBB\xE3\x83\xBB\xE3\x83\xBB\xE3\x83\xBB------ \xE2\x86\x92",
        b"(^\xCF\x89^)\xE3\x83\x8E\xEF\xBE\x9E(((((((((\xE2\x97\x8F\xEF\xBD\x9E*",
        b"( -\xCF\x89-)\xEF\xBC\x8F\xE5\x8D\xA0~~~~~",
        b"(/\xE3\x83\xBB\xE3\x83\xBB)\xE3\x83\x8E\xE3\x80\x80\xE3\x80\x80 (( \xE3\x81\x8F ((\xE3\x81\xB8",
        b"\xE2\x80\x95\xE2\x8A\x82|=0\xE3\x83\x98(^^ )",
        b"\xE2\x97\x8B\xE2\x88\x9E\xE2\x88\x9E\xE2\x88\x9E\xE2\x88\x9E\xE3\x83\xBD(^\xE3\x83\xBC^ )",
        b"(; \xE3\x83\xBB_\xE3\x83\xBB)\xE2\x80\x95\xE2\x80\x95\xE2\x80\x95\xE2\x80\x95C",
        b"(\xE0\xB2\xA0 o \xE0\xB2\xA0)\xC2\xA4=[]:::::>",
        b"(*\xEF\xBC\xBE\xEF\xBC\xBE)/~~~~~~~~~~\xE2\x97\x8E",
        b"\xEF\xBF\xA2o(\xEF\xBF\xA3-\xEF\xBF\xA3\xEF\xBE\x92)",
        b"\xE2\x80\x95(T_T)\xE2\x86\x92",
        b"((( \xEF\xBF\xA3\xE2\x96\xA1)_\xEF\xBC\x8F",
        b"(\xEF\xBE\x92` \xEF\xBE\x9B \xC2\xB4)\xEF\xB8\xBB\xE3\x83\x87\xE2\x95\x90\xE4\xB8\x80",
        b"( \xC2\xB4-\xCF\x89\xEF\xBD\xA5)\xEF\xB8\xBB\xE2\x94\xBB\xE2\x94\xB3\xE2\x95\x90\xE2\x95\x90\xE2\x94\x81\xE4\xB8\x80",
        b"(\xEF\xBE\x92\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)\xEF\xB8\xBB\xE2\x94\xB3\xE2\x95\x90\xE4\xB8\x80",
        b"\xE2\x9C\xB4==\xE2\x89\xA1\xEB\x88\x88\xD9\xA9(`\xE7\x9A\xBF\xC2\xB4\xD2\x82)\xE0\xB8\x87",
        b"Q(`\xE2\x8C\x92\xC2\xB4Q)",
    ];

    /// Japanese emoticons can depict even magic in its all diversity.
    pub const MAGIC: [&[u8]; 10] = [
        b"(\xE3\x83\x8E \xCB\x98_\xCB\x98)\xE3\x83\x8E\xE3\x80\x80\xCE\xB6|||\xCE\xB6\xE3\x80\x80\xCE\xB6|||\xCE\xB6\xE3\x80\x80\xCE\xB6|||\xCE\xB6",
        b"(\xEF\xBE\x89\xE2\x89\xA7\xE2\x88\x80\xE2\x89\xA6)\xEF\xBE\x89 \xE2\x80\xA5\xE2\x80\xA6\xE2\x94\x81\xE2\x94\x81\xE2\x94\x81\xE2\x98\x85",
        b"(\xEF\xBE\x89>\xCF\x89<)\xEF\xBE\x89 :\xEF\xBD\xA1\xEF\xBD\xA5:*:\xEF\xBD\xA5\xEF\xBE\x9F\xE2\x80\x99\xE2\x98\x85,\xEF\xBD\xA1\xEF\xBD\xA5:*:\xEF\xBD\xA5\xEF\xBE\x9F\xE2\x80\x99\xE2\x98\x86",
        b"(\xE3\x83\x8E\xC2\xB0\xE2\x88\x80\xC2\xB0)\xE3\x83\x8E\xE2\x8C\x92\xEF\xBD\xA5*:.\xEF\xBD\xA1. .\xEF\xBD\xA1.:*\xEF\xBD\xA5\xE3\x82\x9C\xEF\xBE\x9F\xEF\xBD\xA5*\xE2\x98\x86",
        b"\xE2\x95\xB0( \xCD\xA1\xC2\xB0 \xCD\x9C\xCA\x96 \xCD\xA1\xC2\xB0 )\xE3\x81\xA4\xE2\x94\x80\xE2\x94\x80\xE2\x98\x86*:\xE3\x83\xBB\xEF\xBE\x9F",
        b"(\xEF\xBC\x83\xEF\xBF\xA3\xE2\x96\xA1\xEF\xBF\xA3)o\xE2\x94\x81\xE2\x88\x88\xE3\x83\xBB\xE3\x83\xBB\xE2\x94\x81\xE2\x94\x81\xE2\x94\x81\xE2\x94\x81\xE2\x98\x86",
        b"(\xE2\x8A\x83\xEF\xBD\xA1\xE2\x80\xA2\xCC\x81\xE2\x80\xBF\xE2\x80\xA2\xCC\x80\xEF\xBD\xA1)\xE2\x8A\x83\xE2\x94\x81\xE2\x9C\xBF\xE2\x9C\xBF\xE2\x9C\xBF\xE2\x9C\xBF\xE2\x9C\xBF\xE2\x9C\xBF",
        b"(\xE2\x88\xA9\xE1\x84\x91_\xE1\x84\x91)\xE2\x8A\x83\xE2\x94\x81\xE2\x98\x86\xEF\xBE\x9F*\xEF\xBD\xA5\xEF\xBD\xA1*\xEF\xBD\xA5:\xE2\x89\xA1( \xCE\xB5:)",
        b"(/\xEF\xBF\xA3\xE3\x83\xBC\xEF\xBF\xA3)/~~\xE2\x98\x86\xE2\x80\x99.\xEF\xBD\xA5.\xEF\xBD\xA5:\xE2\x98\x85\xE2\x80\x99.\xEF\xBD\xA5.\xEF\xBD\xA5:\xE2\x98\x86",
        b"(\xE2\x88\xA9` \xEF\xBE\x9B \xC2\xB4)\xE2\x8A\x83\xE2\x94\x81\xE7\x82\x8E\xE7\x82\x8E\xE7\x82\x8E\xE7\x82\x8E\xE7\x82\x8E",
    ];

    /// Japanese like to drink very much! You can use 旦, 口, 且 and similar characters (for example, simply []) for this purpose. And for hot drinks (tea, coffee) just add ~~ (steam) characters. There is also a great variety of eating emoticons (see examples in the table below).
    pub const FOOD: [&[u8]; 18] = [
        b"(\xE3\x81\xA3\xCB\x98\xDA\xA1\xCB\x98\xCF\x82)",
        b"( o\xCB\x98\xE2\x97\xA1\xCB\x98o) \xE2\x94\x8Ciii\xE2\x94\x90",
        b"(\xE3\x80\x80\xE2\x80\x99\xCF\x89\xE2\x80\x99)\xE6\x97\xA6~~",
        b"( \xCB\x98\xE2\x96\xBD\xCB\x98)\xE3\x81\xA3\xE2\x99\xA8",
        b"\xE2\x99\xA8o(>_<)o\xE2\x99\xA8",
        b"( \xE3\x83\xBB\xCF\x89\xE3\x83\xBB)o-{{[\xE3\x80\x83]}}",
        b"(\xE3\x80\x80\xE3\x83\xBB\xCF\x89\xE3\x83\xBB)\xE2\x8A\x83-[\xE4\xBA\x8C\xE4\xBA\x8C]",
        b"( \xE3\x83\xBB\xE3\x83\xBB)\xE3\x81\xA4\xE2\x80\x95{}@{}@{}-",
        b"( \xE3\x83\xBB\xE3\x83\xBB)\xE3\x81\xA4-\xE2\x97\x8F\xE2\x97\x8F\xE2\x97\x8F",
        b"(*\xC2\xB4\xE3\x83\xBC`)\xE6\x97\xA6 \xE6\x97\xA6(\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3*)",
        b"(*\xC2\xB4\xD0\xB7`)\xE5\x8F\xA3\xEF\xBE\x9F\xEF\xBD\xA1\xEF\xBE\x9F\xE5\x8F\xA3(\xE3\x83\xBB\xE2\x88\x80\xE3\x83\xBB )",
        b"( o^ ^o)\xE4\xB8\x94 \xE4\xB8\x94(\xC2\xB4\xCF\x89`*)",
        b"( \xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)[] [](\xE2\x89\xA7\xE2\x96\xBD\xE2\x89\xA6 )",
        b"( *^^)o\xE2\x88\x80*\xE2\x88\x80o(^^* )",
        b"( ^^)_\xE6\x97\xA6~~\xE3\x80\x80 ~~U_(^^ )",
        b"(*\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)\xE6\x97\xA6 \xE4\xB8\x94(\xC2\xB4\xE2\x88\x80`*)",
        b"-\xE2\x97\x8F\xE2\x97\x8F\xE2\x97\x8F-\xEF\xBD\x83(\xE3\x83\xBB\xE3\x83\xBB )",
        b"( \xE3\x83\xBB\xE3\x83\xBB)\xE3\x81\xA4\xE2\x80\x95\xE2\x97\x8F\xE2\x97\x8B\xE2\x97\x8E-",
    ];

    /// Japanese emoticons can also describe musical aspects of life (singing, dancing, listening to music, etc.). You can just add ♪ character to your kaomoji or change its hands position (if you want to make it dance).
    pub const MUSIC: [&[u8]; 32] = [
        b"\xE3\x83\xBE(\xC2\xB4\xE3\x80\x87`)\xEF\xBE\x89\xE2\x99\xAA\xE2\x99\xAA\xE2\x99\xAA",
        b"\xE3\x83\x98(\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3\xE3\x83\x98)",
        b"(\xE3\x80\x9C\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)\xE3\x80\x9C",
        b"\xE3\x80\x9C(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3\xE3\x80\x9C)",
        b"\xE3\x83\xBD(o\xC2\xB4\xE2\x88\x80`)\xEF\xBE\x89\xE2\x99\xAA\xE2\x99\xAC",
        b"(\xEF\xBE\x89\xE2\x89\xA7\xE2\x88\x80\xE2\x89\xA6)\xEF\xBE\x89",
        b"\xE2\x99\xAA\xE3\x83\xBD(^^\xE3\x83\xBD)\xE2\x99\xAA",
        b"\xE2\x99\xAA(/_ _ )/\xE2\x99\xAA",
        b"\xE2\x99\xAA\xE2\x99\xAC((d\xE2\x8C\x92\xCF\x89\xE2\x8C\x92b))\xE2\x99\xAC\xE2\x99\xAA",
        b"\xE2\x94\x94(\xEF\xBF\xA3-\xEF\xBF\xA3\xE2\x94\x94))",
        b"((\xE2\x94\x98\xEF\xBF\xA3\xCF\x89\xEF\xBF\xA3)\xE2\x94\x98",
        b"\xE2\x88\x9A(\xEF\xBF\xA3\xE2\x80\xA5\xEF\xBF\xA3\xE2\x88\x9A)",
        b"\xE2\x94\x94(\xEF\xBC\xBE\xEF\xBC\xBE)\xE2\x94\x90",
        b"\xE2\x94\x8C(\xEF\xBC\xBE\xEF\xBC\xBE)\xE2\x94\x98",
        b"\xEF\xBC\xBC(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)\xEF\xBC\xBC",
        b"\xEF\xBC\x8F(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)\xEF\xBC\x8F",
        b"(\xEF\xBF\xA3\xE2\x96\xBD\xEF\xBF\xA3)/\xE2\x99\xAB\xE2\x80\xA2*\xC2\xA8*\xE2\x80\xA2.\xC2\xB8\xC2\xB8\xE2\x99\xAA",
        b"(^_^\xE2\x99\xAA)",
        b"(~\xCB\x98\xE2\x96\xBD\xCB\x98)~",
        b"~(\xCB\x98\xE2\x96\xBD\xCB\x98~)",
        b"\xE3\x83\xBE(\xE2\x8C\x90\xE2\x96\xA0_\xE2\x96\xA0)\xE3\x83\x8E\xE2\x99\xAA",
        b"(\xE3\x80\x9C\xEF\xBF\xA3\xE2\x96\xB3\xEF\xBF\xA3)\xE3\x80\x9C",
        b"(~\xE2\x80\xBE\xE2\x96\xBD\xE2\x80\xBE)~",
        b"~(\xCB\x98\xE2\x96\xBD\xCB\x98)~",
        b"\xE4\xB9\x81( \xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2\xE4\xB9\x81)",
        b"(\xEF\xBD\xA2\xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2)\xEF\xBD\xA2",
        b"\xE2\x81\xBD\xE2\x81\xBD\xE2\x97\x9D( \xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2 )\xE2\x97\x9C\xE2\x81\xBE\xE2\x81\xBE",
        b"\xE2\x9C\xBA\xE2\x97\x9F( \xE2\x80\xA2 \xCF\x89 \xE2\x80\xA2 )\xE2\x97\x9E\xE2\x9C\xBA",
        b"\xE2\x99\xAC\xE2\x99\xAB\xE2\x99\xAA\xE2\x97\x96(\xE2\x97\x8F o \xE2\x97\x8F)\xE2\x97\x97\xE2\x99\xAA\xE2\x99\xAB\xE2\x99\xAC",
        b"( \xCB\x98 \xC9\x9C\xCB\x98) \xE2\x99\xAC\xE2\x99\xAA\xE2\x99\xAB",
        b"\xE2\x99\xAA\xE2\x99\xAA\xE2\x99\xAA \xE3\x83\xBD(\xCB\x87\xE2\x88\x80\xCB\x87 )\xE3\x82\x9E",
        b"(\xCB\x87\xE2\x96\xBD\xCB\x87)\xE3\x83\x8E\xE2\x99\xAA\xE2\x99\xAC\xE2\x99\xAB",
    ];
    /// Japanese can describe even games and sports through kaomoji. Here are a few examples: tennis, ping pong, volleyball, basketball, ball, boxing, kendo, fishing, bowling, playing video games. Try to find out what is what.
    pub const GAMES: [&[u8]; 10] = [
        b"( ^^)p_____|_o____q(^^ )",
        b"(\xEF\xBC\x8Fo^)/ \xC2\xB0\xE2\x8A\xA5 \xEF\xBC\xBC(^o\xEF\xBC\xBC)",
        b"!(;\xEF\xBE\x9Fo\xEF\xBE\x9F)o/\xEF\xBF\xA3\xEF\xBF\xA3\xEF\xBF\xA3\xEF\xBF\xA3\xEF\xBF\xA3\xEF\xBF\xA3\xEF\xBF\xA3~ >\xEF\xBE\x9F))))\xE5\xBD\xA1",
        b"\xE3\x83\xBD(^o^)\xCF\x81\xE2\x94\xB3\xE2\x94\xBB\xE2\x94\xB3\xC2\xB0\xCF\x83(^o^)\xE3\x83\x8E",
        b"(\xEF\xBC\x8F_^)\xEF\xBC\x8F\xE3\x80\x80\xE3\x80\x80\xE2\x97\x8F\xE3\x80\x80\xEF\xBC\xBC(^_\xEF\xBC\xBC)",
        b"\"( (\xE2\x89\xA1|\xE2\x89\xA1))_\xEF\xBC\x8F \xEF\xBC\xBC_((\xE2\x89\xA1|\xE2\x89\xA1) )\"",
        b"( \xE3\x83\x8E-_-)\xE3\x83\x8E\xEF\xBE\x9E_\xE2\x96\xA1 VS \xE2\x96\xA1_\xE3\x83\xBE(^-^\xE3\x83\xBD)",
        b"\xE3\x83\xBD(\xEF\xBC\x9B^ ^)\xE3\x83\x8E\xEF\xBE\x9E \xEF\xBC\x8E\xEF\xBC\x8E\xEF\xBC\x8E...___\xE3\x80\x87",
        b"(=O*_*)=O Q(*_*Q)",
        b"\xD0\xAE\xE3\x80\x80\xE2\x97\x8B\xE4\xB8\x89\xE3\x80\x80\xEF\xBC\xBC(\xEF\xBF\xA3^\xEF\xBF\xA3\xEF\xBC\xBC)",
    ];

    /// These emoticons have human-like faces.
    pub const FACES: [&[u8]; 18] = [
        b"( \xCD\xA1\xC2\xB0 \xCD\x9C\xCA\x96 \xCD\xA1\xC2\xB0)",
        b"( \xCD\xA1\xC2\xB0 \xCA\x96\xCC\xAF \xCD\xA1\xC2\xB0)",
        b"( \xCD\xA0\xC2\xB0 \xCD\x9F\xCA\x96 \xCD\xA1\xC2\xB0)",
        b"( \xCD\xA1\xE1\xB5\x94 \xCD\x9C\xCA\x96 \xCD\xA1\xE1\xB5\x94)",
        b"( . \xE2\x80\xA2\xCC\x81 _\xCA\x96 \xE2\x80\xA2\xCC\x80 .)",
        b"( \xE0\xB0\xA0 \xCD\x9F\xCA\x96 \xE0\xB0\xA0)",
        b"( \xCD\xA1\xE0\xB2\xA0 \xCA\x96\xCC\xAF \xCD\xA1\xE0\xB2\xA0)",
        b"( \xE0\xB2\xA0 \xCA\x96\xCC\xAF \xE0\xB2\xA0)",
        b"( \xE0\xB2\xA0 \xCD\x9C\xCA\x96 \xE0\xB2\xA0)",
        b"( \xE0\xB2\xA5 \xCA\x96\xCC\xAF \xE0\xB2\xA5)",
        b"( \xCD\xA1\xE2\x80\xA2 \xCD\x9C\xCA\x96 \xCD\xA1\xE2\x80\xA2 )",
        b"( \xEF\xBD\xA5\xE0\xB8\xB4 \xCD\x9C\xCA\x96 \xEF\xBD\xA5\xE0\xB8\xB4)",
        b"( \xCD\xA1 \xCD\x9C\xCA\x96 \xCD\xA1 )",
        b"(\xE2\x89\x96 \xCD\x9C\xCA\x96\xE2\x89\x96)",
        b"(\xCA\x98 \xCA\x96\xCC\xAF \xCA\x98)",
        b"(\xCA\x98 \xCD\x9F\xCA\x96 \xCA\x98)",
        b"(\xCA\x98 \xCD\x9C\xCA\x96 \xCA\x98)",
        b"(;\xC2\xB4\xE0\xBC\x8E\xE0\xBA\xB6\xD9\xB9\xE0\xBC\x8E\xE0\xBA\xB6`)",
    ];

    #[cfg(test)]
    mod tests {
        #[test]
        fn friends() {
            test!(super::FRIENDS)
        }

        #[test]
        fn enemies() {
            test!(super::ENEMIES)
        }

        #[test]
        fn weapons() {
            test!(super::WEAPONS)
        }

        #[test]
        fn magic() {
            test!(super::MAGIC)
        }

        #[test]
        fn food() {
            test!(super::FOOD)
        }

        #[test]
        fn music() {
            test!(super::MUSIC)
        }

        #[test]
        fn games() {
            test!(super::GAMES)
        }

        #[test]
        fn faces() {
            test!(super::FACES)
        }
    }
}

/// No specific category emoticons are added here. So each of them has special description.
pub mod special {
    pub const WAKING_UP: &[u8] = b"\xD9\xA9(\xCB\x8A\xE3\x80\x87\xCB\x8B*)\xD9\x88";
    pub const MILITARY_SALUTATION: &[u8] = b"(\xEF\xBF\xA3^\xEF\xBF\xA3)\xE3\x82\x9E";
    pub const FACE_PALM: &[u8] = b"(\xEF\xBC\x8D\xE2\x80\xB8\xE1\x83\x9A)";
    pub const THROWING_TABLE_IN_ANGER: &[u8] = b"(\xE2\x95\xAF\xC2\xB0\xE7\x9B\x8A\xC2\xB0)\xE2\x95\xAF\xE5\xBD\xA1\xE2\x94\xBB\xE2\x94\x81\xE2\x94\xBB";
    pub const TAKING_TABLE_AND_GOING_MAD: &[u8] = b"(\xE2\x95\xAE\xC2\xB0-\xC2\xB0)\xE2\x95\xAE\xE2\x94\xB3\xE2\x94\x81\xE2\x94\x81\xE2\x94\xB3 ( \xE2\x95\xAF\xC2\xB0\xE2\x96\xA1\xC2\xB0)\xE2\x95\xAF \xE2\x94\xBB\xE2\x94\x81\xE2\x94\x81\xE2\x94\xBB";
    pub const PUTTING_TABLE_BACK: &[u8] =
        b"\xE2\x94\xAC\xE2\x94\x80\xE2\x94\xAC\xE3\x83\x8E( \xC2\xBA _ \xC2\xBA\xE3\x83\x8E)";
    pub const SURRENDER: &[u8] = b"(oT-T)\xE5\xB0\xB8";
    pub const MEME_LENNY_FACE: &[u8] = b"( \xCD\xA1\xC2\xB0 \xCD\x9C\xCA\x96 \xCD\xA1\xC2\xB0)";
    pub const MONEY: &[u8] = b"[\xCC\xB2\xCC\x85$\xCC\xB2\xCC\x85(\xCC\xB2\xCC\x85 \xCD\xA1\xC2\xB0 \xCD\x9C\xCA\x96 \xCD\xA1\xC2\xB0\xCC\xB2\xCC\x85)\xCC\xB2\xCC\x85$\xCC\xB2\xCC\x85]";
    pub const MEME_LOOK_OF_DISSAPROVAL: &[u8] = b"(\xE0\xB2\xA0_\xE0\xB2\xA0)";
    pub const SMOKING: &[u8] = b"\xE0\xB1\xA6\xEF\xBC\x90o \xEF\xBD\xA1 (\xE2\x80\xBE\xCC\x81\xE3\x80\x82\xE2\x80\xBE\xCC\x81 )y~~";
    pub const HUNGRY: &[u8] = b"(\xEF\xBF\xA3\xEF\xB9\x83\xEF\xBF\xA3)";
    pub const ALIVE_AMONG_ZOMBIES: &[u8] = b"(x(x_(x_x(O_o)x_x)_x)x)";
    pub const POINTING: &[u8] = b"(\xE3\x80\x80\xEF\xBD\xA5\xCF\x89\xEF\xBD\xA5)\xE2\x98\x9E";
    pub const WITH_GLASSES: &[u8] = b"(\xE2\x8C\x90\xE2\x96\xA0_\xE2\x96\xA0)";
    pub const CUTE_FACE: &[u8] = b"(\xE2\x97\x95\xE2\x80\xBF\xE2\x97\x95\xE2\x9C\xBF)";
    pub const WATCHING_TV: &[u8] = b"(\xE3\x80\x80\xEF\xBF\xA3.)o-\xE3\x80\x80\xE3\x80\x80\xE3\x80\x90\xE3\x80\x80TV\xE3\x80\x80\xE3\x80\x91";
    pub const CATCHING_UMBRELLA_IN_THE_RAIN: &[u8] = b"\xEF\xBD\x80\xE3\x80\x81\xE3\x83\xBD\xEF\xBD\x80\xE3\x83\xBD\xEF\xBD\x80\xE3\x80\x81\xE3\x83\xBD(\xE3\x83\x8E\xEF\xBC\x9E\xEF\xBC\x9C)\xE3\x83\x8E \xEF\xBD\x80\xE3\x80\x81\xE3\x83\xBD\xEF\xBD\x80\xE2\x98\x82\xE3\x83\xBD\xEF\xBD\x80\xE3\x80\x81\xE3\x83\xBD";
    pub const DROWNING: &[u8] = b"\xE2\x80\xBF\xEF\xB8\xB5\xE2\x80\xBF\xEF\xB8\xB5\xE2\x80\xBF\xEF\xB8\xB5\xE2\x80\xBF\xE3\x83\xBD(\xC2\xB0\xE2\x96\xA1\xC2\xB0 )\xE3\x83\x8E\xEF\xB8\xB5\xE2\x80\xBF\xEF\xB8\xB5\xE2\x80\xBF\xEF\xB8\xB5\xE2\x80\xBF\xEF\xB8\xB5";
    pub const EMM_TRY_TO_FIGURE_OUT_WHAT_HES_DOING: &[u8] =
        b"( \xE2\x80\xA2 )( \xE2\x80\xA2 )\xD4\x85(\xE2\x89\x96\xE2\x80\xBF\xE2\x89\x96\xD4\x85)";
    pub const PUNISHMENT_FOR_CHEATING: &[u8] = b"( \xEF\xBC\xBE\xE2\x96\xBD\xEF\xBC\xBE)\xE3\x81\xA3\xE2\x9C\x82\xE2\x95\xB0\xE2\x8B\x83\xE2\x95\xAF";
    pub const CHASING_A_BUTTERYFLY: &[u8] = b"\xE3\x80\x9C\xE3\x80\x9C(\xEF\xBC\x8F\xEF\xBF\xA3\xE2\x96\xBD)\xEF\xBC\x8F\xE3\x80\x80\xE3\x80\x9C\xD1\x84";
    pub const ANGEL: &[u8] = b"\xE0\xAC\x98(\xE0\xA9\xAD\xCB\x8A\xE1\xB5\x95\xCB\x8B)\xE0\xA9\xAD* \xE0\xA9\x88\xE2\x9C\xA9\xE2\x80\xA7\xE2\x82\x8A\xCB\x9A";
    pub const ONE_MORE_ANGEL: &[u8] = b"\xE0\xAC\x98(\xE0\xA9\xAD\xCB\x8A\xEA\x92\xB3\xE2\x80\x8B\xCB\x8B)\xE0\xA9\xAD\xE2\x9C\xA7";
    pub const POPULAR_LYING_EMOTICON: &[u8] = b"_(:3 \xE3\x80\x8D\xE2\x88\xA0)_";
    pub const ANOTHER_LYING_EMOTICON: &[u8] =
        b"\xE2\x88\xA0( \xE1\x90\x9B \xE3\x80\x8D\xE2\x88\xA0)_";

    #[cfg(test)]
    mod tests {
        #[test]
        fn special() {
            test_string!(0, super::WAKING_UP);
            test_string!(0, super::MILITARY_SALUTATION);
            test_string!(0, super::FACE_PALM);
            test_string!(0, super::THROWING_TABLE_IN_ANGER);
            test_string!(0, super::TAKING_TABLE_AND_GOING_MAD);
            test_string!(0, super::PUTTING_TABLE_BACK);
            test_string!(0, super::SURRENDER);
            test_string!(0, super::MEME_LENNY_FACE);
            test_string!(0, super::MONEY);
            test_string!(0, super::MEME_LOOK_OF_DISSAPROVAL);
            test_string!(0, super::SMOKING);
            test_string!(0, super::HUNGRY);
            test_string!(0, super::ALIVE_AMONG_ZOMBIES);
            test_string!(0, super::POINTING);
            test_string!(0, super::WITH_GLASSES);
            test_string!(0, super::CUTE_FACE);
            test_string!(0, super::WATCHING_TV);
            test_string!(0, super::CATCHING_UMBRELLA_IN_THE_RAIN);
            test_string!(0, super::DROWNING);
            test_string!(0, super::EMM_TRY_TO_FIGURE_OUT_WHAT_HES_DOING);
            test_string!(0, super::PUNISHMENT_FOR_CHEATING);
            test_string!(0, super::CHASING_A_BUTTERYFLY);
            test_string!(0, super::ANGEL);
            test_string!(0, super::ONE_MORE_ANGEL);
            test_string!(0, super::POPULAR_LYING_EMOTICON);
            test_string!(0, super::ANOTHER_LYING_EMOTICON);
        }
    }
}

pub const ASCII: [&[u8]; 31] = [
    positive_emotions::EMBARRESMENT[1],
    positive_emotions::EMBARRESMENT[6],
    positive_emotions::EMBARRESMENT[14],
    negative_emotions::DISSATISFACTION[18],
    negative_emotions::DISSATISFACTION[22],
    negative_emotions::SADNESS[1],
    negative_emotions::SADNESS[28],
    negative_emotions::SADNESS[29],
    negative_emotions::PAIN[0],
    negative_emotions::PAIN[5],
    negative_emotions::FEAR[5],
    negative_emotions::FEAR[14],
    neutral_emotions::SUPRISE[5],
    neutral_emotions::SUPRISE[6],
    neutral_emotions::SUPRISE[7],
    neutral_emotions::SUPRISE[9],
    various_actions::GREETING[4],
    various_actions::GREETING[23],
    various_actions::HUGGING[12],
    various_actions::WINKING[0],
    various_actions::WINKING[2],
    various_actions::WINKING[6],
    various_actions::WINKING[12],
    various_actions::WINKING[16],
    various_actions::APOLOGIZING[0],
    various_actions::APOLOGIZING[2],
    various_actions::APOLOGIZING[3],
    various_actions::APOLOGIZING[6],
    various_actions::APOLOGIZING[7],
    various_actions::SLEEPING[5],
    various_actions::SLEEPING[9],
];
