# KanOrg: kanban organizer

[![](https://img.shields.io/crates/v/kanorg)][kanorg-crate]
[![](https://img.shields.io/badge/docs.rs-v0.3.1-blue)][kanorg-doc]

> KanOrg allows you easily organize all your tasks from the terminal.

This commandline application will help you save everything important and will
let you take the control of your work (and not the other way around).

---

Table of contents:

<!-- markdownlint-disable MD030 -->
1. [Roadmap :scroll:](#roadmap-scroll)
2. [Installation :floppy_disk:](#installation-floppy_disk)
3. [Before running anything, some basics :warning:](#before-running-anything-some-basics-warning)
4. [CLI :dvd:](#cli-dvd)
   1. [Create](#create)
   2. [Show](#show)
   3. [Add](#add)
   4. [Move](#move)
   5. [Edit](#edit)
   6. [Delete](#delete)
5. [Running tests :bomb:](#running-tests-bomb)
6. [License :bookmark:](#license-bookmark)
<!-- markdownlint-restore -->

---

## Roadmap :scroll:

Missing commandline features:

- [ ] Move a task from one workflow to another
- [ ] Edit a task
- [ ] Delete a task

Other features:

- [ ] Add due date and priority tags (maybe with automatic colours)
- [ ] Add a command to list/remove/show archived tasks
- [ ] Add a command to show a task without editing

**If you want to request a new feature, create an issue!**

## Installation :floppy_disk:

To install the package into `$HOME/.cargo/bin` run:

```shell
cargo install kanorg
```

## Before running anything, some basics :warning:

This CLI is based on a well defined directory structure. It is based on a main
directory `.kanorg.d`, the configuration file (`.kanorg.d/config`), and the
active and archived task directories (`.kanorg.d/active.d` and
`.kanorg.d/archive.d` respectively).

Take a look to the ["examples"](./examples/) directory where all the files
mentioned above can be found. By default, when you create a new *KanOrg* config
directory, you will have empty active and archive directories with empty lists
of tasks in the config file.

## CLI :dvd:

In this section some use cases of each command will be mentioned. You can also
check an in-depth [documentation][kanorg-doc] of the library.

### Create

To create a new configuration environment you can run:

```shell
ko c[reate] [<target directory>]
```

By default, if you don't pass the `<target directory>` argument, it will create
the configuration in the current directory.

### Show

To show the active tasks you can run:

```shell
ko s[how] [<workflow name>]
```

If no workflow is specified you will get something like:

```plain
|          TODO           |          DOING          |          DONE           |
|-------------------------|-------------------------|-------------------------|
|  18 This is the task 18 |  14 This is the task 14 |  12 This is the task 12 |
|  17 This is the task 17 |  13 This is the task 13 |  11 This is the task 11 |
|  16 This is the task 16 |                         |  10 This is the task 10 |
|  15 This is the task 15 |                         |   9 This is the task 9  |
|                         |                         |   8 This is the task 8  |

BACKLOG
  25 This is the task 25 sample title
  24 This is the task 24 sample title
  23 This is the task 23 sample title
  22 This is the task 22 sample title
  21 This is the task 21 sample title
WARNING: The backlog has been trimmed. Run `ko show backlog` to see all the backlog tasks.
```

You can also specify some workflow to list all the tasks in it. It will show
something like:

```plain
BACKLOG
  25 This is the task 25 sample title
  24 This is the task 24 sample title
  23 This is the task 23 sample title
  22 This is the task 22 sample title
  21 This is the task 21 sample title
  20 This is the task 20 sample title
  19 This is the task 19 sample title
```

### Add

You can add a new task with:

```shell
ko a[dd] <task title> [<workflow name>]
```

If the `<workflow name>` is not specified, the new task will be created in
*backlog*.

### Move

In order to move a task from one workflow to another:

```shell
ko m[ove] <task ID> [<workflow name>]
```

If no `<workflow name>` is specified, it will be moved to backlog.

### Edit

> *Not implemented yet*

### Delete

> *Not implemented yet*

## Running tests :bomb:

In order to run the package tests:

```shell
cargo test [(--lib | --tests integration)]
```

## License :bookmark:

The source code is released under the [MIT license](./LICENSE).

[TOLM]: https://toml.io/en/
[kanorg-crate]: https://crates.io/crates/kanorg
[kanorg-doc]: https://docs.rs/kanorg/0.3.1/kanorg/index.html
