// This file is taken from the original ktrl project's keys.rs file with modifications.

use evdev_rs::enums::{EventCode, EventType, EV_KEY};
use evdev_rs::{InputEvent, TimeVal};
use kanata_keyberon::key_code::*;
use std::convert::TryFrom;

/// This is a shameless copy of evdev_rs::enums::EV_KEY.
/// I've added the Copy trait and I'll be able
/// to added my own Impl(s) to it
#[allow(non_camel_case_types)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash)]
pub enum OsCode {
    KEY_RESERVED = 0,
    KEY_ESC = 1,
    KEY_1 = 2,
    KEY_2 = 3,
    KEY_3 = 4,
    KEY_4 = 5,
    KEY_5 = 6,
    KEY_6 = 7,
    KEY_7 = 8,
    KEY_8 = 9,
    KEY_9 = 10,
    KEY_0 = 11,
    KEY_MINUS = 12,
    KEY_EQUAL = 13,
    KEY_BACKSPACE = 14,
    KEY_TAB = 15,
    KEY_Q = 16,
    KEY_W = 17,
    KEY_E = 18,
    KEY_R = 19,
    KEY_T = 20,
    KEY_Y = 21,
    KEY_U = 22,
    KEY_I = 23,
    KEY_O = 24,
    KEY_P = 25,
    KEY_LEFTBRACE = 26,
    KEY_RIGHTBRACE = 27,
    KEY_ENTER = 28,
    KEY_LEFTCTRL = 29,
    KEY_A = 30,
    KEY_S = 31,
    KEY_D = 32,
    KEY_F = 33,
    KEY_G = 34,
    KEY_H = 35,
    KEY_J = 36,
    KEY_K = 37,
    KEY_L = 38,
    KEY_SEMICOLON = 39,
    KEY_APOSTROPHE = 40,
    KEY_GRAVE = 41,
    KEY_LEFTSHIFT = 42,
    KEY_BACKSLASH = 43,
    KEY_Z = 44,
    KEY_X = 45,
    KEY_C = 46,
    KEY_V = 47,
    KEY_B = 48,
    KEY_N = 49,
    KEY_M = 50,
    KEY_COMMA = 51,
    KEY_DOT = 52,
    KEY_SLASH = 53,
    KEY_RIGHTSHIFT = 54,
    KEY_KPASTERISK = 55,
    KEY_LEFTALT = 56,
    KEY_SPACE = 57,
    KEY_CAPSLOCK = 58,
    KEY_F1 = 59,
    KEY_F2 = 60,
    KEY_F3 = 61,
    KEY_F4 = 62,
    KEY_F5 = 63,
    KEY_F6 = 64,
    KEY_F7 = 65,
    KEY_F8 = 66,
    KEY_F9 = 67,
    KEY_F10 = 68,
    KEY_NUMLOCK = 69,
    KEY_SCROLLLOCK = 70,
    KEY_KP7 = 71,
    KEY_KP8 = 72,
    KEY_KP9 = 73,
    KEY_KPMINUS = 74,
    KEY_KP4 = 75,
    KEY_KP5 = 76,
    KEY_KP6 = 77,
    KEY_KPPLUS = 78,
    KEY_KP1 = 79,
    KEY_KP2 = 80,
    KEY_KP3 = 81,
    KEY_KP0 = 82,
    KEY_KPDOT = 83,
    KEY_ZENKAKUHANKAKU = 85,
    KEY_102ND = 86,
    KEY_F11 = 87,
    KEY_F12 = 88,
    KEY_RO = 89,
    KEY_KATAKANA = 90,
    KEY_HIRAGANA = 91,
    KEY_HENKAN = 92,
    KEY_KATAKANAHIRAGANA = 93,
    KEY_MUHENKAN = 94,
    KEY_KPJPCOMMA = 95,
    KEY_KPENTER = 96,
    KEY_RIGHTCTRL = 97,
    KEY_KPSLASH = 98,
    KEY_SYSRQ = 99,
    KEY_RIGHTALT = 100,
    KEY_LINEFEED = 101,
    KEY_HOME = 102,
    KEY_UP = 103,
    KEY_PAGEUP = 104,
    KEY_LEFT = 105,
    KEY_RIGHT = 106,
    KEY_END = 107,
    KEY_DOWN = 108,
    KEY_PAGEDOWN = 109,
    KEY_INSERT = 110,
    KEY_DELETE = 111,
    KEY_MACRO = 112,
    KEY_MUTE = 113,
    KEY_VOLUMEDOWN = 114,
    KEY_VOLUMEUP = 115,
    KEY_POWER = 116,
    KEY_KPEQUAL = 117,
    KEY_KPPLUSMINUS = 118,
    KEY_PAUSE = 119,
    KEY_SCALE = 120,
    KEY_KPCOMMA = 121,
    KEY_HANGEUL = 122,
    KEY_HANJA = 123,
    KEY_YEN = 124,
    KEY_LEFTMETA = 125,
    KEY_RIGHTMETA = 126,
    KEY_COMPOSE = 127,
    KEY_STOP = 128,
    KEY_AGAIN = 129,
    KEY_PROPS = 130,
    KEY_UNDO = 131,
    KEY_FRONT = 132,
    KEY_COPY = 133,
    KEY_OPEN = 134,
    KEY_PASTE = 135,
    KEY_FIND = 136,
    KEY_CUT = 137,
    KEY_HELP = 138,
    KEY_MENU = 139,
    KEY_CALC = 140,
    KEY_SETUP = 141,
    KEY_SLEEP = 142,
    KEY_WAKEUP = 143,
    KEY_FILE = 144,
    KEY_SENDFILE = 145,
    KEY_DELETEFILE = 146,
    KEY_XFER = 147,
    KEY_PROG1 = 148,
    KEY_PROG2 = 149,
    KEY_WWW = 150,
    KEY_MSDOS = 151,
    KEY_COFFEE = 152,
    KEY_ROTATE_DISPLAY = 153,
    KEY_CYCLEWINDOWS = 154,
    KEY_MAIL = 155,
    KEY_BOOKMARKS = 156,
    KEY_COMPUTER = 157,
    KEY_BACK = 158,
    KEY_FORWARD = 159,
    KEY_CLOSECD = 160,
    KEY_EJECTCD = 161,
    KEY_EJECTCLOSECD = 162,
    KEY_NEXTSONG = 163,
    KEY_PLAYPAUSE = 164,
    KEY_PREVIOUSSONG = 165,
    KEY_STOPCD = 166,
    KEY_RECORD = 167,
    KEY_REWIND = 168,
    KEY_PHONE = 169,
    KEY_ISO = 170,
    KEY_CONFIG = 171,
    KEY_HOMEPAGE = 172,
    KEY_REFRESH = 173,
    KEY_EXIT = 174,
    KEY_MOVE = 175,
    KEY_EDIT = 176,
    KEY_SCROLLUP = 177,
    KEY_SCROLLDOWN = 178,
    KEY_KPLEFTPAREN = 179,
    KEY_KPRIGHTPAREN = 180,
    KEY_NEW = 181,
    KEY_REDO = 182,
    KEY_F13 = 183,
    KEY_F14 = 184,
    KEY_F15 = 185,
    KEY_F16 = 186,
    KEY_F17 = 187,
    KEY_F18 = 188,
    KEY_F19 = 189,
    KEY_F20 = 190,
    KEY_F21 = 191,
    KEY_F22 = 192,
    KEY_F23 = 193,
    KEY_F24 = 194,
    KEY_PLAYCD = 200,
    KEY_PAUSECD = 201,
    KEY_PROG3 = 202,
    KEY_PROG4 = 203,
    KEY_DASHBOARD = 204,
    KEY_SUSPEND = 205,
    KEY_CLOSE = 206,
    KEY_PLAY = 207,
    KEY_FASTFORWARD = 208,
    KEY_BASSBOOST = 209,
    KEY_PRINT = 210,
    KEY_HP = 211,
    KEY_CAMERA = 212,
    KEY_SOUND = 213,
    KEY_QUESTION = 214,
    KEY_EMAIL = 215,
    KEY_CHAT = 216,
    KEY_SEARCH = 217,
    KEY_CONNECT = 218,
    KEY_FINANCE = 219,
    KEY_SPORT = 220,
    KEY_SHOP = 221,
    KEY_ALTERASE = 222,
    KEY_CANCEL = 223,
    KEY_BRIGHTNESSDOWN = 224,
    KEY_BRIGHTNESSUP = 225,
    KEY_MEDIA = 226,
    KEY_SWITCHVIDEOMODE = 227,
    KEY_KBDILLUMTOGGLE = 228,
    KEY_KBDILLUMDOWN = 229,
    KEY_KBDILLUMUP = 230,
    KEY_SEND = 231,
    KEY_REPLY = 232,
    KEY_FORWARDMAIL = 233,
    KEY_SAVE = 234,
    KEY_DOCUMENTS = 235,
    KEY_BATTERY = 236,
    KEY_BLUETOOTH = 237,
    KEY_WLAN = 238,
    KEY_UWB = 239,
    KEY_UNKNOWN = 240,
    KEY_VIDEO_NEXT = 241,
    KEY_VIDEO_PREV = 242,
    KEY_BRIGHTNESS_CYCLE = 243,
    KEY_BRIGHTNESS_AUTO = 244,
    KEY_DISPLAY_OFF = 245,
    KEY_WWAN = 246,
    KEY_RFKILL = 247,
    KEY_MICMUTE = 248,
    KEY_OK = 352,
    KEY_SELECT = 353,
    KEY_GOTO = 354,
    KEY_CLEAR = 355,
    KEY_POWER2 = 356,
    KEY_OPTION = 357,
    KEY_INFO = 358,
    KEY_TIME = 359,
    KEY_VENDOR = 360,
    KEY_ARCHIVE = 361,
    KEY_PROGRAM = 362,
    KEY_CHANNEL = 363,
    KEY_FAVORITES = 364,
    KEY_EPG = 365,
    KEY_PVR = 366,
    KEY_MHP = 367,
    KEY_LANGUAGE = 368,
    KEY_TITLE = 369,
    KEY_SUBTITLE = 370,
    KEY_ANGLE = 371,
    KEY_FULL_SCREEN = 372,
    KEY_MODE = 373,
    KEY_KEYBOARD = 374,
    KEY_ASPECT_RATIO = 375,
    KEY_PC = 376,
    KEY_TV = 377,
    KEY_TV2 = 378,
    KEY_VCR = 379,
    KEY_VCR2 = 380,
    KEY_SAT = 381,
    KEY_SAT2 = 382,
    KEY_CD = 383,
    KEY_TAPE = 384,
    KEY_RADIO = 385,
    KEY_TUNER = 386,
    KEY_PLAYER = 387,
    KEY_TEXT = 388,
    KEY_DVD = 389,
    KEY_AUX = 390,
    KEY_MP3 = 391,
    KEY_AUDIO = 392,
    KEY_VIDEO = 393,
    KEY_DIRECTORY = 394,
    KEY_LIST = 395,
    KEY_MEMO = 396,
    KEY_CALENDAR = 397,
    KEY_RED = 398,
    KEY_GREEN = 399,
    KEY_YELLOW = 400,
    KEY_BLUE = 401,
    KEY_CHANNELUP = 402,
    KEY_CHANNELDOWN = 403,
    KEY_FIRST = 404,
    KEY_LAST = 405,
    KEY_AB = 406,
    KEY_NEXT = 407,
    KEY_RESTART = 408,
    KEY_SLOW = 409,
    KEY_SHUFFLE = 410,
    KEY_BREAK = 411,
    KEY_PREVIOUS = 412,
    KEY_DIGITS = 413,
    KEY_TEEN = 414,
    KEY_TWEN = 415,
    KEY_VIDEOPHONE = 416,
    KEY_GAMES = 417,
    KEY_ZOOMIN = 418,
    KEY_ZOOMOUT = 419,
    KEY_ZOOMRESET = 420,
    KEY_WORDPROCESSOR = 421,
    KEY_EDITOR = 422,
    KEY_SPREADSHEET = 423,
    KEY_GRAPHICSEDITOR = 424,
    KEY_PRESENTATION = 425,
    KEY_DATABASE = 426,
    KEY_NEWS = 427,
    KEY_VOICEMAIL = 428,
    KEY_ADDRESSBOOK = 429,
    KEY_MESSENGER = 430,
    KEY_DISPLAYTOGGLE = 431,
    KEY_SPELLCHECK = 432,
    KEY_LOGOFF = 433,
    KEY_DOLLAR = 434,
    KEY_EURO = 435,
    KEY_FRAMEBACK = 436,
    KEY_FRAMEFORWARD = 437,
    KEY_CONTEXT_MENU = 438,
    KEY_MEDIA_REPEAT = 439,
    KEY_10CHANNELSUP = 440,
    KEY_10CHANNELSDOWN = 441,
    KEY_IMAGES = 442,
    KEY_DEL_EOL = 448,
    KEY_DEL_EOS = 449,
    KEY_INS_LINE = 450,
    KEY_DEL_LINE = 451,
    KEY_FN = 464,
    KEY_FN_ESC = 465,
    KEY_FN_F1 = 466,
    KEY_FN_F2 = 467,
    KEY_FN_F3 = 468,
    KEY_FN_F4 = 469,
    KEY_FN_F5 = 470,
    KEY_FN_F6 = 471,
    KEY_FN_F7 = 472,
    KEY_FN_F8 = 473,
    KEY_FN_F9 = 474,
    KEY_FN_F10 = 475,
    KEY_FN_F11 = 476,
    KEY_FN_F12 = 477,
    KEY_FN_1 = 478,
    KEY_FN_2 = 479,
    KEY_FN_D = 480,
    KEY_FN_E = 481,
    KEY_FN_F = 482,
    KEY_FN_S = 483,
    KEY_FN_B = 484,
    KEY_BRL_DOT1 = 497,
    KEY_BRL_DOT2 = 498,
    KEY_BRL_DOT3 = 499,
    KEY_BRL_DOT4 = 500,
    KEY_BRL_DOT5 = 501,
    KEY_BRL_DOT6 = 502,
    KEY_BRL_DOT7 = 503,
    KEY_BRL_DOT8 = 504,
    KEY_BRL_DOT9 = 505,
    KEY_BRL_DOT10 = 506,
    KEY_NUMERIC_0 = 512,
    KEY_NUMERIC_1 = 513,
    KEY_NUMERIC_2 = 514,
    KEY_NUMERIC_3 = 515,
    KEY_NUMERIC_4 = 516,
    KEY_NUMERIC_5 = 517,
    KEY_NUMERIC_6 = 518,
    KEY_NUMERIC_7 = 519,
    KEY_NUMERIC_8 = 520,
    KEY_NUMERIC_9 = 521,
    KEY_NUMERIC_STAR = 522,
    KEY_NUMERIC_POUND = 523,
    KEY_NUMERIC_A = 524,
    KEY_NUMERIC_B = 525,
    KEY_NUMERIC_C = 526,
    KEY_NUMERIC_D = 527,
    KEY_CAMERA_FOCUS = 528,
    KEY_WPS_BUTTON = 529,
    KEY_TOUCHPAD_TOGGLE = 530,
    KEY_TOUCHPAD_ON = 531,
    KEY_TOUCHPAD_OFF = 532,
    KEY_CAMERA_ZOOMIN = 533,
    KEY_CAMERA_ZOOMOUT = 534,
    KEY_CAMERA_UP = 535,
    KEY_CAMERA_DOWN = 536,
    KEY_CAMERA_LEFT = 537,
    KEY_CAMERA_RIGHT = 538,
    KEY_ATTENDANT_ON = 539,
    KEY_ATTENDANT_OFF = 540,
    KEY_ATTENDANT_TOGGLE = 541,
    KEY_LIGHTS_TOGGLE = 542,
    KEY_ALS_TOGGLE = 560,
    KEY_ROTATE_LOCK_TOGGLE = 561,
    KEY_BUTTONCONFIG = 576,
    KEY_TASKMANAGER = 577,
    KEY_JOURNAL = 578,
    KEY_CONTROLPANEL = 579,
    KEY_APPSELECT = 580,
    KEY_SCREENSAVER = 581,
    KEY_VOICECOMMAND = 582,
    KEY_ASSISTANT = 583,
    KEY_KBD_LAYOUT_NEXT = 584,
    KEY_BRIGHTNESS_MIN = 592,
    KEY_BRIGHTNESS_MAX = 593,
    KEY_KBDINPUTASSIST_PREV = 608,
    KEY_KBDINPUTASSIST_NEXT = 609,
    KEY_KBDINPUTASSIST_PREVGROUP = 610,
    KEY_KBDINPUTASSIST_NEXTGROUP = 611,
    KEY_KBDINPUTASSIST_ACCEPT = 612,
    KEY_KBDINPUTASSIST_CANCEL = 613,
    KEY_RIGHT_UP = 614,
    KEY_RIGHT_DOWN = 615,
    KEY_LEFT_UP = 616,
    KEY_LEFT_DOWN = 617,
    KEY_ROOT_MENU = 618,
    KEY_MEDIA_TOP_MENU = 619,
    KEY_NUMERIC_11 = 620,
    KEY_NUMERIC_12 = 621,
    KEY_AUDIO_DESC = 622,
    KEY_3D_MODE = 623,
    KEY_NEXT_FAVORITE = 624,
    KEY_STOP_RECORD = 625,
    KEY_PAUSE_RECORD = 626,
    KEY_VOD = 627,
    KEY_UNMUTE = 628,
    KEY_FASTREVERSE = 629,
    KEY_SLOWREVERSE = 630,
    KEY_DATA = 631,
    KEY_ONSCREEN_KEYBOARD = 632,
    KEY_MAX = 767,
    BTN_0 = 256,
    BTN_1 = 257,
    BTN_2 = 258,
    BTN_3 = 259,
    BTN_4 = 260,
    BTN_5 = 261,
    BTN_6 = 262,
    BTN_7 = 263,
    BTN_8 = 264,
    BTN_9 = 265,
    BTN_LEFT = 272,
    BTN_RIGHT = 273,
    BTN_MIDDLE = 274,
    BTN_SIDE = 275,
    BTN_EXTRA = 276,
    BTN_FORWARD = 277,
    BTN_BACK = 278,
    BTN_TASK = 279,
    BTN_TRIGGER = 288,
    BTN_THUMB = 289,
    BTN_THUMB2 = 290,
    BTN_TOP = 291,
    BTN_TOP2 = 292,
    BTN_PINKIE = 293,
    BTN_BASE = 294,
    BTN_BASE2 = 295,
    BTN_BASE3 = 296,
    BTN_BASE4 = 297,
    BTN_BASE5 = 298,
    BTN_BASE6 = 299,
    BTN_DEAD = 303,
    BTN_SOUTH = 304,
    BTN_EAST = 305,
    BTN_C = 306,
    BTN_NORTH = 307,
    BTN_WEST = 308,
    BTN_Z = 309,
    BTN_TL = 310,
    BTN_TR = 311,
    BTN_TL2 = 312,
    BTN_TR2 = 313,
    BTN_SELECT = 314,
    BTN_START = 315,
    BTN_MODE = 316,
    BTN_THUMBL = 317,
    BTN_THUMBR = 318,
    BTN_TOOL_PEN = 320,
    BTN_TOOL_RUBBER = 321,
    BTN_TOOL_BRUSH = 322,
    BTN_TOOL_PENCIL = 323,
    BTN_TOOL_AIRBRUSH = 324,
    BTN_TOOL_FINGER = 325,
    BTN_TOOL_MOUSE = 326,
    BTN_TOOL_LENS = 327,
    BTN_TOOL_QUINTTAP = 328,
    BTN_STYLUS3 = 329,
    BTN_TOUCH = 330,
    BTN_STYLUS = 331,
    BTN_STYLUS2 = 332,
    BTN_TOOL_DOUBLETAP = 333,
    BTN_TOOL_TRIPLETAP = 334,
    BTN_TOOL_QUADTAP = 335,
    BTN_GEAR_DOWN = 336,
    BTN_GEAR_UP = 337,
    BTN_DPAD_UP = 544,
    BTN_DPAD_DOWN = 545,
    BTN_DPAD_LEFT = 546,
    BTN_DPAD_RIGHT = 547,
    BTN_TRIGGER_HAPPY1 = 704,
    BTN_TRIGGER_HAPPY2 = 705,
    BTN_TRIGGER_HAPPY3 = 706,
    BTN_TRIGGER_HAPPY4 = 707,
    BTN_TRIGGER_HAPPY5 = 708,
    BTN_TRIGGER_HAPPY6 = 709,
    BTN_TRIGGER_HAPPY7 = 710,
    BTN_TRIGGER_HAPPY8 = 711,
    BTN_TRIGGER_HAPPY9 = 712,
    BTN_TRIGGER_HAPPY10 = 713,
    BTN_TRIGGER_HAPPY11 = 714,
    BTN_TRIGGER_HAPPY12 = 715,
    BTN_TRIGGER_HAPPY13 = 716,
    BTN_TRIGGER_HAPPY14 = 717,
    BTN_TRIGGER_HAPPY15 = 718,
    BTN_TRIGGER_HAPPY16 = 719,
    BTN_TRIGGER_HAPPY17 = 720,
    BTN_TRIGGER_HAPPY18 = 721,
    BTN_TRIGGER_HAPPY19 = 722,
    BTN_TRIGGER_HAPPY20 = 723,
    BTN_TRIGGER_HAPPY21 = 724,
    BTN_TRIGGER_HAPPY22 = 725,
    BTN_TRIGGER_HAPPY23 = 726,
    BTN_TRIGGER_HAPPY24 = 727,
    BTN_TRIGGER_HAPPY25 = 728,
    BTN_TRIGGER_HAPPY26 = 729,
    BTN_TRIGGER_HAPPY27 = 730,
    BTN_TRIGGER_HAPPY28 = 731,
    BTN_TRIGGER_HAPPY29 = 732,
    BTN_TRIGGER_HAPPY30 = 733,
    BTN_TRIGGER_HAPPY31 = 734,
    BTN_TRIGGER_HAPPY32 = 735,
    BTN_TRIGGER_HAPPY33 = 736,
    BTN_TRIGGER_HAPPY34 = 737,
    BTN_TRIGGER_HAPPY35 = 738,
    BTN_TRIGGER_HAPPY36 = 739,
    BTN_TRIGGER_HAPPY37 = 740,
    BTN_TRIGGER_HAPPY38 = 741,
    BTN_TRIGGER_HAPPY39 = 742,
    BTN_TRIGGER_HAPPY40 = 743,
    BTN_MAX = 744,
}

impl OsCode {
    pub fn from_u32(code: u32) -> Option<Self> {
        match code {
            0 => Some(OsCode::KEY_RESERVED),
            1 => Some(OsCode::KEY_ESC),
            2 => Some(OsCode::KEY_1),
            3 => Some(OsCode::KEY_2),
            4 => Some(OsCode::KEY_3),
            5 => Some(OsCode::KEY_4),
            6 => Some(OsCode::KEY_5),
            7 => Some(OsCode::KEY_6),
            8 => Some(OsCode::KEY_7),
            9 => Some(OsCode::KEY_8),
            10 => Some(OsCode::KEY_9),
            11 => Some(OsCode::KEY_0),
            12 => Some(OsCode::KEY_MINUS),
            13 => Some(OsCode::KEY_EQUAL),
            14 => Some(OsCode::KEY_BACKSPACE),
            15 => Some(OsCode::KEY_TAB),
            16 => Some(OsCode::KEY_Q),
            17 => Some(OsCode::KEY_W),
            18 => Some(OsCode::KEY_E),
            19 => Some(OsCode::KEY_R),
            20 => Some(OsCode::KEY_T),
            21 => Some(OsCode::KEY_Y),
            22 => Some(OsCode::KEY_U),
            23 => Some(OsCode::KEY_I),
            24 => Some(OsCode::KEY_O),
            25 => Some(OsCode::KEY_P),
            26 => Some(OsCode::KEY_LEFTBRACE),
            27 => Some(OsCode::KEY_RIGHTBRACE),
            28 => Some(OsCode::KEY_ENTER),
            29 => Some(OsCode::KEY_LEFTCTRL),
            30 => Some(OsCode::KEY_A),
            31 => Some(OsCode::KEY_S),
            32 => Some(OsCode::KEY_D),
            33 => Some(OsCode::KEY_F),
            34 => Some(OsCode::KEY_G),
            35 => Some(OsCode::KEY_H),
            36 => Some(OsCode::KEY_J),
            37 => Some(OsCode::KEY_K),
            38 => Some(OsCode::KEY_L),
            39 => Some(OsCode::KEY_SEMICOLON),
            40 => Some(OsCode::KEY_APOSTROPHE),
            41 => Some(OsCode::KEY_GRAVE),
            42 => Some(OsCode::KEY_LEFTSHIFT),
            43 => Some(OsCode::KEY_BACKSLASH),
            44 => Some(OsCode::KEY_Z),
            45 => Some(OsCode::KEY_X),
            46 => Some(OsCode::KEY_C),
            47 => Some(OsCode::KEY_V),
            48 => Some(OsCode::KEY_B),
            49 => Some(OsCode::KEY_N),
            50 => Some(OsCode::KEY_M),
            51 => Some(OsCode::KEY_COMMA),
            52 => Some(OsCode::KEY_DOT),
            53 => Some(OsCode::KEY_SLASH),
            54 => Some(OsCode::KEY_RIGHTSHIFT),
            55 => Some(OsCode::KEY_KPASTERISK),
            56 => Some(OsCode::KEY_LEFTALT),
            57 => Some(OsCode::KEY_SPACE),
            58 => Some(OsCode::KEY_CAPSLOCK),
            59 => Some(OsCode::KEY_F1),
            60 => Some(OsCode::KEY_F2),
            61 => Some(OsCode::KEY_F3),
            62 => Some(OsCode::KEY_F4),
            63 => Some(OsCode::KEY_F5),
            64 => Some(OsCode::KEY_F6),
            65 => Some(OsCode::KEY_F7),
            66 => Some(OsCode::KEY_F8),
            67 => Some(OsCode::KEY_F9),
            68 => Some(OsCode::KEY_F10),
            69 => Some(OsCode::KEY_NUMLOCK),
            70 => Some(OsCode::KEY_SCROLLLOCK),
            71 => Some(OsCode::KEY_KP7),
            72 => Some(OsCode::KEY_KP8),
            73 => Some(OsCode::KEY_KP9),
            74 => Some(OsCode::KEY_KPMINUS),
            75 => Some(OsCode::KEY_KP4),
            76 => Some(OsCode::KEY_KP5),
            77 => Some(OsCode::KEY_KP6),
            78 => Some(OsCode::KEY_KPPLUS),
            79 => Some(OsCode::KEY_KP1),
            80 => Some(OsCode::KEY_KP2),
            81 => Some(OsCode::KEY_KP3),
            82 => Some(OsCode::KEY_KP0),
            83 => Some(OsCode::KEY_KPDOT),
            85 => Some(OsCode::KEY_ZENKAKUHANKAKU),
            86 => Some(OsCode::KEY_102ND),
            87 => Some(OsCode::KEY_F11),
            88 => Some(OsCode::KEY_F12),
            89 => Some(OsCode::KEY_RO),
            90 => Some(OsCode::KEY_KATAKANA),
            91 => Some(OsCode::KEY_HIRAGANA),
            92 => Some(OsCode::KEY_HENKAN),
            93 => Some(OsCode::KEY_KATAKANAHIRAGANA),
            94 => Some(OsCode::KEY_MUHENKAN),
            95 => Some(OsCode::KEY_KPJPCOMMA),
            96 => Some(OsCode::KEY_KPENTER),
            97 => Some(OsCode::KEY_RIGHTCTRL),
            98 => Some(OsCode::KEY_KPSLASH),
            99 => Some(OsCode::KEY_SYSRQ),
            100 => Some(OsCode::KEY_RIGHTALT),
            101 => Some(OsCode::KEY_LINEFEED),
            102 => Some(OsCode::KEY_HOME),
            103 => Some(OsCode::KEY_UP),
            104 => Some(OsCode::KEY_PAGEUP),
            105 => Some(OsCode::KEY_LEFT),
            106 => Some(OsCode::KEY_RIGHT),
            107 => Some(OsCode::KEY_END),
            108 => Some(OsCode::KEY_DOWN),
            109 => Some(OsCode::KEY_PAGEDOWN),
            110 => Some(OsCode::KEY_INSERT),
            111 => Some(OsCode::KEY_DELETE),
            112 => Some(OsCode::KEY_MACRO),
            113 => Some(OsCode::KEY_MUTE),
            114 => Some(OsCode::KEY_VOLUMEDOWN),
            115 => Some(OsCode::KEY_VOLUMEUP),
            116 => Some(OsCode::KEY_POWER),
            117 => Some(OsCode::KEY_KPEQUAL),
            118 => Some(OsCode::KEY_KPPLUSMINUS),
            119 => Some(OsCode::KEY_PAUSE),
            120 => Some(OsCode::KEY_SCALE),
            121 => Some(OsCode::KEY_KPCOMMA),
            122 => Some(OsCode::KEY_HANGEUL),
            123 => Some(OsCode::KEY_HANJA),
            124 => Some(OsCode::KEY_YEN),
            125 => Some(OsCode::KEY_LEFTMETA),
            126 => Some(OsCode::KEY_RIGHTMETA),
            127 => Some(OsCode::KEY_COMPOSE),
            128 => Some(OsCode::KEY_STOP),
            129 => Some(OsCode::KEY_AGAIN),
            130 => Some(OsCode::KEY_PROPS),
            131 => Some(OsCode::KEY_UNDO),
            132 => Some(OsCode::KEY_FRONT),
            133 => Some(OsCode::KEY_COPY),
            134 => Some(OsCode::KEY_OPEN),
            135 => Some(OsCode::KEY_PASTE),
            136 => Some(OsCode::KEY_FIND),
            137 => Some(OsCode::KEY_CUT),
            138 => Some(OsCode::KEY_HELP),
            139 => Some(OsCode::KEY_MENU),
            140 => Some(OsCode::KEY_CALC),
            141 => Some(OsCode::KEY_SETUP),
            142 => Some(OsCode::KEY_SLEEP),
            143 => Some(OsCode::KEY_WAKEUP),
            144 => Some(OsCode::KEY_FILE),
            145 => Some(OsCode::KEY_SENDFILE),
            146 => Some(OsCode::KEY_DELETEFILE),
            147 => Some(OsCode::KEY_XFER),
            148 => Some(OsCode::KEY_PROG1),
            149 => Some(OsCode::KEY_PROG2),
            150 => Some(OsCode::KEY_WWW),
            151 => Some(OsCode::KEY_MSDOS),
            152 => Some(OsCode::KEY_COFFEE),
            153 => Some(OsCode::KEY_ROTATE_DISPLAY),
            154 => Some(OsCode::KEY_CYCLEWINDOWS),
            155 => Some(OsCode::KEY_MAIL),
            156 => Some(OsCode::KEY_BOOKMARKS),
            157 => Some(OsCode::KEY_COMPUTER),
            158 => Some(OsCode::KEY_BACK),
            159 => Some(OsCode::KEY_FORWARD),
            160 => Some(OsCode::KEY_CLOSECD),
            161 => Some(OsCode::KEY_EJECTCD),
            162 => Some(OsCode::KEY_EJECTCLOSECD),
            163 => Some(OsCode::KEY_NEXTSONG),
            164 => Some(OsCode::KEY_PLAYPAUSE),
            165 => Some(OsCode::KEY_PREVIOUSSONG),
            166 => Some(OsCode::KEY_STOPCD),
            167 => Some(OsCode::KEY_RECORD),
            168 => Some(OsCode::KEY_REWIND),
            169 => Some(OsCode::KEY_PHONE),
            170 => Some(OsCode::KEY_ISO),
            171 => Some(OsCode::KEY_CONFIG),
            172 => Some(OsCode::KEY_HOMEPAGE),
            173 => Some(OsCode::KEY_REFRESH),
            174 => Some(OsCode::KEY_EXIT),
            175 => Some(OsCode::KEY_MOVE),
            176 => Some(OsCode::KEY_EDIT),
            177 => Some(OsCode::KEY_SCROLLUP),
            178 => Some(OsCode::KEY_SCROLLDOWN),
            179 => Some(OsCode::KEY_KPLEFTPAREN),
            180 => Some(OsCode::KEY_KPRIGHTPAREN),
            181 => Some(OsCode::KEY_NEW),
            182 => Some(OsCode::KEY_REDO),
            183 => Some(OsCode::KEY_F13),
            184 => Some(OsCode::KEY_F14),
            185 => Some(OsCode::KEY_F15),
            186 => Some(OsCode::KEY_F16),
            187 => Some(OsCode::KEY_F17),
            188 => Some(OsCode::KEY_F18),
            189 => Some(OsCode::KEY_F19),
            190 => Some(OsCode::KEY_F20),
            191 => Some(OsCode::KEY_F21),
            192 => Some(OsCode::KEY_F22),
            193 => Some(OsCode::KEY_F23),
            194 => Some(OsCode::KEY_F24),
            200 => Some(OsCode::KEY_PLAYCD),
            201 => Some(OsCode::KEY_PAUSECD),
            202 => Some(OsCode::KEY_PROG3),
            203 => Some(OsCode::KEY_PROG4),
            204 => Some(OsCode::KEY_DASHBOARD),
            205 => Some(OsCode::KEY_SUSPEND),
            206 => Some(OsCode::KEY_CLOSE),
            207 => Some(OsCode::KEY_PLAY),
            208 => Some(OsCode::KEY_FASTFORWARD),
            209 => Some(OsCode::KEY_BASSBOOST),
            210 => Some(OsCode::KEY_PRINT),
            211 => Some(OsCode::KEY_HP),
            212 => Some(OsCode::KEY_CAMERA),
            213 => Some(OsCode::KEY_SOUND),
            214 => Some(OsCode::KEY_QUESTION),
            215 => Some(OsCode::KEY_EMAIL),
            216 => Some(OsCode::KEY_CHAT),
            217 => Some(OsCode::KEY_SEARCH),
            218 => Some(OsCode::KEY_CONNECT),
            219 => Some(OsCode::KEY_FINANCE),
            220 => Some(OsCode::KEY_SPORT),
            221 => Some(OsCode::KEY_SHOP),
            222 => Some(OsCode::KEY_ALTERASE),
            223 => Some(OsCode::KEY_CANCEL),
            224 => Some(OsCode::KEY_BRIGHTNESSDOWN),
            225 => Some(OsCode::KEY_BRIGHTNESSUP),
            226 => Some(OsCode::KEY_MEDIA),
            227 => Some(OsCode::KEY_SWITCHVIDEOMODE),
            228 => Some(OsCode::KEY_KBDILLUMTOGGLE),
            229 => Some(OsCode::KEY_KBDILLUMDOWN),
            230 => Some(OsCode::KEY_KBDILLUMUP),
            231 => Some(OsCode::KEY_SEND),
            232 => Some(OsCode::KEY_REPLY),
            233 => Some(OsCode::KEY_FORWARDMAIL),
            234 => Some(OsCode::KEY_SAVE),
            235 => Some(OsCode::KEY_DOCUMENTS),
            236 => Some(OsCode::KEY_BATTERY),
            237 => Some(OsCode::KEY_BLUETOOTH),
            238 => Some(OsCode::KEY_WLAN),
            239 => Some(OsCode::KEY_UWB),
            240 => Some(OsCode::KEY_UNKNOWN),
            241 => Some(OsCode::KEY_VIDEO_NEXT),
            242 => Some(OsCode::KEY_VIDEO_PREV),
            243 => Some(OsCode::KEY_BRIGHTNESS_CYCLE),
            244 => Some(OsCode::KEY_BRIGHTNESS_AUTO),
            245 => Some(OsCode::KEY_DISPLAY_OFF),
            246 => Some(OsCode::KEY_WWAN),
            247 => Some(OsCode::KEY_RFKILL),
            248 => Some(OsCode::KEY_MICMUTE),
            352 => Some(OsCode::KEY_OK),
            353 => Some(OsCode::KEY_SELECT),
            354 => Some(OsCode::KEY_GOTO),
            355 => Some(OsCode::KEY_CLEAR),
            356 => Some(OsCode::KEY_POWER2),
            357 => Some(OsCode::KEY_OPTION),
            358 => Some(OsCode::KEY_INFO),
            359 => Some(OsCode::KEY_TIME),
            360 => Some(OsCode::KEY_VENDOR),
            361 => Some(OsCode::KEY_ARCHIVE),
            362 => Some(OsCode::KEY_PROGRAM),
            363 => Some(OsCode::KEY_CHANNEL),
            364 => Some(OsCode::KEY_FAVORITES),
            365 => Some(OsCode::KEY_EPG),
            366 => Some(OsCode::KEY_PVR),
            367 => Some(OsCode::KEY_MHP),
            368 => Some(OsCode::KEY_LANGUAGE),
            369 => Some(OsCode::KEY_TITLE),
            370 => Some(OsCode::KEY_SUBTITLE),
            371 => Some(OsCode::KEY_ANGLE),
            372 => Some(OsCode::KEY_FULL_SCREEN),
            373 => Some(OsCode::KEY_MODE),
            374 => Some(OsCode::KEY_KEYBOARD),
            375 => Some(OsCode::KEY_ASPECT_RATIO),
            376 => Some(OsCode::KEY_PC),
            377 => Some(OsCode::KEY_TV),
            378 => Some(OsCode::KEY_TV2),
            379 => Some(OsCode::KEY_VCR),
            380 => Some(OsCode::KEY_VCR2),
            381 => Some(OsCode::KEY_SAT),
            382 => Some(OsCode::KEY_SAT2),
            383 => Some(OsCode::KEY_CD),
            384 => Some(OsCode::KEY_TAPE),
            385 => Some(OsCode::KEY_RADIO),
            386 => Some(OsCode::KEY_TUNER),
            387 => Some(OsCode::KEY_PLAYER),
            388 => Some(OsCode::KEY_TEXT),
            389 => Some(OsCode::KEY_DVD),
            390 => Some(OsCode::KEY_AUX),
            391 => Some(OsCode::KEY_MP3),
            392 => Some(OsCode::KEY_AUDIO),
            393 => Some(OsCode::KEY_VIDEO),
            394 => Some(OsCode::KEY_DIRECTORY),
            395 => Some(OsCode::KEY_LIST),
            396 => Some(OsCode::KEY_MEMO),
            397 => Some(OsCode::KEY_CALENDAR),
            398 => Some(OsCode::KEY_RED),
            399 => Some(OsCode::KEY_GREEN),
            400 => Some(OsCode::KEY_YELLOW),
            401 => Some(OsCode::KEY_BLUE),
            402 => Some(OsCode::KEY_CHANNELUP),
            403 => Some(OsCode::KEY_CHANNELDOWN),
            404 => Some(OsCode::KEY_FIRST),
            405 => Some(OsCode::KEY_LAST),
            406 => Some(OsCode::KEY_AB),
            407 => Some(OsCode::KEY_NEXT),
            408 => Some(OsCode::KEY_RESTART),
            409 => Some(OsCode::KEY_SLOW),
            410 => Some(OsCode::KEY_SHUFFLE),
            411 => Some(OsCode::KEY_BREAK),
            412 => Some(OsCode::KEY_PREVIOUS),
            413 => Some(OsCode::KEY_DIGITS),
            414 => Some(OsCode::KEY_TEEN),
            415 => Some(OsCode::KEY_TWEN),
            416 => Some(OsCode::KEY_VIDEOPHONE),
            417 => Some(OsCode::KEY_GAMES),
            418 => Some(OsCode::KEY_ZOOMIN),
            419 => Some(OsCode::KEY_ZOOMOUT),
            420 => Some(OsCode::KEY_ZOOMRESET),
            421 => Some(OsCode::KEY_WORDPROCESSOR),
            422 => Some(OsCode::KEY_EDITOR),
            423 => Some(OsCode::KEY_SPREADSHEET),
            424 => Some(OsCode::KEY_GRAPHICSEDITOR),
            425 => Some(OsCode::KEY_PRESENTATION),
            426 => Some(OsCode::KEY_DATABASE),
            427 => Some(OsCode::KEY_NEWS),
            428 => Some(OsCode::KEY_VOICEMAIL),
            429 => Some(OsCode::KEY_ADDRESSBOOK),
            430 => Some(OsCode::KEY_MESSENGER),
            431 => Some(OsCode::KEY_DISPLAYTOGGLE),
            432 => Some(OsCode::KEY_SPELLCHECK),
            433 => Some(OsCode::KEY_LOGOFF),
            434 => Some(OsCode::KEY_DOLLAR),
            435 => Some(OsCode::KEY_EURO),
            436 => Some(OsCode::KEY_FRAMEBACK),
            437 => Some(OsCode::KEY_FRAMEFORWARD),
            438 => Some(OsCode::KEY_CONTEXT_MENU),
            439 => Some(OsCode::KEY_MEDIA_REPEAT),
            440 => Some(OsCode::KEY_10CHANNELSUP),
            441 => Some(OsCode::KEY_10CHANNELSDOWN),
            442 => Some(OsCode::KEY_IMAGES),
            448 => Some(OsCode::KEY_DEL_EOL),
            449 => Some(OsCode::KEY_DEL_EOS),
            450 => Some(OsCode::KEY_INS_LINE),
            451 => Some(OsCode::KEY_DEL_LINE),
            464 => Some(OsCode::KEY_FN),
            465 => Some(OsCode::KEY_FN_ESC),
            466 => Some(OsCode::KEY_FN_F1),
            467 => Some(OsCode::KEY_FN_F2),
            468 => Some(OsCode::KEY_FN_F3),
            469 => Some(OsCode::KEY_FN_F4),
            470 => Some(OsCode::KEY_FN_F5),
            471 => Some(OsCode::KEY_FN_F6),
            472 => Some(OsCode::KEY_FN_F7),
            473 => Some(OsCode::KEY_FN_F8),
            474 => Some(OsCode::KEY_FN_F9),
            475 => Some(OsCode::KEY_FN_F10),
            476 => Some(OsCode::KEY_FN_F11),
            477 => Some(OsCode::KEY_FN_F12),
            478 => Some(OsCode::KEY_FN_1),
            479 => Some(OsCode::KEY_FN_2),
            480 => Some(OsCode::KEY_FN_D),
            481 => Some(OsCode::KEY_FN_E),
            482 => Some(OsCode::KEY_FN_F),
            483 => Some(OsCode::KEY_FN_S),
            484 => Some(OsCode::KEY_FN_B),
            497 => Some(OsCode::KEY_BRL_DOT1),
            498 => Some(OsCode::KEY_BRL_DOT2),
            499 => Some(OsCode::KEY_BRL_DOT3),
            500 => Some(OsCode::KEY_BRL_DOT4),
            501 => Some(OsCode::KEY_BRL_DOT5),
            502 => Some(OsCode::KEY_BRL_DOT6),
            503 => Some(OsCode::KEY_BRL_DOT7),
            504 => Some(OsCode::KEY_BRL_DOT8),
            505 => Some(OsCode::KEY_BRL_DOT9),
            506 => Some(OsCode::KEY_BRL_DOT10),
            512 => Some(OsCode::KEY_NUMERIC_0),
            513 => Some(OsCode::KEY_NUMERIC_1),
            514 => Some(OsCode::KEY_NUMERIC_2),
            515 => Some(OsCode::KEY_NUMERIC_3),
            516 => Some(OsCode::KEY_NUMERIC_4),
            517 => Some(OsCode::KEY_NUMERIC_5),
            518 => Some(OsCode::KEY_NUMERIC_6),
            519 => Some(OsCode::KEY_NUMERIC_7),
            520 => Some(OsCode::KEY_NUMERIC_8),
            521 => Some(OsCode::KEY_NUMERIC_9),
            522 => Some(OsCode::KEY_NUMERIC_STAR),
            523 => Some(OsCode::KEY_NUMERIC_POUND),
            524 => Some(OsCode::KEY_NUMERIC_A),
            525 => Some(OsCode::KEY_NUMERIC_B),
            526 => Some(OsCode::KEY_NUMERIC_C),
            527 => Some(OsCode::KEY_NUMERIC_D),
            528 => Some(OsCode::KEY_CAMERA_FOCUS),
            529 => Some(OsCode::KEY_WPS_BUTTON),
            530 => Some(OsCode::KEY_TOUCHPAD_TOGGLE),
            531 => Some(OsCode::KEY_TOUCHPAD_ON),
            532 => Some(OsCode::KEY_TOUCHPAD_OFF),
            533 => Some(OsCode::KEY_CAMERA_ZOOMIN),
            534 => Some(OsCode::KEY_CAMERA_ZOOMOUT),
            535 => Some(OsCode::KEY_CAMERA_UP),
            536 => Some(OsCode::KEY_CAMERA_DOWN),
            537 => Some(OsCode::KEY_CAMERA_LEFT),
            538 => Some(OsCode::KEY_CAMERA_RIGHT),
            539 => Some(OsCode::KEY_ATTENDANT_ON),
            540 => Some(OsCode::KEY_ATTENDANT_OFF),
            541 => Some(OsCode::KEY_ATTENDANT_TOGGLE),
            542 => Some(OsCode::KEY_LIGHTS_TOGGLE),
            560 => Some(OsCode::KEY_ALS_TOGGLE),
            561 => Some(OsCode::KEY_ROTATE_LOCK_TOGGLE),
            576 => Some(OsCode::KEY_BUTTONCONFIG),
            577 => Some(OsCode::KEY_TASKMANAGER),
            578 => Some(OsCode::KEY_JOURNAL),
            579 => Some(OsCode::KEY_CONTROLPANEL),
            580 => Some(OsCode::KEY_APPSELECT),
            581 => Some(OsCode::KEY_SCREENSAVER),
            582 => Some(OsCode::KEY_VOICECOMMAND),
            583 => Some(OsCode::KEY_ASSISTANT),
            584 => Some(OsCode::KEY_KBD_LAYOUT_NEXT),
            592 => Some(OsCode::KEY_BRIGHTNESS_MIN),
            593 => Some(OsCode::KEY_BRIGHTNESS_MAX),
            608 => Some(OsCode::KEY_KBDINPUTASSIST_PREV),
            609 => Some(OsCode::KEY_KBDINPUTASSIST_NEXT),
            610 => Some(OsCode::KEY_KBDINPUTASSIST_PREVGROUP),
            611 => Some(OsCode::KEY_KBDINPUTASSIST_NEXTGROUP),
            612 => Some(OsCode::KEY_KBDINPUTASSIST_ACCEPT),
            613 => Some(OsCode::KEY_KBDINPUTASSIST_CANCEL),
            614 => Some(OsCode::KEY_RIGHT_UP),
            615 => Some(OsCode::KEY_RIGHT_DOWN),
            616 => Some(OsCode::KEY_LEFT_UP),
            617 => Some(OsCode::KEY_LEFT_DOWN),
            618 => Some(OsCode::KEY_ROOT_MENU),
            619 => Some(OsCode::KEY_MEDIA_TOP_MENU),
            620 => Some(OsCode::KEY_NUMERIC_11),
            621 => Some(OsCode::KEY_NUMERIC_12),
            622 => Some(OsCode::KEY_AUDIO_DESC),
            623 => Some(OsCode::KEY_3D_MODE),
            624 => Some(OsCode::KEY_NEXT_FAVORITE),
            625 => Some(OsCode::KEY_STOP_RECORD),
            626 => Some(OsCode::KEY_PAUSE_RECORD),
            627 => Some(OsCode::KEY_VOD),
            628 => Some(OsCode::KEY_UNMUTE),
            629 => Some(OsCode::KEY_FASTREVERSE),
            630 => Some(OsCode::KEY_SLOWREVERSE),
            631 => Some(OsCode::KEY_DATA),
            632 => Some(OsCode::KEY_ONSCREEN_KEYBOARD),
            767 => Some(OsCode::KEY_MAX),
            256 => Some(OsCode::BTN_0),
            257 => Some(OsCode::BTN_1),
            258 => Some(OsCode::BTN_2),
            259 => Some(OsCode::BTN_3),
            260 => Some(OsCode::BTN_4),
            261 => Some(OsCode::BTN_5),
            262 => Some(OsCode::BTN_6),
            263 => Some(OsCode::BTN_7),
            264 => Some(OsCode::BTN_8),
            265 => Some(OsCode::BTN_9),
            272 => Some(OsCode::BTN_LEFT),
            273 => Some(OsCode::BTN_RIGHT),
            274 => Some(OsCode::BTN_MIDDLE),
            275 => Some(OsCode::BTN_SIDE),
            276 => Some(OsCode::BTN_EXTRA),
            277 => Some(OsCode::BTN_FORWARD),
            278 => Some(OsCode::BTN_BACK),
            279 => Some(OsCode::BTN_TASK),
            288 => Some(OsCode::BTN_TRIGGER),
            289 => Some(OsCode::BTN_THUMB),
            290 => Some(OsCode::BTN_THUMB2),
            291 => Some(OsCode::BTN_TOP),
            292 => Some(OsCode::BTN_TOP2),
            293 => Some(OsCode::BTN_PINKIE),
            294 => Some(OsCode::BTN_BASE),
            295 => Some(OsCode::BTN_BASE2),
            296 => Some(OsCode::BTN_BASE3),
            297 => Some(OsCode::BTN_BASE4),
            298 => Some(OsCode::BTN_BASE5),
            299 => Some(OsCode::BTN_BASE6),
            303 => Some(OsCode::BTN_DEAD),
            304 => Some(OsCode::BTN_SOUTH),
            305 => Some(OsCode::BTN_EAST),
            306 => Some(OsCode::BTN_C),
            307 => Some(OsCode::BTN_NORTH),
            308 => Some(OsCode::BTN_WEST),
            309 => Some(OsCode::BTN_Z),
            310 => Some(OsCode::BTN_TL),
            311 => Some(OsCode::BTN_TR),
            312 => Some(OsCode::BTN_TL2),
            313 => Some(OsCode::BTN_TR2),
            314 => Some(OsCode::BTN_SELECT),
            315 => Some(OsCode::BTN_START),
            316 => Some(OsCode::BTN_MODE),
            317 => Some(OsCode::BTN_THUMBL),
            318 => Some(OsCode::BTN_THUMBR),
            320 => Some(OsCode::BTN_TOOL_PEN),
            321 => Some(OsCode::BTN_TOOL_RUBBER),
            322 => Some(OsCode::BTN_TOOL_BRUSH),
            323 => Some(OsCode::BTN_TOOL_PENCIL),
            324 => Some(OsCode::BTN_TOOL_AIRBRUSH),
            325 => Some(OsCode::BTN_TOOL_FINGER),
            326 => Some(OsCode::BTN_TOOL_MOUSE),
            327 => Some(OsCode::BTN_TOOL_LENS),
            328 => Some(OsCode::BTN_TOOL_QUINTTAP),
            329 => Some(OsCode::BTN_STYLUS3),
            330 => Some(OsCode::BTN_TOUCH),
            331 => Some(OsCode::BTN_STYLUS),
            332 => Some(OsCode::BTN_STYLUS2),
            333 => Some(OsCode::BTN_TOOL_DOUBLETAP),
            334 => Some(OsCode::BTN_TOOL_TRIPLETAP),
            335 => Some(OsCode::BTN_TOOL_QUADTAP),
            336 => Some(OsCode::BTN_GEAR_DOWN),
            337 => Some(OsCode::BTN_GEAR_UP),
            544 => Some(OsCode::BTN_DPAD_UP),
            545 => Some(OsCode::BTN_DPAD_DOWN),
            546 => Some(OsCode::BTN_DPAD_LEFT),
            547 => Some(OsCode::BTN_DPAD_RIGHT),
            704 => Some(OsCode::BTN_TRIGGER_HAPPY1),
            705 => Some(OsCode::BTN_TRIGGER_HAPPY2),
            706 => Some(OsCode::BTN_TRIGGER_HAPPY3),
            707 => Some(OsCode::BTN_TRIGGER_HAPPY4),
            708 => Some(OsCode::BTN_TRIGGER_HAPPY5),
            709 => Some(OsCode::BTN_TRIGGER_HAPPY6),
            710 => Some(OsCode::BTN_TRIGGER_HAPPY7),
            711 => Some(OsCode::BTN_TRIGGER_HAPPY8),
            712 => Some(OsCode::BTN_TRIGGER_HAPPY9),
            713 => Some(OsCode::BTN_TRIGGER_HAPPY10),
            714 => Some(OsCode::BTN_TRIGGER_HAPPY11),
            715 => Some(OsCode::BTN_TRIGGER_HAPPY12),
            716 => Some(OsCode::BTN_TRIGGER_HAPPY13),
            717 => Some(OsCode::BTN_TRIGGER_HAPPY14),
            718 => Some(OsCode::BTN_TRIGGER_HAPPY15),
            719 => Some(OsCode::BTN_TRIGGER_HAPPY16),
            720 => Some(OsCode::BTN_TRIGGER_HAPPY17),
            721 => Some(OsCode::BTN_TRIGGER_HAPPY18),
            722 => Some(OsCode::BTN_TRIGGER_HAPPY19),
            723 => Some(OsCode::BTN_TRIGGER_HAPPY20),
            724 => Some(OsCode::BTN_TRIGGER_HAPPY21),
            725 => Some(OsCode::BTN_TRIGGER_HAPPY22),
            726 => Some(OsCode::BTN_TRIGGER_HAPPY23),
            727 => Some(OsCode::BTN_TRIGGER_HAPPY24),
            728 => Some(OsCode::BTN_TRIGGER_HAPPY25),
            729 => Some(OsCode::BTN_TRIGGER_HAPPY26),
            730 => Some(OsCode::BTN_TRIGGER_HAPPY27),
            731 => Some(OsCode::BTN_TRIGGER_HAPPY28),
            732 => Some(OsCode::BTN_TRIGGER_HAPPY29),
            733 => Some(OsCode::BTN_TRIGGER_HAPPY30),
            734 => Some(OsCode::BTN_TRIGGER_HAPPY31),
            735 => Some(OsCode::BTN_TRIGGER_HAPPY32),
            736 => Some(OsCode::BTN_TRIGGER_HAPPY33),
            737 => Some(OsCode::BTN_TRIGGER_HAPPY34),
            738 => Some(OsCode::BTN_TRIGGER_HAPPY35),
            739 => Some(OsCode::BTN_TRIGGER_HAPPY36),
            740 => Some(OsCode::BTN_TRIGGER_HAPPY37),
            741 => Some(OsCode::BTN_TRIGGER_HAPPY38),
            742 => Some(OsCode::BTN_TRIGGER_HAPPY39),
            743 => Some(OsCode::BTN_TRIGGER_HAPPY40),
            744 => Some(OsCode::BTN_MAX),
            _ => None,
        }
    }
}

impl TryFrom<usize> for OsCode {
    type Error = ();
    fn try_from(item: usize) -> Result<Self, Self::Error> {
        match Self::from_u32(item as u32) {
            Some(kc) => Ok(kc),
            _ => Err(()),
        }
    }
}

impl From<u32> for OsCode {
    fn from(item: u32) -> Self {
        Self::from_u32(item).unwrap_or_else(|| panic!("Invalid KeyCode: {}", item))
    }
}

impl From<OsCode> for usize {
    fn from(item: OsCode) -> Self {
        item as usize
    }
}

impl From<OsCode> for u32 {
    fn from(item: OsCode) -> Self {
        item as u32
    }
}

impl From<KeyCode> for OsCode {
    fn from(item: KeyCode) -> Self {
        match item {
            KeyCode::Escape => OsCode::KEY_ESC,
            KeyCode::Kb1 => OsCode::KEY_1,
            KeyCode::Kb2 => OsCode::KEY_2,
            KeyCode::Kb3 => OsCode::KEY_3,
            KeyCode::Kb4 => OsCode::KEY_4,
            KeyCode::Kb5 => OsCode::KEY_5,
            KeyCode::Kb6 => OsCode::KEY_6,
            KeyCode::Kb7 => OsCode::KEY_7,
            KeyCode::Kb8 => OsCode::KEY_8,
            KeyCode::Kb9 => OsCode::KEY_9,
            KeyCode::Kb0 => OsCode::KEY_0,
            KeyCode::Minus => OsCode::KEY_MINUS,
            KeyCode::Equal => OsCode::KEY_EQUAL,
            KeyCode::BSpace => OsCode::KEY_BACKSPACE,
            KeyCode::Tab => OsCode::KEY_TAB,
            KeyCode::Q => OsCode::KEY_Q,
            KeyCode::W => OsCode::KEY_W,
            KeyCode::E => OsCode::KEY_E,
            KeyCode::R => OsCode::KEY_R,
            KeyCode::T => OsCode::KEY_T,
            KeyCode::Y => OsCode::KEY_Y,
            KeyCode::U => OsCode::KEY_U,
            KeyCode::I => OsCode::KEY_I,
            KeyCode::O => OsCode::KEY_O,
            KeyCode::P => OsCode::KEY_P,
            KeyCode::LBracket => OsCode::KEY_LEFTBRACE,
            KeyCode::RBracket => OsCode::KEY_RIGHTBRACE,
            KeyCode::Enter => OsCode::KEY_ENTER,
            KeyCode::LCtrl => OsCode::KEY_LEFTCTRL,
            KeyCode::A => OsCode::KEY_A,
            KeyCode::S => OsCode::KEY_S,
            KeyCode::D => OsCode::KEY_D,
            KeyCode::F => OsCode::KEY_F,
            KeyCode::G => OsCode::KEY_G,
            KeyCode::H => OsCode::KEY_H,
            KeyCode::J => OsCode::KEY_J,
            KeyCode::K => OsCode::KEY_K,
            KeyCode::L => OsCode::KEY_L,
            KeyCode::SColon => OsCode::KEY_SEMICOLON,
            KeyCode::Quote => OsCode::KEY_APOSTROPHE,
            KeyCode::Grave => OsCode::KEY_GRAVE,
            KeyCode::LShift => OsCode::KEY_LEFTSHIFT,
            KeyCode::Bslash => OsCode::KEY_BACKSLASH,
            KeyCode::Z => OsCode::KEY_Z,
            KeyCode::X => OsCode::KEY_X,
            KeyCode::C => OsCode::KEY_C,
            KeyCode::V => OsCode::KEY_V,
            KeyCode::B => OsCode::KEY_B,
            KeyCode::N => OsCode::KEY_N,
            KeyCode::M => OsCode::KEY_M,
            KeyCode::Comma => OsCode::KEY_COMMA,
            KeyCode::Dot => OsCode::KEY_DOT,
            KeyCode::Slash => OsCode::KEY_SLASH,
            KeyCode::RShift => OsCode::KEY_RIGHTSHIFT,
            KeyCode::KpAsterisk => OsCode::KEY_KPASTERISK,
            KeyCode::LAlt => OsCode::KEY_LEFTALT,
            KeyCode::Space => OsCode::KEY_SPACE,
            KeyCode::CapsLock => OsCode::KEY_CAPSLOCK,
            KeyCode::F1 => OsCode::KEY_F1,
            KeyCode::F2 => OsCode::KEY_F2,
            KeyCode::F3 => OsCode::KEY_F3,
            KeyCode::F4 => OsCode::KEY_F4,
            KeyCode::F5 => OsCode::KEY_F5,
            KeyCode::F6 => OsCode::KEY_F6,
            KeyCode::F7 => OsCode::KEY_F7,
            KeyCode::F8 => OsCode::KEY_F8,
            KeyCode::F9 => OsCode::KEY_F9,
            KeyCode::F10 => OsCode::KEY_F10,
            KeyCode::NumLock => OsCode::KEY_NUMLOCK,
            KeyCode::ScrollLock => OsCode::KEY_SCROLLLOCK,
            KeyCode::Kp7 => OsCode::KEY_KP7,
            KeyCode::Kp8 => OsCode::KEY_KP8,
            KeyCode::Kp9 => OsCode::KEY_KP9,
            KeyCode::KpMinus => OsCode::KEY_KPMINUS,
            KeyCode::Kp4 => OsCode::KEY_KP4,
            KeyCode::Kp5 => OsCode::KEY_KP5,
            KeyCode::Kp6 => OsCode::KEY_KP6,
            KeyCode::KpPlus => OsCode::KEY_KPPLUS,
            KeyCode::Kp1 => OsCode::KEY_KP1,
            KeyCode::Kp2 => OsCode::KEY_KP2,
            KeyCode::Kp3 => OsCode::KEY_KP3,
            KeyCode::Kp0 => OsCode::KEY_KP0,
            KeyCode::KpDot => OsCode::KEY_KPDOT,
            KeyCode::F11 => OsCode::KEY_F11,
            KeyCode::F12 => OsCode::KEY_F12,
            KeyCode::KpEnter => OsCode::KEY_KPENTER,
            KeyCode::RCtrl => OsCode::KEY_RIGHTCTRL,
            KeyCode::KpSlash => OsCode::KEY_KPSLASH,
            KeyCode::SysReq => OsCode::KEY_SYSRQ,
            KeyCode::RAlt => OsCode::KEY_RIGHTALT,
            KeyCode::Home => OsCode::KEY_HOME,
            KeyCode::Up => OsCode::KEY_UP,
            KeyCode::PgUp => OsCode::KEY_PAGEUP,
            KeyCode::Left => OsCode::KEY_LEFT,
            KeyCode::Right => OsCode::KEY_RIGHT,
            KeyCode::End => OsCode::KEY_END,
            KeyCode::Down => OsCode::KEY_DOWN,
            KeyCode::PgDown => OsCode::KEY_PAGEDOWN,
            KeyCode::Insert => OsCode::KEY_INSERT,
            KeyCode::Delete => OsCode::KEY_DELETE,
            KeyCode::Mute => OsCode::KEY_MUTE,
            KeyCode::VolDown => OsCode::KEY_VOLUMEDOWN,
            KeyCode::VolUp => OsCode::KEY_VOLUMEUP,
            KeyCode::Power => OsCode::KEY_POWER,
            KeyCode::KpEqual => OsCode::KEY_KPEQUAL,
            KeyCode::Pause => OsCode::KEY_PAUSE,
            KeyCode::KpComma => OsCode::KEY_KPCOMMA,
            KeyCode::LGui => OsCode::KEY_LEFTMETA,
            KeyCode::RGui => OsCode::KEY_RIGHTMETA,
            KeyCode::Stop => OsCode::KEY_STOP,
            KeyCode::Again => OsCode::KEY_AGAIN,
            KeyCode::Undo => OsCode::KEY_UNDO,
            KeyCode::Copy => OsCode::KEY_COPY,
            KeyCode::Paste => OsCode::KEY_PASTE,
            KeyCode::Find => OsCode::KEY_FIND,
            KeyCode::Cut => OsCode::KEY_CUT,
            KeyCode::Help => OsCode::KEY_HELP,
            KeyCode::Menu => OsCode::KEY_MENU,
            KeyCode::MediaCalc => OsCode::KEY_CALC,
            KeyCode::MediaSleep => OsCode::KEY_SLEEP,
            KeyCode::MediaWWW => OsCode::KEY_WWW,
            KeyCode::MediaCoffee => OsCode::KEY_COFFEE,
            KeyCode::MediaBack => OsCode::KEY_BACK,
            KeyCode::MediaForward => OsCode::KEY_FORWARD,
            KeyCode::MediaEjectCD => OsCode::KEY_EJECTCD,
            KeyCode::MediaNextSong => OsCode::KEY_NEXTSONG,
            KeyCode::MediaPlayPause => OsCode::KEY_PLAYPAUSE,
            KeyCode::MediaPreviousSong => OsCode::KEY_PREVIOUSSONG,
            KeyCode::MediaStopCD => OsCode::KEY_STOPCD,
            KeyCode::MediaRefresh => OsCode::KEY_REFRESH,
            KeyCode::MediaEdit => OsCode::KEY_EDIT,
            KeyCode::MediaScrollUp => OsCode::KEY_SCROLLUP,
            KeyCode::MediaScrollDown => OsCode::KEY_SCROLLDOWN,
            KeyCode::F13 => OsCode::KEY_F13,
            KeyCode::F14 => OsCode::KEY_F14,
            KeyCode::F15 => OsCode::KEY_F15,
            KeyCode::F16 => OsCode::KEY_F16,
            KeyCode::F17 => OsCode::KEY_F17,
            KeyCode::F18 => OsCode::KEY_F18,
            KeyCode::F19 => OsCode::KEY_F19,
            KeyCode::F20 => OsCode::KEY_F20,
            KeyCode::F21 => OsCode::KEY_F21,
            KeyCode::F22 => OsCode::KEY_F22,
            KeyCode::F23 => OsCode::KEY_F23,
            KeyCode::F24 => OsCode::KEY_F24,
            KeyCode::PScreen => OsCode::KEY_PRINT,
            KeyCode::AltErase => OsCode::KEY_ALTERASE,
            KeyCode::Cancel => OsCode::KEY_CANCEL,
            KeyCode::MediaMute => OsCode::KEY_MICMUTE,
            _ => OsCode::KEY_UNKNOWN,
        }
    }
}

impl From<&KeyCode> for OsCode {
    fn from(item: &KeyCode) -> Self {
        (*item).into()
    }
}

impl From<OsCode> for KeyCode {
    fn from(item: OsCode) -> KeyCode {
        match item {
            OsCode::KEY_ESC => KeyCode::Escape,
            OsCode::KEY_1 => KeyCode::Kb1,
            OsCode::KEY_2 => KeyCode::Kb2,
            OsCode::KEY_3 => KeyCode::Kb3,
            OsCode::KEY_4 => KeyCode::Kb4,
            OsCode::KEY_5 => KeyCode::Kb5,
            OsCode::KEY_6 => KeyCode::Kb6,
            OsCode::KEY_7 => KeyCode::Kb7,
            OsCode::KEY_8 => KeyCode::Kb8,
            OsCode::KEY_9 => KeyCode::Kb9,
            OsCode::KEY_0 => KeyCode::Kb0,
            OsCode::KEY_MINUS => KeyCode::Minus,
            OsCode::KEY_EQUAL => KeyCode::Equal,
            OsCode::KEY_BACKSPACE => KeyCode::BSpace,
            OsCode::KEY_TAB => KeyCode::Tab,
            OsCode::KEY_Q => KeyCode::Q,
            OsCode::KEY_W => KeyCode::W,
            OsCode::KEY_E => KeyCode::E,
            OsCode::KEY_R => KeyCode::R,
            OsCode::KEY_T => KeyCode::T,
            OsCode::KEY_Y => KeyCode::Y,
            OsCode::KEY_U => KeyCode::U,
            OsCode::KEY_I => KeyCode::I,
            OsCode::KEY_O => KeyCode::O,
            OsCode::KEY_P => KeyCode::P,
            OsCode::KEY_LEFTBRACE => KeyCode::LBracket,
            OsCode::KEY_RIGHTBRACE => KeyCode::RBracket,
            OsCode::KEY_ENTER => KeyCode::Enter,
            OsCode::KEY_LEFTCTRL => KeyCode::LCtrl,
            OsCode::KEY_A => KeyCode::A,
            OsCode::KEY_S => KeyCode::S,
            OsCode::KEY_D => KeyCode::D,
            OsCode::KEY_F => KeyCode::F,
            OsCode::KEY_G => KeyCode::G,
            OsCode::KEY_H => KeyCode::H,
            OsCode::KEY_J => KeyCode::J,
            OsCode::KEY_K => KeyCode::K,
            OsCode::KEY_L => KeyCode::L,
            OsCode::KEY_SEMICOLON => KeyCode::SColon,
            OsCode::KEY_APOSTROPHE => KeyCode::Quote,
            OsCode::KEY_GRAVE => KeyCode::Grave,
            OsCode::KEY_LEFTSHIFT => KeyCode::LShift,
            OsCode::KEY_BACKSLASH => KeyCode::Bslash,
            OsCode::KEY_Z => KeyCode::Z,
            OsCode::KEY_X => KeyCode::X,
            OsCode::KEY_C => KeyCode::C,
            OsCode::KEY_V => KeyCode::V,
            OsCode::KEY_B => KeyCode::B,
            OsCode::KEY_N => KeyCode::N,
            OsCode::KEY_M => KeyCode::M,
            OsCode::KEY_COMMA => KeyCode::Comma,
            OsCode::KEY_DOT => KeyCode::Dot,
            OsCode::KEY_SLASH => KeyCode::Slash,
            OsCode::KEY_RIGHTSHIFT => KeyCode::RShift,
            OsCode::KEY_KPASTERISK => KeyCode::KpAsterisk,
            OsCode::KEY_LEFTALT => KeyCode::LAlt,
            OsCode::KEY_SPACE => KeyCode::Space,
            OsCode::KEY_CAPSLOCK => KeyCode::CapsLock,
            OsCode::KEY_F1 => KeyCode::F1,
            OsCode::KEY_F2 => KeyCode::F2,
            OsCode::KEY_F3 => KeyCode::F3,
            OsCode::KEY_F4 => KeyCode::F4,
            OsCode::KEY_F5 => KeyCode::F5,
            OsCode::KEY_F6 => KeyCode::F6,
            OsCode::KEY_F7 => KeyCode::F7,
            OsCode::KEY_F8 => KeyCode::F8,
            OsCode::KEY_F9 => KeyCode::F9,
            OsCode::KEY_F10 => KeyCode::F10,
            OsCode::KEY_NUMLOCK => KeyCode::NumLock,
            OsCode::KEY_SCROLLLOCK => KeyCode::ScrollLock,
            OsCode::KEY_KP7 => KeyCode::Kp7,
            OsCode::KEY_KP8 => KeyCode::Kp8,
            OsCode::KEY_KP9 => KeyCode::Kp9,
            OsCode::KEY_KPMINUS => KeyCode::KpMinus,
            OsCode::KEY_KP4 => KeyCode::Kp4,
            OsCode::KEY_KP5 => KeyCode::Kp5,
            OsCode::KEY_KP6 => KeyCode::Kp6,
            OsCode::KEY_KPPLUS => KeyCode::KpPlus,
            OsCode::KEY_KP1 => KeyCode::Kp1,
            OsCode::KEY_KP2 => KeyCode::Kp2,
            OsCode::KEY_KP3 => KeyCode::Kp3,
            OsCode::KEY_KP0 => KeyCode::Kp0,
            OsCode::KEY_KPDOT => KeyCode::KpDot,
            OsCode::KEY_F11 => KeyCode::F11,
            OsCode::KEY_F12 => KeyCode::F12,
            OsCode::KEY_KPENTER => KeyCode::KpEnter,
            OsCode::KEY_RIGHTCTRL => KeyCode::RCtrl,
            OsCode::KEY_KPSLASH => KeyCode::KpSlash,
            OsCode::KEY_SYSRQ => KeyCode::SysReq,
            OsCode::KEY_RIGHTALT => KeyCode::RAlt,
            OsCode::KEY_HOME => KeyCode::Home,
            OsCode::KEY_UP => KeyCode::Up,
            OsCode::KEY_PAGEUP => KeyCode::PgUp,
            OsCode::KEY_LEFT => KeyCode::Left,
            OsCode::KEY_RIGHT => KeyCode::Right,
            OsCode::KEY_END => KeyCode::End,
            OsCode::KEY_DOWN => KeyCode::Down,
            OsCode::KEY_PAGEDOWN => KeyCode::PgDown,
            OsCode::KEY_INSERT => KeyCode::Insert,
            OsCode::KEY_DELETE => KeyCode::Delete,
            OsCode::KEY_MUTE => KeyCode::Mute,
            OsCode::KEY_VOLUMEDOWN => KeyCode::VolDown,
            OsCode::KEY_VOLUMEUP => KeyCode::VolUp,
            OsCode::KEY_POWER => KeyCode::Power,
            OsCode::KEY_KPEQUAL => KeyCode::KpEqual,
            OsCode::KEY_PAUSE => KeyCode::Pause,
            OsCode::KEY_KPCOMMA => KeyCode::KpComma,
            OsCode::KEY_LEFTMETA => KeyCode::LGui,
            OsCode::KEY_RIGHTMETA => KeyCode::RGui,
            OsCode::KEY_STOP => KeyCode::Stop,
            OsCode::KEY_AGAIN => KeyCode::Again,
            OsCode::KEY_UNDO => KeyCode::Undo,
            OsCode::KEY_COPY => KeyCode::Copy,
            OsCode::KEY_PASTE => KeyCode::Paste,
            OsCode::KEY_FIND => KeyCode::Find,
            OsCode::KEY_CUT => KeyCode::Cut,
            OsCode::KEY_HELP => KeyCode::Help,
            OsCode::KEY_MENU => KeyCode::Menu,
            OsCode::KEY_CALC => KeyCode::MediaCalc,
            OsCode::KEY_SLEEP => KeyCode::MediaSleep,
            OsCode::KEY_WWW => KeyCode::MediaWWW,
            OsCode::KEY_COFFEE => KeyCode::MediaCoffee,
            OsCode::KEY_BACK => KeyCode::MediaBack,
            OsCode::KEY_FORWARD => KeyCode::MediaForward,
            OsCode::KEY_EJECTCD => KeyCode::MediaEjectCD,
            OsCode::KEY_NEXTSONG => KeyCode::MediaNextSong,
            OsCode::KEY_PLAYPAUSE => KeyCode::MediaPlayPause,
            OsCode::KEY_PREVIOUSSONG => KeyCode::MediaPreviousSong,
            OsCode::KEY_STOPCD => KeyCode::MediaStopCD,
            OsCode::KEY_REFRESH => KeyCode::MediaRefresh,
            OsCode::KEY_EDIT => KeyCode::MediaEdit,
            OsCode::KEY_SCROLLUP => KeyCode::MediaScrollUp,
            OsCode::KEY_SCROLLDOWN => KeyCode::MediaScrollDown,
            OsCode::KEY_F13 => KeyCode::F13,
            OsCode::KEY_F14 => KeyCode::F14,
            OsCode::KEY_F15 => KeyCode::F15,
            OsCode::KEY_F16 => KeyCode::F16,
            OsCode::KEY_F17 => KeyCode::F17,
            OsCode::KEY_F18 => KeyCode::F18,
            OsCode::KEY_F19 => KeyCode::F19,
            OsCode::KEY_F20 => KeyCode::F20,
            OsCode::KEY_F21 => KeyCode::F21,
            OsCode::KEY_F22 => KeyCode::F22,
            OsCode::KEY_F23 => KeyCode::F23,
            OsCode::KEY_F24 => KeyCode::F24,
            OsCode::KEY_PRINT => KeyCode::PScreen,
            OsCode::KEY_ALTERASE => KeyCode::AltErase,
            OsCode::KEY_CANCEL => KeyCode::Cancel,
            OsCode::KEY_MICMUTE => KeyCode::MediaMute,
            _ => KeyCode::No,
        }
    }
}

impl From<&OsCode> for KeyCode {
    fn from(item: &OsCode) -> KeyCode {
        (*item).into()
    }
}

impl From<EventCode> for OsCode {
    fn from(item: EventCode) -> Self {
        match item {
            EventCode::EV_KEY(evkey) => Self::from(evkey),
            _ => unreachable!(),
        }
    }
}

impl From<OsCode> for EventCode {
    fn from(item: OsCode) -> Self {
        let evkey = item.into();
        EventCode::EV_KEY(evkey)
    }
}

impl From<EV_KEY> for OsCode {
    fn from(item: EV_KEY) -> Self {
        (item as u32).into()
    }
}

impl From<OsCode> for EV_KEY {
    fn from(item: OsCode) -> Self {
        evdev_rs::enums::int_to_ev_key(item as u32)
            .unwrap_or_else(|| panic!("Invalid KeyCode: {}", item as u32))
    }
}

// ------------------ KeyValue --------------------

#[derive(Copy, Clone, Debug, PartialEq, Eq)]
pub enum KeyValue {
    Release = 0,
    Press = 1,
    Repeat = 2,
}

impl From<i32> for KeyValue {
    fn from(item: i32) -> Self {
        match item {
            0 => Self::Release,
            1 => Self::Press,
            2 => Self::Repeat,
            _ => unreachable!(),
        }
    }
}

#[derive(Debug)]
pub struct KeyEvent {
    pub time: TimeVal,
    pub code: OsCode,
    pub value: KeyValue,
}

impl KeyEvent {
    pub fn new(code: OsCode, value: KeyValue) -> Self {
        let time = TimeVal::new(0, 0);
        Self { time, code, value }
    }
}

impl TryFrom<InputEvent> for KeyEvent {
    type Error = ();
    fn try_from(item: InputEvent) -> Result<Self, Self::Error> {
        match &item.event_type {
            EventType::EV_KEY => Ok(Self {
                time: item.time,
                code: item.event_code.into(),
                value: item.value.into(),
            }),
            _ => Err(()),
        }
    }
}

impl From<KeyEvent> for InputEvent {
    fn from(item: KeyEvent) -> Self {
        Self {
            time: item.time,
            event_type: EventType::EV_KEY,
            event_code: item.code.into(),
            value: item.value as i32,
        }
    }
}
