use kalast::{Time, MINIMUM_PRECISION};
use tool::DAY;

#[test]
fn creation_time_vector() {
    let dur = 1. * DAY;
    let dt = 30.;
    let time = Time::new(dur, dt);

    assert_eq!(time.size(), 2881);
    assert!(relative_eq!(
        time.duration(),
        dur,
        epsilon = MINIMUM_PRECISION
    ));
    assert!(relative_eq!(
        time.time_step(),
        dt,
        epsilon = MINIMUM_PRECISION
    ));
    assert!(relative_eq!(
        time.time_step_between(0, 1),
        dt,
        epsilon = MINIMUM_PRECISION
    ));
    assert!(relative_eq!(time[0], 0., epsilon = MINIMUM_PRECISION));
    assert!(relative_eq!(
        time[time.size() - 1],
        dur,
        epsilon = MINIMUM_PRECISION
    ));
}
