/// [Solar flux constant](https://en.wikipedia.org/wiki/Solar_constant)
pub const SOLAR_CONSTANT: f64 = 1365.0;
/// [Stefan-Bolztmann constant](https://en.wikipedia.org/wiki/Stefan-Boltzmann_constant)
pub const STEFAN_BOLTZMANN: f64 = 5.670374419e-8;
/// Defines a stability condition for heat transfert.
pub const NUMERICAL_STABILITY: f64 = 0.25;
/// Threshold that defines a range to consider a point as on the equator or the prime meridian.
pub const SPHERICAL_THRESHOLD: f64 = 3e-2;
/// Number of thermal skin depth to consider for coherent ground adiabatic condition.
pub const NUMBER_THERMAL_SKIN_DEPTH: usize = 8;
/// Minimum precision trusted in the computation.
pub const MINIMUM_PRECISION: f64 = 1e-6;
