fn main() {
    // Initialize the library.
    let mut kalast = kalast::init();

    // System center of mass position.
    kalast.set_system_position(-tool::Vector::new(1.0, 0.0, 0.0) * tool::ASTRONAUMICAL_UNIT * 1.0);

    // Define the targeted body.
    kalast.add_body(
        "Target",              // name
        None,                  // frame
        tool::Vector::zeros(), // relative position to center of mass
        kalast::Properties::new(
            11.92 * tool::HOUR, // revolution period
            0.,                 // obliquity
            500.,               // thermal inertia
            2146.,              // density
            600.,               // heat capacity
            0.07,               // albedo
            0.9,                // emissivity
        ),
        Some("rsc/obj/sphere_light.obj"), // path to 3D mesh
    );

    // Define another body.
    kalast.add_body(
        "Second asteroid",                        // name
        None,                                     // frame
        tool::Vector::new(0.0, 1.0, 0.0) * 1.5e3, // relative position to center of mass
        kalast::Properties::new(
            11.92 * tool::HOUR, // revolution period
            0.,                 // obliquity
            500.,               // thermal inertia
            2146.,              // density
            600.,               // heat capacity
            0.07,               // albedo
            0.9,                // emissivity
        ),
        Some("rsc/obj/sphere_light.obj"), // path to 3D mesh
    );

    // Set simulation duration and time step.
    kalast.set_time_with_revolution_target(30.0, 10.0 * tool::MINUTE);

    // Start the simulation.
    kalast.start();

    let temperatures = kalast.get_target().surface_temperatures();
    println!(
        "Surface temperatures> max: {:.2}, min: {:.2}",
        temperatures.max(),
        temperatures.min()
    );
}
