fn main() {
    // Initialize the library.
    let mut kalast = kalast::init();

    // System center of mass position.
    kalast.set_system_position(tool::Vector::new(1.0, 0.0, 0.0) * tool::ASTRONAUMICAL_UNIT * 1.664);

    // Add a body to the system without a mesh.
    kalast.add_body(
        "Asteroid low resolution", // name
        None,                      // frame
        tool::Vector::zeros(),     // relative position to center of mass
        kalast::Properties::new(
            11.92 * tool::HOUR,      // revolution period
            0.0 * tool::TAU / 360.0, // obliquity
            500.,                    // thermal inertia
            2146.,                   // density
            600.,                    // heat capacity
            0.07,                    // albedo
            0.9,                     // emissivity
        ),
        Some("rsc/obj/ellipsoid_light.obj"), // path to 3D mesh
    );

    // Some configurations about the system.
    kalast.enable_self_heating(false);

    // Set simulation duration and time step.
    kalast.set_time_with_revolution_target(30.0, 10.0 * tool::MINUTE);

    // Some configuration for exporting before running the simulation.
    kalast.export_surface(true);

    // Start the simulation.
    kalast.start();

    // Some prints.
    let temp = kalast.get_target().surface_temperatures();
    println!(
        "Surface temperatures > max: {:.2} K, min: {:.2} K",
        temp.max(),
        temp.min()
    );
}
