fn main() {
    // Initialize the library.
    let mut kalast = kalast::init();

    // System center of mass position.
    kalast.set_system_position(-tool::Vector::new(1.0, 0.0, 0.0) * tool::ASTRONAUMICAL_UNIT * 1.0);

    // Add a body to the system.
    kalast.add_body(
        "Asteroid",            // name
        None,                  // frame
        tool::Vector::zeros(), // relative position to center of mass
        kalast::Properties::new(
            11.92 * tool::HOUR,        // revolution period
            162.0 * tool::TAU / 180.0, // obliquity
            500.,                      // thermal inertia
            2146.,                     // density
            600.,                      // heat capacity
            0.07,                      // albedo
            0.9,                       // emissivity
        ),
        Some("rsc/obj/ellipsoid.obj"), // path to 3D mesh
    );

    // Some configurations about the system.
    kalast.enable_self_heating(false);

    let mut latitudes_row = kalast
        .get_target()
        .object
        .sphericals()
        .row(1)
        .abs()
        .into_owned();
    let latitudes = latitudes_row.as_mut_slice();
    latitudes.sort_by(|a, b| a.partial_cmp(b).unwrap());
    println!("{:?}", latitudes);

    // Mask to match all latitudes under the given value.
    kalast.get_target_mut().object.set_equator_mask(Some(0.011));

    println!("{}", kalast.get_target().object.sphericals().transpose());
    println!("{}", kalast.get_target().object.faces_mask_true_indices());
}
