fn main() {
    // Initialize the library.
    let mut kalast = kalast::init();

    let rotation = 11.92 * tool::HOUR;
    let duration = 50.0 * tool::DAY;

    // System center of mass position.
    kalast.set_system_name("DIDYMOS_BARYCENTER");
    kalast.set_system_frame("DIDYMOS_FIXED");
    kalast.set_kernel_system(
        "rsc/kernels/hera_study_PO_EA_2026.tm",
        "ECLIPJ2000",
        "SUN",
        "2027-MAR-23 16:00:00",
    );

    // Add a body to the system without a mesh.
    kalast.add_body(
        "DIMORPHOS",             // name
        Some("DIMORPHOS_FIXED"), // frame
        tool::Vector::zeros(),   // relative position to center of mass
        kalast::Properties::new(
            rotation, // revolution period
            0.0,      // obliquity
            500.,     // thermal inertia
            2146.,    // density
            600.,     // heat capacity
            0.07,     // albedo
            0.9,      // emissivity
        ),
        Some("rsc/obj/g_08438mm_lgt_obj_didb_0000n00000_v002.obj"), // path to 3D mesh
    );

    kalast.get_target_mut().object.apply_factor(1e3);

    // Some configurations about the system.
    kalast.enable_self_heating(false);

    // Set simulation duration and time step.
    kalast.set_time(duration, 10.0 * tool::MINUTE);

    // Some configuration for exporting before running the simulation.
    kalast.export_surface(true);
    kalast.export_end_prime_noon(true);
    kalast.export_path("rsc/data/tmp/dimorphos.json");

    // Start the simulation.
    kalast.start();

    // Temperatures at the end.
    let temp = kalast.get_target().surface_temperatures();
    println!(
        "Surface temperatures > max: {:.2} K, min: {:.2} K",
        temp.max(),
        temp.min()
    );

    kalast.kernel.as_mut().unwrap().unload().unwrap();
}
