use nalgebra::Matrix3;

fn main() {
    // Initialize the library.
    let mut kalast = kalast::init();

    // System center of mass position.
    kalast.set_system_position(-tool::Vector::new(1.0, 0.0, 0.0) * tool::ASTRONAUMICAL_UNIT * 1.1);

    // Add a body to the system without a mesh.
    kalast.add_body(
        "Asteroid",            // name
        None,                  // frame
        tool::Vector::zeros(), // relative position to center of mass
        kalast::Properties::new(
            6.0 * tool::HOUR, // revolution period
            0.0,              // obliquity
            1000.0,           // thermal inertia 1000
            2146.0,           // density
            600.0,            // heat capacity
            0.1,              // albedo
            0.9,              // emissivity
        ),
        None, // path to 3D mesh
    );

    // Create one facet located centered in longitude=latitude=0° of 2 m².
    kalast
        .get_target_mut()
        .new_face(Matrix3::from_column_slice(&[
            100.0,      // vertex 1 x
            -2.0 / 3.0, //          y
            2.0 / 3.0,  //          z
            100.0,      // vertex 2 x
            -2.0 / 3.0, //          y
            -4.0 / 3.0, //          z
            100.0,      // vertex 3 x
            4.0 / 3.0,  //          y
            2.0 / 3.0,  //          z
        ]));

    // Apply obliquity on new facets.
    kalast.get_target_mut().initiate_obliquity();

    // Some configurations about the system.
    kalast.enable_self_heating(false);

    // Set simulation duration and time step.
    kalast.set_time_with_revolution_target(20.0, 1.0 * tool::MINUTE);

    // Some configuration for exporting before running the simulation.
    kalast.export_surface(true);
    kalast.export_last_day(true);

    // Start the simulation.
    kalast.start();

    println!("{}", kalast.get_target().surface_temperatures());
}
