use nalgebra::Matrix3;

fn main() {
    // Initialize the library.
    let mut kalast = kalast::init();

    // System center of mass position.
    kalast.set_system_position(-tool::Vector::new(1.0, 0.0, 0.0) * tool::ASTRONAUMICAL_UNIT * 1.0);

    // Add a body to the system without a mesh.
    kalast.add_body(
        "Asteroid",            // name
        None,                  // frame
        tool::Vector::zeros(), // relative position to center of mass
        kalast::Properties::new(
            11.92 * tool::HOUR, // revolution period
            0.,                 // obliquity
            500.,               // thermal inertia
            2146.,              // density
            600.,               // heat capacity
            0.07,               // albedo
            0.9,                // emissivity
        ),
        None, // path to 3D mesh
    );

    // Create one facet located centered in longitude=latitude=0° of 2 m².
    kalast
        .get_body_mut("Asteroid")
        .new_face(Matrix3::from_column_slice(&[
            100.0,      // vertex 1 x
            -2.0 / 3.0, //          y
            2.0 / 3.0,  //          z
            100.0,      // vertex 2 x
            -2.0 / 3.0, //          y
            -4.0 / 3.0, //          z
            100.0,      // vertex 3 x
            4.0 / 3.0,  //          y
            2.0 / 3.0,  //          z
        ]));

    // Some configurations about the system.
    kalast.enable_self_heating(false);

    // Set simulation duration and time step.
    kalast.set_time_with_revolution_target(30.0, 10.0 * tool::MINUTE);

    // Start the simulation.
    kalast.start();

    println!(
        "\nGround temperatures: {}",
        kalast.get_target().ground_temperatures().transpose()
    );

    // In the future, this function should allow the user to set a mask to get only the point at
    // longitude=latitude=0°. For now, it just prints the closest point to the desired one, showing
    // off that the created face is well indeed at longitude=latitude=0°.
    kalast.get_target_mut().object.set_longitude_latitude_zero();
}
