# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## TODO

+ convergence kernel first data: spin around frozen position
+ set ground step instead of time step
+ simulation of other missions' asteroid: Bennu, Hayabusa2 (with their data)
+ do Neumann analytical validation
+ 3D conduction
+ finite element
+ multiple ground material on same asteroid (by region)
+ allow square region focus on the ground
+ use elevation map for ground roughness
+ occultations & shadowing
+ include YORP effect
+ inversion model to predict properties
+ study model with filters
+ provide a CLI binary executable
+ parallel computation of view factor

## [Unreleased]

## [0.2.4] - 2021-04-26

### Changed

+ now using nalgebra 0.26
+ changed obliquity axial tilt for solstices and equinoxes validations

## [0.2.3] - 2021-04-14

### Added

+ documentation
+ changes of rustool 0.3.5
+ exact hour angle

## [0.2.2] - 2021-04-08

### Added

+ examples (e.g. dimorphos case using kernels)

### Changed

+ tests more efficients
+ using rustool crate for matrix types and toolbox related to that

### Removed

+ matplotlib from crate, it can be an external crate later on, or just use json
  export and read from python directly

## [0.2.1] - 2021-03-22

### Added

+ export manager properties
+ export feature for ground temperatures, surface temperatures and last period
+ mesh information on export

### Fixed

+ tests float comparisons
+ tests fails not stopping pre-commit

## [0.2.0] - 2021-03-16

### Added

+ struct "ExportManager" managings the data to export, now in json format
+ backtrace setting to compile script
+ example with matplotlib
+ more configuration to toggle solar flux, self and mutual heating

### Changed

+ renamed module "base" to "core"
+ renamed module "math" to "numerical_algorithm"
+ moved distance and direction computations to module "geometry"
+ global refactoring of the library:
  + introduce module "kalast" responsible for the management of the whole library,
    instead of the
    previous "World" struct. It delegates some responsibilities to lower level structs.
  + simplified the generic environement system with a new struct "System"
  + moved some methods previouly in "Body" to "System"
+ moved screen prints to the struct "Information" to ease the reading and avoid flood
+ upgraded every examples with kalast v0.2.0

### Fixed

+ pre-commit type filtering for version control

## [0.1.9] - 2021-03-11

### Added

+ computation of global temperature at equilibrium (used to get a first guess of
  temperatures)
+ a logging crate to focus print for user
+ bindings to matplotlib and python with pyo3, graph can now be plotted directly
  on kalast
+ access deepest ground temperatures
+ pre-commit hooks to check README demo code, check that all versions in the repo
  are the same as Cargo.toml's version, lint and execute unit and integration tests
  before commit, and publish at push
+ markdown style configuration files
+ clippy configuration files
+ more comments in binary source file
+ new_face wrapper in body to call object_3d new_face method and automatize the recomputation
+ gitignore rule for logs

### Changed

+ much cleaner temperature structure: merge ground, surface and masked temperatures
  into single matrix ground temperatures
+ the reference to the surface temperatures can be obtained by getting the first
  row of the ground temperatures matrix, or directly with the method
  surface_temperatures, but now it is a slice and not a reference to a vector. To
  still get a vector, you can get a cloned version from the method
  surface_temperatures_as_vec.
+ moved TODO list from README to CHANGELOG
+ README usage doc
+ Newton's method constant moved to toolbox/math
+ compile script is now written in python with click and the subprocess library to
  call shell commands
+ shorten simulation time in example simple

### Fixed

+ after some changes in the properties of a body, some other dependent parameters
  were not updating
+ README demo code according to recent changes
+ native markdown in README instead of html
+ README usage and installation sections
+ a bug where the last revolution was not detected correctly and the daily
  temperatures were not recorded at the good time, due to time step and revolution
  period
+ float comparisons with threshold at multiple locations in the library
+ log file name not static
+ main function in library main description
+ copy instead of clone for float in world
+ raw string without arguments should not be format

### Removed

+ some unnecessary files in repo
+ lifetime parameter where unneeded in time
+ unneeded map for some iters in object_3d
+ unneeded reference to float in body

## [0.1.8] - 2021-03-04

### Added

+ dirichlet example (analytical comparison)
+ example to apply mask
+ physics module in toolbox to compute complex ground parameters without the whole
  process of creatng a body
+ tool to the matrix toolbox to easily convert 1D slice to vector
+ world can simulate without sun for quick thermal conduction for dirichlet and
  other problems
+ world and body now supports adiabatic condition for lowest and surface layer +
  fixed temperature condition
+ comments to conduction for layers
+ possibility to save daily temperature of the last revolution (one point only for
  now)
+ add more mask to object3d

### Changed

+ README
+ world is not responsible anymore for ground temperatures matrix, it is given the
  body itself
+ improve world time loop structure, divided into functions for reading convenience

### Fixed

+ skip first iteration of time loop as it is the initialization state
+ time step NAN fixed when no duration, the time struct now saves the time step to
  ensure to good creation of matrices
+ fix recompute issue where temperature matrix size were not updating

## [<=0.1.7] - 2021-03-04

### Added

+ 1D conduction
+ surface heat flux from Sun
+ view factor
+ self heating
+ mutual heating
+ export data to text file
+ choice between single asteroid or binary system of asteroids
+ 3D mesh wavefront reader
+ compute normals, sphericals coordinates
+ apply mask to focus on region at the surface
+ simple rotation system
+ simple obliquity system
