use super::*;

impl AWSCluster {
    #[must_use]
    #[deprecated(note = "Use `region` instead", since = "0.1.4")]
    pub fn set_region(self, region: impl ToString) -> Self {
        Self {
            spec: AWSClusterSpec {
                region: Some(region.to_string()),
                ..self.spec
            },
            ..self
        }
    }

    #[must_use]
    #[deprecated(note = "Use `sshkey` instead", since = "0.1.4")]
    pub fn set_sshkey(self, sshkey: impl ToString) -> Self {
        Self {
            spec: AWSClusterSpec {
                ssh_key_name: Some(sshkey.to_string()),
                ..self.spec
            },
            ..self
        }
    }

    #[must_use]
    #[deprecated(note = "Use `vpc_cidr_block` instead", since = "0.1.4")]
    pub fn set_vpc_cidr_block(self, vpc_cidr_block: impl ToString) -> Self {
        let vpc_cidr_block = vpc_cidr_block.to_string();
        let network = self.spec.network.unwrap_or_default();
        let vpc = network.vpc.unwrap_or_default();
        let vpc = VPCSpec {
            cidr_block: Some(vpc_cidr_block),
            ..vpc
        };
        let network = NetworkSpec {
            vpc: Some(vpc),
            ..network
        };

        Self {
            spec: AWSClusterSpec {
                network: Some(network),
                ..self.spec
            },
            ..self
        }
    }
}
