use std::collections::BTreeMap;

use k8s_openapi::api::core::v1 as corev1;
use k8s_openapi::apiextensions_apiserver::pkg::apis::apiextensions::v1 as apiextensionsv1;
use k8s_openapi::apimachinery::pkg::apis::meta::v1 as metav1;
use serde::{Deserialize, Serialize};
use serde_with::skip_serializing_none;

pub use cluster::ClusterIpFamily;
pub use cluster::ClusterPhase;
pub use cluster::InvalidIpFamily;
pub use cluster::*;

use crate::errors as capierrors;

pub mod cluster;
pub mod infrastructure;
