use std::collections::BTreeMap;

use k8s_openapi::api::core::v1 as corev1;
use k8s_openapi::apiextensions_apiserver::pkg::apis::apiextensions::v1 as apiextensionsv1;
use k8s_openapi::apimachinery::pkg::apis::meta::v1 as metav1;
use serde::{Deserialize, Serialize};
use serde_with::skip_serializing_none;

pub use cluster::ClusterIpFamily;
pub use cluster::InvalidIpFamily;
pub use cluster::*;
pub use common::*;
pub use condition::*;
pub use phase::ClusterPhase;

use crate::errors as capierrors;

mod cluster;
mod common;
mod condition;
mod phase;

// #[derive(Clone, Debug, Serialize, Deserialize, Default)]
// pub struct Cluster {
//     pub metadata: metav1::ObjectMeta,
//     pub spec: Option<ClusterSpec>,
//     pub status: Option<ClusterStatus>,
// }
