use super::*;

impl MachineDeployment {
    pub fn with_cluster_name(name: &str, cluster_name: &str) -> Self {
        let spec = MachineDeploymentSpec::new(cluster_name).replicas(3);
        Self::new(name, spec)
    }

    pub fn machine_template(mut self, machine_template: &MachineTemplate) -> Self {
        let infrastructure_ref = machine_template.object_ref();
        let mut spec = self.spec.template.spec.take().unwrap_or_default();
        spec.infrastructure_ref = infrastructure_ref;
        self.spec.template.spec = Some(spec);
        self
    }

    pub fn version(mut self, version: &str) -> Self {
        let mut spec = self.spec.template.spec.take().unwrap_or_default();
        spec.version = Some(version.to_string());
        self.spec.template.spec = Some(spec);
        self
    }

    pub fn bootstrap_config_ref(mut self, template: &ControlPlaneConfigTemplate) -> Self {
        let config_ref = template.object_ref();
        let mut spec = self.spec.template.spec.take().unwrap_or_default();
        spec.bootstrap.config_ref = Some(config_ref);
        self.spec.template.spec = Some(spec);
        self
    }
}

impl MachineDeploymentSpec {
    pub fn new(cluster_name: &str) -> Self {
        let spec = MachineSpec::new(cluster_name);
        let template = MachineTemplateSpec {
            spec: Some(spec),
            ..MachineTemplateSpec::default()
        };
        let cluster_name = cluster_name.to_string();
        Self {
            cluster_name,
            template,
            // replicas: todo!(),
            // selector: todo!(),
            // strategy: todo!(),
            // min_ready_seconds: todo!(),
            // revision_history_limit: todo!(),
            // paused: todo!(),
            // progress_deadline_seconds: todo!(),
            ..Self::default()
        }
    }

    pub fn replicas(mut self, replicas: i32) -> Self {
        self.replicas = Some(replicas);
        self
    }

    pub fn template(mut self, template: MachineTemplateSpec) -> Self {
        self.template = template;
        self
    }
}
