use std::fmt;

use super::*;

impl fmt::Display for NetworkRanges {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}", self.cidr_blocks.join(","))
    }
}

impl ClusterStatus {
    pub fn phase(&self) -> ClusterPhase {
        self.phase.unwrap_or(ClusterPhase::Unknown)
    }
}

impl ApiEndpoint {
    /// IsZero returns true if both host and port are zero values.
    pub fn is_zero(&self) -> bool {
        self.host.is_empty() && self.port == 0
    }

    /// IsValid returns true if both host and port are non-zero values.
    pub fn is_valid(&self) -> bool {
        !self.host.is_empty() && self.port != 0
    }
}

impl fmt::Display for ApiEndpoint {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}:{}", self.host, self.port)
    }
}
