use super::*;
use maplit::{btreemap, convert_args};

impl KubeadmConfigTemplate {
    pub fn aws(&self, name: &str) -> Self {
        let spec = KubeadmConfigTemplateSpec {
            template: KubeadmConfigTemplateResource {
                spec: KubeadmConfigSpec {
                    join_configuration: Some(JoinConfiguration {
                        node_registration: Some(NodeRegistrationOptions {
                            kubelet_extra_args: convert_args!(btreemap!("cloud-provider" => "aws")),
                            ..Default::default()
                        }),
                        ..Default::default()
                    }),
                    ..Default::default()
                },
                ..Default::default()
            },
            ..Default::default()
        };
        Self::new(name, spec)
    }
}
