use kube::Resource;

use super::*;

impl ControlPlaneConfigTemplate {
    pub fn object_ref(&self) -> corev1::ObjectReference {
        match self {
            ControlPlaneConfigTemplate::Kubeadm(kubeadm) => kubeadm.object_ref(&()),
        }
    }
}

impl ControlPlane {
    pub fn object_ref(&self) -> corev1::ObjectReference {
        match self {
            ControlPlane::Kubeadm(kubeadm) => kubeadm.object_ref(&()),
        }
    }
}

impl Infrastructure {
    pub fn object_ref(&self) -> corev1::ObjectReference {
        match self {
            Infrastructure::Aws(aws) => aws.object_ref(&()),
        }
    }
}

impl MachineTemplate {
    pub fn object_ref(&self) -> corev1::ObjectReference {
        match self {
            MachineTemplate::Aws(aws) => aws.object_ref(&()),
        }
    }
}
