use super::*;

impl AWSClusterSpec {
    pub fn region(&self) -> Option<&str> {
        self.region.as_deref()
    }

    pub fn network(&self) -> Option<&NetworkSpec> {
        self.network.as_ref()
    }

    pub fn vpc(&self) -> Option<&VPCSpec> {
        self.network().and_then(|network| network.vpc.as_ref())
    }

    pub fn vpc_id(&self) -> Option<&str> {
        self.vpc().and_then(|vpc| vpc.id.as_deref())
    }
}

impl AWSClusterStatus {
    pub fn ready(&self) -> bool {
        self.ready
    }
    pub fn network(&self) -> Option<&NetworkStatus> {
        self.network_status.as_ref()
    }
}
