# junitify

[![junitify on crates.io](https://img.shields.io/crates/v/junitify)](https://crates.io/crates/junitify) ![pipeline](https://gitlab.com/Kores/junitify/badges/master/pipeline.svg)

junitify takes JSON tests from stdin and writes JUnit XML results into stdout, or into a directory specified with `--out`.

This can be used to integrate with CI/CD platforms that uses JUnit XML format to show tests results in the UI, such as Gitlab.

## Installation

```shell
cargo install junitify
```

## Example

```shell
cargo test -- --format=json -Z unstable-options --report-time | junitify --out tests/
```

## Valgrind (Since `0.1.13`)

Since `0.1.13` you can transform Valgrind XML report into JUnit reports, for example:

**fish.shell**
```fish
valgrind --tool=memcheck --xml=yes --xml-file=report.xml (cargo +nightly test -q --message-format=json --no-run | jq -r '.executable | select(. != null)') 
junitify -k valgrind --out tests/ -f report.xml
```

## Non-Zero exit code (Since `0.1.14`)

Since `0.1.14`, you can now use `-z` to make **junitify** exit with a non-zero code when tests fail,
also you can use `-r` to report all tests to stdout.

## JUnit XML (Since `0.1.14`)

Since `0.1.14`, **junitify** is able to read the JUnit XML produced by itself, in companion with `-z` and `-r`,
it will print tests results and exit with a non-zero code when there are failed tests.

JUnit XML parser works in the same way as the other parsers, it reads JUnit XML and outputs JUnit XML, it may change
its contents and structure, and remove a bunch of values (in case of XMLs that were not generated by **junitify**).

## New XML generator (Since `0.1.14`)

Instead of using Handlebars, we now use [quick-xml](https://crates.io/crates/quick-xml) to generate XML, this
will help with preserving the original output of tests without applying strange indentation, at the same time
it provides a more maintainable code based more on serde.

We will be removing the handlebars dependency in the future (removed in `0.1.15`).

## Ignore parsing errors (Since `0.1.15`)

Sometimes, the tests prints messages to the Stdout and Stderr, and they are piped to the Cargo output,
mixing with the test suite output, this causes **junitify** to fail when parsing the output. To overcome this, you
can use `-i` or `--ignore-parse-errors` to ignore parsing errors.

Be aware that, if the Cargo output json format changes (and it will, since `--format=json` is unstable), the **junitify**
will ignore them instead of crashing, so only use it when your tests output are messing with the output of `cargo test`.

Example with `-i`:

```shell
cargo test -- --format=json -Z unstable-options --report-time | junitify -i --out tests/
```

Read the full changelog here [Junitify 0.1.15 Changelog](https://gitlab.com/Kores/junitify/-/releases/0.1.15)

## CI/CD Docker Image

```shell
docker pull jonathanxd/junitify:latest
```

## CI/CD Example

You can find an example of CI/CD usage in [bindet .gitlab-ci.yml](https://gitlab.com/Kores/bindet/-/blob/88a7b51511504a3c46564e9907a60f6f5dafa748/.gitlab-ci.yml#L35-50), and see how they look like in 
[one of the pipeline reports](https://gitlab.com/Kores/bindet/-/pipelines/377091154/test_report).