# junitify

[![junitify on crates.io](https://img.shields.io/crates/v/junitify)](https://crates.io/crates/junitify) ![pipeline](https://gitlab.com/Kores/junitify/badges/master/pipeline.svg)

junitify takes JSON tests from stdin and writes JUnit XML results into stdout, or into a directory specified with `--out`.

This can be used to integrate with CI/CD platforms that uses JUnit XML format to show tests results in the UI, such as Gitlab.

## Installation

```shell
cargo install junitify
```

## Example

```shell
cargo test -- --format=json -Z unstable-options --report-time | junitify --out tests/
```

## CI/CD Docker Image

```shell
docker pull jonathanxd/junitify:latest
```

## CI/CD Example

You can find an example of CI/CD usage in [bindet .gitlab-ci.yml](https://gitlab.com/Kores/bindet/-/blob/88a7b51511504a3c46564e9907a60f6f5dafa748/.gitlab-ci.yml#L35-50), and see how they look like in 
[one of the pipeline reports](https://gitlab.com/Kores/bindet/-/pipelines/377091154/test_report).