//! Provides functionality for Cap'n Proto (de)serialization.

pub trait CapnpWrite<'a> {
    /// The Builder that was autogenerated by capnp.
    type Builder;

    /// Write the struct into the message that is being built by the Builder.
    fn write_capnp(&self, builder: &mut Self::Builder);
}

pub trait CapnpRead<'a> {
    /// The Reader that was autogenerated by capnp.
    type Reader;

    /// Read the struct from the Reader.
    fn read_capnp(reader: Self::Reader) -> Self;
}
