use super::device_trait::Device;
pub struct Tensor<D: Device> {
    buffer: D,
}
impl<D: Device> Tensor<D> {
    pub fn new(values: Vec<f32>) -> Self {
        Self {
            buffer: D::new(values),
        }
    }
    pub fn to<D2: Device>(&self) -> Tensor<D2> {
        Tensor {
            buffer: D2::new(self.buffer.get().clone()),
        }
    }
}

impl<D: Device> std::fmt::Debug for Tensor<D> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct(format!("Tensor<{}>", D::device_info()).as_str())
            .field("values", &self.buffer.get())
            .finish()
    }
}
